/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.common.MetaDataMap;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfexplorer.glue.PerformanceResult;
import edu.uoregon.tau.perfexplorer.server.PerfExplorerServer;
import java.util.Hashtable;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrialMetadata {
    private Hashtable<String, String> commonAttributes = new Hashtable();
    private Hashtable<String, Double> accumulator = new Hashtable();
    private Trial trial = null;
    private PerformanceResult performanceResult = null;

    public TrialMetadata(int n) {
        this.trial = PerfExplorerServer.getServer().getSession().setTrial(n, false);
        this.getMetadata();
    }

    public TrialMetadata(Trial trial) {
        this.trial = trial;
        this.getMetadata();
    }

    public TrialMetadata(PerformanceResult performanceResult) {
        this.trial = performanceResult.getTrial();
        this.performanceResult = performanceResult;
        this.getMetadata();
    }

    private void getMetadata() {
        try {
            MetaDataMap metaDataMap = this.trial.getMetaData();
            for (MetaDataMap.MetaDataKey metaDataKey : metaDataMap.keySet()) {
                MetaDataMap.MetaDataValue metaDataValue = metaDataMap.get(metaDataKey);
                this.commonAttributes.put(metaDataKey.name, metaDataValue.value.toString());
            }
            this.commonAttributes.put("Trial.Name", this.trial.getName());
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    public Hashtable<String, String> getCommonAttributes() {
        return this.commonAttributes;
    }

    public void setCommonAttributes(Hashtable<String, String> hashtable) {
        this.commonAttributes = hashtable;
    }

    public Trial getTrial() {
        return this.trial;
    }

    public void setTrial(Trial trial) {
        this.trial = trial;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Set<String> set = this.commonAttributes.keySet();
        for (String string : set) {
            stringBuilder.append(string + ": " + this.commonAttributes.get(string) + "\n");
        }
        return stringBuilder.toString();
    }
}

