/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfexplorer.glue;

import edu.uoregon.tau.perfdmf.Application;
import edu.uoregon.tau.perfdmf.Database;
import edu.uoregon.tau.perfdmf.DatabaseAPI;
import edu.uoregon.tau.perfdmf.Experiment;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Trial;
import edu.uoregon.tau.perfdmf.View;
import edu.uoregon.tau.perfdmf.database.DB;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerClient;
import edu.uoregon.tau.perfexplorer.client.PerfExplorerModel;
import edu.uoregon.tau.perfexplorer.common.RMISortableIntervalEvent;
import edu.uoregon.tau.perfexplorer.server.PerfExplorerServer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utilities {
    private static boolean isSet = false;

    public static Trial getTrialFromView(View view, String string) {
        boolean bl = false;
        PerfExplorerServer perfExplorerServer = Utilities.getServer();
        ArrayList<View> arrayList = new ArrayList<View>();
        arrayList.add(view);
        List<Trial> list = perfExplorerServer.getTrialsForView(arrayList, false);
        for (Trial trial : list) {
            System.out.println(trial);
            if (!trial.getName().trim().equals(string.trim())) continue;
            if (!trial.isXmlMetaDataLoaded()) {
                try {
                    trial.loadXMLMetadata(perfExplorerServer.getDB());
                }
                catch (SQLException sQLException) {
                    System.err.println("Error getting metadata for trial");
                    sQLException.printStackTrace();
                }
            }
            return trial;
        }
        bl = true;
        return null;
    }

    public static List<Trial> getTrialByName(String string) {
        boolean bl = false;
        PerfExplorerServer perfExplorerServer = Utilities.getServer();
        String string2 = "";
        boolean bl2 = false;
        string2 = string2 + " where t.name = '" + string + "'";
        Vector vector = Trial.getTrialList((DB)perfExplorerServer.getDB(), (String)string2, (boolean)false);
        bl = true;
        return vector;
    }

    public static List<Trial> getTrialsFromMetadata(Map<String, String> map, String string) {
        boolean bl = false;
        PerfExplorerServer perfExplorerServer = Utilities.getServer();
        String string2 = "";
        int n = 0;
        for (String string3 : map.keySet()) {
            string2 = string2 + " inner join primary_metadata pm" + n + " on pm" + n;
            string2 = string2 + ".trial = t.id and pm" + n;
            string2 = string2 + ".name = '" + string3 + "' ";
            ++n;
        }
        string2 = string2 + " where ";
        n = 0;
        for (String string3 : map.keySet()) {
            if (n > 0) {
                string2 = string2 + string;
            }
            string2 = string2 + "pm" + n + ".value " + map.get(string3) + " ";
            ++n;
        }
        Vector vector = Trial.getTrialList((DB)perfExplorerServer.getDB(), (String)string2, (boolean)false);
        bl = true;
        return vector;
    }

    public static Trial getTrial(String string, String string2, String string3) {
        boolean bl = false;
        PerfExplorerServer perfExplorerServer = Utilities.getServer();
        List<Application> list = perfExplorerServer.getApplicationList();
        for (Application application : list) {
            if (!application.getName().equals(string)) continue;
            List<Experiment> list2 = perfExplorerServer.getExperimentList(application.getID());
            for (Experiment experiment : list2) {
                if (!experiment.getName().trim().equals(string2.trim())) continue;
                List<Trial> list3 = perfExplorerServer.getTrialList(experiment.getID(), false);
                for (Trial trial : list3) {
                    if (!trial.getName().trim().equals(string3.trim())) continue;
                    if (!trial.isXmlMetaDataLoaded()) {
                        try {
                            trial.loadXMLMetadata(perfExplorerServer.getDB());
                        }
                        catch (SQLException sQLException) {
                            System.err.println("Error getting metadata for trial");
                            sQLException.printStackTrace();
                        }
                    }
                    return trial;
                }
                System.out.println("Could not find trial: " + string3);
                bl = true;
            }
            if (!bl) {
                System.out.println("Could not find experiment: " + string2);
            }
            bl = true;
        }
        if (!bl) {
            System.out.println("Could not find application: " + string);
        }
        return null;
    }

    public static List<View> getViews() {
        boolean bl = false;
        PerfExplorerServer perfExplorerServer = Utilities.getServer();
        return perfExplorerServer.getViews(0);
    }

    public static List<View> getSubViews(View view) {
        boolean bl = false;
        PerfExplorerServer perfExplorerServer = Utilities.getServer();
        return perfExplorerServer.getViews(view.getID());
    }

    public static List<View> getAllViews() {
        boolean bl = false;
        PerfExplorerServer perfExplorerServer = Utilities.getServer();
        return perfExplorerServer.getAllSubViews(0);
    }

    public static void createView(String string, boolean bl, List<View.ViewRule> list) {
        Utilities.createSubView(string, bl, -1, list);
    }

    public static void createSubView(String string, boolean bl, int n, List<View.ViewRule> list) {
        PerfExplorerServer perfExplorerServer = Utilities.getServer();
        DB dB = perfExplorerServer.getDB();
        try {
            View.createView((DB)dB, (String)string, (boolean)bl, (int)n, list);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public static View getView(String string) {
        boolean bl = false;
        PerfExplorerServer perfExplorerServer = Utilities.getServer();
        List<View> list = perfExplorerServer.getAllSubViews(0);
        View view = new View();
        for (View view2 : list) {
            if (!view2.toString().equals(string)) continue;
            view = view2;
            break;
        }
        return view;
    }

    public static View getSubView(View view, String string) {
        boolean bl = false;
        PerfExplorerServer perfExplorerServer = Utilities.getServer();
        List<View> list = perfExplorerServer.getAllSubViews(view.getID());
        View view2 = new View();
        for (View view3 : list) {
            if (!view3.toString().equals(string)) continue;
            view2 = view3;
            break;
        }
        return view2;
    }

    public static List<Trial> getTrialsForView(View view) {
        return Utilities.getTrialsForView(view, false);
    }

    public static List<Trial> getTrialsForView(View view, boolean bl) {
        boolean bl2 = false;
        PerfExplorerServer perfExplorerServer = Utilities.getServer();
        ArrayList<View> arrayList = new ArrayList<View>();
        for (View view2 = view.getParent(); view2 != null; view2 = view2.getParent()) {
            arrayList.add(view2);
        }
        arrayList.add(view);
        return perfExplorerServer.getTrialsForTAUdbView(arrayList, bl);
    }

    public static List<Trial> getTrialsForExperiment(String string, String string2) {
        boolean bl = false;
        PerfExplorerServer perfExplorerServer = Utilities.getServer();
        List<Application> list = perfExplorerServer.getApplicationList();
        for (Application application : list) {
            if (!application.getName().equals(string)) continue;
            List<Experiment> list2 = perfExplorerServer.getExperimentList(application.getID());
            for (Experiment experiment : list2) {
                if (!experiment.getName().trim().equals(string2.trim())) continue;
                List<Trial> list3 = perfExplorerServer.getTrialList(experiment.getID(), false);
                for (Trial trial : list3) {
                    if (trial.isXmlMetaDataLoaded()) continue;
                    try {
                        trial.loadXMLMetadata(perfExplorerServer.getDB());
                    }
                    catch (SQLException sQLException) {
                        System.err.println("Error getting metadata for trial");
                        sQLException.printStackTrace();
                    }
                }
                return list3;
            }
            if (!bl) {
                System.out.println("Could not find experiment: " + string2);
            }
            bl = true;
        }
        if (!bl) {
            System.out.println("Could not find application: " + string);
        }
        return null;
    }

    public static void deleteTrial(Trial trial) {
        boolean bl = false;
        PerfExplorerServer perfExplorerServer = Utilities.getServer();
        try {
            Trial.deleteTrial((DB)perfExplorerServer.getDB(), (int)trial.getID());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void saveMetric(Trial trial, Metric metric) {
        boolean bl = false;
        if (metric != null) {
            Database database = Utilities.getServer().getDB().getDatabase();
            DatabaseAPI databaseAPI = new DatabaseAPI();
            try {
                databaseAPI.initialize(database);
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            if (databaseAPI != null) {
                databaseAPI.saveTrial(trial, metric);
                databaseAPI.terminate();
            }
        }
    }

    public static List<Application> getApplications() {
        boolean bl = false;
        PerfExplorerServer perfExplorerServer = Utilities.getServer();
        return perfExplorerServer.getApplicationList();
    }

    public static List<Experiment> getExperimentsForApplication(String string) {
        boolean bl = true;
        PerfExplorerServer perfExplorerServer = Utilities.getServer();
        List<Application> list = perfExplorerServer.getApplicationList();
        for (Application application : list) {
            if (!application.getName().equals(string)) continue;
            List<Experiment> list2 = perfExplorerServer.getExperimentList(application.getID());
            return list2;
        }
        if (!bl) {
            System.out.println("Could not find application: " + string);
        }
        return null;
    }

    public static Trial getCurrentTrial() {
        Trial trial = PerfExplorerModel.getModel().getTrial();
        if (trial == null) {
            System.out.println("Utilities.getCurrentTrial() failed: No trial selected.");
        }
        return trial;
    }

    private static PerfExplorerServer getServer() {
        return PerfExplorerServer.getServer(null, "", "");
    }

    private static PerfExplorerServer getServer(String string, String string2) {
        String string3 = System.getProperty("user.home");
        String string4 = System.getProperty("file.separator");
        String string5 = string3 + string4 + ".ParaProf" + string4 + "perfdmf.cfg";
        if (string != null && string.length() > 0) {
            string5 = string5 + "." + string;
        }
        return PerfExplorerServer.getServer(string5, string2, "");
    }

    public static JFrame getClient() {
        String string = System.getProperty("user.home");
        String string2 = System.getProperty("file.separator");
        String string3 = string + string2 + ".ParaProf" + string2 + "perfdmf.cfg";
        PerfExplorerClient perfExplorerClient = new PerfExplorerClient(true, string3, true);
        perfExplorerClient.pack();
        perfExplorerClient.setVisible(true);
        return perfExplorerClient;
    }

    public static int setSession(String string) {
        try {
            if (isSet) {
                PerfExplorerServer.hardResetServer();
            }
            PerfExplorerServer perfExplorerServer = Utilities.getServer(string, "");
            isSet = true;
            List<String> list = perfExplorerServer.getConfigNames();
            for (int i = 0; i < perfExplorerServer.getSessionCount(); ++i) {
                perfExplorerServer.setConnectionIndex(i);
                String string2 = list.get(i);
                if (!string2.equals(string) && (string != null && string.length() != 0 || !string2.endsWith("/perfdmf.cfg"))) continue;
                perfExplorerServer.getSchemaVersion(i);
                return i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public static LinkedHashMap<String, Double> sortHashMapByValues(Map<String, Double> map, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>(map.keySet());
        ArrayList<Double> arrayList2 = new ArrayList<Double>(map.values());
        Collections.sort(arrayList2);
        Collections.sort(arrayList);
        if (!bl) {
            Collections.reverse(arrayList2);
        }
        LinkedHashMap<String, Double> linkedHashMap = new LinkedHashMap<String, Double>();
        block0: for (Double d : arrayList2) {
            for (String string : arrayList) {
                if (!map.get(string).toString().equals(d.toString())) continue;
                map.remove(string);
                arrayList.remove(string);
                linkedHashMap.put(string, d);
                continue block0;
            }
        }
        return linkedHashMap;
    }

    public static List<RMISortableIntervalEvent> getEventsForTrial(Trial trial, int n) {
        List<RMISortableIntervalEvent> list = null;
        PerfExplorerServer perfExplorerServer = Utilities.getServer();
        list = perfExplorerServer.getEventList(trial.getID(), n);
        return list;
    }

    public static String shortenEventName(String string) {
        int n;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "(");
        String string2 = null;
        try {
            string2 = stringTokenizer.nextToken();
            if (string2.length() < string.length()) {
                string2 = string2 + "()";
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            string2 = string;
        }
        string = string2;
        int n2 = string.indexOf(" [{");
        string2 = n2 >= 0 ? ((n = string.lastIndexOf("/")) >= 0 ? string.substring(0, n2 + 3) + string.substring(n + 1, string.length()) : string.substring(0, n2)) : string;
        string2 = string2.replace("[OPENMP] ", "");
        string2 = string2.replace("OpenMP_", "");
        return string2.trim();
    }
}

