/*
 * Decompiled with CFR 0.152.
 */
package scalasca.cubex.cube.datalayout.data;

import scalasca.cubex.cube.datalayout.data.CompressedDataRows;
import scalasca.cubex.cube.datalayout.data.DataRows;
import scalasca.cubex.cube.datalayout.data.value.Value;
import scalasca.cubex.cube.errors.BadCubeReportLayoutException;
import scalasca.cubex.cube.services.transformation.Endianess;

public class DataChooser {
    private static String Marker = "CUBEX.DATA";
    private static String ZMarker = "ZCUBEX.DATA";

    public static DataRows getDataRows(byte[] byArray, Value value, Endianess endianess) throws BadCubeReportLayoutException {
        String string;
        String string2 = string = byArray.length > Marker.length() ? new String(byArray, 0, ZMarker.length()) : new String(byArray, 0, Marker.length());
        if (string.substring(0, Marker.length()).equalsIgnoreCase(Marker)) {
            return new DataRows(DataChooser.removeMarker(Marker.length(), byArray), value, endianess);
        }
        if (string.substring(0, ZMarker.length()).equalsIgnoreCase(ZMarker)) {
            return new CompressedDataRows(DataChooser.removeMarker(ZMarker.length(), byArray), value, endianess);
        }
        throw new BadCubeReportLayoutException("Data doesn't start with correct marker. Expect " + Marker + " or " + ZMarker + " but it starts with " + string);
    }

    private static byte[] removeMarker(int n, byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length - n];
        System.arraycopy(byArray, n, byArray2, 0, byArray.length - n);
        return byArray2;
    }
}

