/*
 * Decompiled with CFR 0.152.
 */
package scalasca.cubex.cube.datalayout.data.value;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import scalasca.cubex.cube.datalayout.data.value.Value;
import scalasca.cubex.cube.errors.WrongNumberOfValueParametersException;
import scalasca.cubex.cube.services.transformation.Endianess;

public class CubeDouble
extends Value {
    protected double value;

    public CubeDouble() {
        this.value = 0.0;
    }

    public CubeDouble(double d) {
        this.value = d;
    }

    @Override
    public String getName() {
        return "DOUBLE";
    }

    @Override
    public String toString() {
        return Double.valueOf(this.value).toString();
    }

    @Override
    public int size() {
        return 8;
    }

    @Override
    public void correctEndianess(Endianess endianess, DataInputStream dataInputStream, DataOutputStream dataOutputStream) throws IOException {
        long l = dataInputStream.readLong();
        long l2 = endianess.applyOn(l);
        dataOutputStream.writeDouble(Double.longBitsToDouble(l2));
    }

    @Override
    public Value clone() {
        return new CubeDouble();
    }

    @Override
    public Value copy() {
        return new CubeDouble(this.value);
    }

    @Override
    public Value clone(DataInputStream dataInputStream) throws IOException {
        return new CubeDouble(dataInputStream.readDouble());
    }

    @Override
    public void setValue(String string) {
        this.value = Double.parseDouble(string);
    }

    @Override
    public void setValue(byte by) {
        this.value = by;
    }

    @Override
    public void setValue(short s) {
        this.value = s;
    }

    @Override
    public void setValue(int n) {
        this.value = n;
    }

    @Override
    public void setValue(long l) {
        this.value = l;
    }

    @Override
    public void setValue(double d) {
        this.value = d;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public void addValue(Value value) {
        CubeDouble cubeDouble = (CubeDouble)value;
        this.value += cubeDouble.value;
    }

    @Override
    public void subtractValue(Value value) {
        CubeDouble cubeDouble = (CubeDouble)value;
        this.value -= cubeDouble.value;
    }

    @Override
    public void setValueParameters(Vector<Double> vector) throws WrongNumberOfValueParametersException {
    }
}

