/*
 * Decompiled with CFR 0.152.
 */
package scalasca.cubex.cube.datalayout.data.value;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import scalasca.cubex.cube.datalayout.data.value.Value;
import scalasca.cubex.cube.errors.WrongNumberOfValueParametersException;
import scalasca.cubex.cube.services.transformation.Endianess;

public class CubeInt32
extends Value {
    protected int value;

    public CubeInt32() {
        this.value = 0;
    }

    public CubeInt32(int n) {
        this.value = n;
    }

    @Override
    public String getName() {
        return "INT32";
    }

    @Override
    public String toString() {
        return Integer.valueOf(this.value).toString();
    }

    @Override
    public int size() {
        return 4;
    }

    @Override
    public void correctEndianess(Endianess endianess, DataInputStream dataInputStream, DataOutputStream dataOutputStream) throws IOException {
        int n = dataInputStream.readInt();
        int n2 = endianess.applyOn(n);
        dataOutputStream.writeInt(n2);
    }

    @Override
    public Value clone() {
        return new CubeInt32();
    }

    @Override
    public Value copy() {
        return new CubeInt32(this.value);
    }

    @Override
    public Value clone(DataInputStream dataInputStream) throws IOException {
        return new CubeInt32(dataInputStream.readInt());
    }

    @Override
    public void setValue(String string) {
        this.value = Integer.parseInt(string);
    }

    @Override
    public void setValue(byte by) {
        this.value = by;
    }

    @Override
    public void setValue(short s) {
        this.value = s;
    }

    @Override
    public void setValue(int n) {
        this.value = n;
    }

    @Override
    public void setValue(long l) {
        this.value = (int)l;
    }

    @Override
    public void setValue(double d) {
        this.value = (int)d;
    }

    @Override
    public double getDouble() {
        return Integer.valueOf(this.value).doubleValue();
    }

    @Override
    public void addValue(Value value) {
        CubeInt32 cubeInt32 = (CubeInt32)value;
        this.value += cubeInt32.value;
    }

    @Override
    public void subtractValue(Value value) {
        CubeInt32 cubeInt32 = (CubeInt32)value;
        this.value -= cubeInt32.value;
    }

    @Override
    public void setValueParameters(Vector<Double> vector) throws WrongNumberOfValueParametersException {
    }
}

