/*
 * Decompiled with CFR 0.152.
 */
package scalasca.cubex.cube.datalayout.data.value;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import scalasca.cubex.cube.datalayout.data.value.Value;
import scalasca.cubex.cube.errors.WrongNumberOfValueParametersException;
import scalasca.cubex.cube.services.transformation.Endianess;

public class CubeInt64
extends Value {
    protected long value;

    public CubeInt64() {
        this.value = 0L;
    }

    public CubeInt64(long l) {
        this.value = l;
    }

    @Override
    public String getName() {
        return "INT64";
    }

    @Override
    public String toString() {
        return Long.valueOf(this.value).toString();
    }

    @Override
    public int size() {
        return 8;
    }

    @Override
    public void correctEndianess(Endianess endianess, DataInputStream dataInputStream, DataOutputStream dataOutputStream) throws IOException {
        long l = dataInputStream.readLong();
        long l2 = endianess.applyOn(l);
        dataOutputStream.writeLong(l2);
    }

    @Override
    public Value clone() {
        return new CubeInt64();
    }

    @Override
    public Value copy() {
        return new CubeInt64(this.value);
    }

    @Override
    public Value clone(DataInputStream dataInputStream) throws IOException {
        return new CubeInt64(dataInputStream.readLong());
    }

    @Override
    public void setValue(String string) {
        this.value = Long.parseLong(string);
    }

    @Override
    public void setValue(byte by) {
        this.value = by;
    }

    @Override
    public void setValue(short s) {
        this.value = s;
    }

    @Override
    public void setValue(int n) {
        this.value = n;
    }

    @Override
    public void setValue(long l) {
        this.value = l;
    }

    @Override
    public void setValue(double d) {
        this.value = (long)d;
    }

    @Override
    public double getDouble() {
        return Long.valueOf(this.value).doubleValue();
    }

    @Override
    public void addValue(Value value) {
        CubeInt64 cubeInt64 = (CubeInt64)value;
        this.value += cubeInt64.value;
    }

    @Override
    public void subtractValue(Value value) {
        CubeInt64 cubeInt64 = (CubeInt64)value;
        this.value -= cubeInt64.value;
    }

    @Override
    public void setValueParameters(Vector<Double> vector) throws WrongNumberOfValueParametersException {
    }
}

