/*
 * Decompiled with CFR 0.152.
 */
package scalasca.cubex.cube.datalayout.data.value;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import scalasca.cubex.cube.datalayout.data.value.Value;
import scalasca.cubex.cube.errors.WrongNumberOfValueParametersException;
import scalasca.cubex.cube.services.transformation.Endianess;

public class CubeInt8
extends Value {
    protected byte value;

    public CubeInt8() {
        this.value = 0;
    }

    public CubeInt8(byte by) {
        this.value = by;
    }

    @Override
    public String getName() {
        return "INT8";
    }

    @Override
    public String toString() {
        return Byte.valueOf(this.value).toString();
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public void correctEndianess(Endianess endianess, DataInputStream dataInputStream, DataOutputStream dataOutputStream) throws IOException {
        byte by = dataInputStream.readByte();
        byte by2 = endianess.applyOn(by);
        dataOutputStream.writeByte(by2);
    }

    @Override
    public Value clone() {
        return new CubeInt8();
    }

    @Override
    public Value copy() {
        return new CubeInt8(this.value);
    }

    @Override
    public Value clone(DataInputStream dataInputStream) throws IOException {
        return new CubeInt8(dataInputStream.readByte());
    }

    @Override
    public void setValue(String string) {
        this.value = Byte.parseByte(string);
    }

    @Override
    public void setValue(byte by) {
        this.value = by;
    }

    @Override
    public void setValue(short s) {
        this.value = (byte)s;
    }

    @Override
    public void setValue(int n) {
        this.value = (byte)n;
    }

    @Override
    public void setValue(long l) {
        this.value = (byte)l;
    }

    @Override
    public void setValue(double d) {
        this.value = (byte)d;
    }

    @Override
    public double getDouble() {
        return Byte.valueOf(this.value).doubleValue();
    }

    @Override
    public void addValue(Value value) {
        CubeInt8 cubeInt8 = (CubeInt8)value;
        this.value = (byte)(this.value + cubeInt8.value);
    }

    @Override
    public void subtractValue(Value value) {
        CubeInt8 cubeInt8 = (CubeInt8)value;
        this.value = (byte)(this.value - cubeInt8.value);
    }

    @Override
    public void setValueParameters(Vector<Double> vector) throws WrongNumberOfValueParametersException {
    }
}

