/*
 * Decompiled with CFR 0.152.
 */
package scalasca.cubex.cube.datalayout.data.value;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import scalasca.cubex.cube.datalayout.data.value.CubeDouble;
import scalasca.cubex.cube.datalayout.data.value.Value;
import scalasca.cubex.cube.errors.WrongNumberOfValueParametersException;

public class CubeMaxDouble
extends CubeDouble {
    public CubeMaxDouble() {
        this.value = -1.7976931348623157E308;
    }

    public CubeMaxDouble(double d) {
        this.value = d;
    }

    @Override
    public String getName() {
        return "MAXDOUBLE";
    }

    @Override
    public Value clone() {
        return new CubeMaxDouble();
    }

    @Override
    public Value copy() {
        return new CubeMaxDouble(this.value);
    }

    @Override
    public Value clone(DataInputStream dataInputStream) throws IOException {
        return new CubeMaxDouble(dataInputStream.readDouble());
    }

    @Override
    public void addValue(Value value) {
        CubeMaxDouble cubeMaxDouble = (CubeMaxDouble)value;
        this.value = Math.max(this.value, cubeMaxDouble.value);
    }

    @Override
    public void subtractValue(Value value) {
        CubeMaxDouble cubeMaxDouble = (CubeMaxDouble)value;
        this.value = Math.min(this.value, cubeMaxDouble.value);
    }

    @Override
    public void setValueParameters(Vector<Double> vector) throws WrongNumberOfValueParametersException {
    }
}

