/*
 * Decompiled with CFR 0.152.
 */
package scalasca.cubex.cube.datalayout.data.value;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import scalasca.cubex.cube.datalayout.data.value.CubeDouble;
import scalasca.cubex.cube.datalayout.data.value.Value;
import scalasca.cubex.cube.errors.WrongNumberOfValueParametersException;

public class CubeMinDouble
extends CubeDouble {
    public CubeMinDouble() {
        this.value = Double.MAX_VALUE;
    }

    public CubeMinDouble(double d) {
        this.value = d;
    }

    @Override
    public String getName() {
        return "MINDOUBLE";
    }

    @Override
    public Value clone() {
        return new CubeMinDouble();
    }

    @Override
    public Value copy() {
        return new CubeMinDouble(this.value);
    }

    @Override
    public Value clone(DataInputStream dataInputStream) throws IOException {
        return new CubeMinDouble(dataInputStream.readDouble());
    }

    @Override
    public void addValue(Value value) {
        CubeMinDouble cubeMinDouble = (CubeMinDouble)value;
        this.value = Math.min(this.value, cubeMinDouble.value);
    }

    @Override
    public void subtractValue(Value value) {
        CubeMinDouble cubeMinDouble = (CubeMinDouble)value;
        this.value = Math.max(this.value, cubeMinDouble.value);
    }

    @Override
    public void setValueParameters(Vector<Double> vector) throws WrongNumberOfValueParametersException {
    }
}

