/*
 * Decompiled with CFR 0.152.
 */
package scalasca.cubex.cube.datalayout.data.value;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import scalasca.cubex.cube.datalayout.data.value.Value;
import scalasca.cubex.cube.errors.WrongNumberOfValueParametersException;
import scalasca.cubex.cube.services.transformation.Endianess;

public class CubeUint8
extends Value {
    protected short value;

    public CubeUint8() {
        this.value = 0;
    }

    public CubeUint8(byte by) {
        this.value = by;
    }

    @Override
    public String getName() {
        return "UINT8";
    }

    @Override
    public String toString() {
        return Short.valueOf(this.value).toString();
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public void correctEndianess(Endianess endianess, DataInputStream dataInputStream, DataOutputStream dataOutputStream) throws IOException {
        byte by = dataInputStream.readByte();
        byte by2 = endianess.applyOn(by);
        dataOutputStream.writeByte(by2);
    }

    @Override
    public Value clone() {
        return new CubeUint8();
    }

    @Override
    public Value copy() {
        return new CubeUint8((byte)this.value);
    }

    @Override
    public Value clone(DataInputStream dataInputStream) throws IOException {
        return new CubeUint8(dataInputStream.readByte());
    }

    @Override
    public void setValue(String string) {
        this.value = Short.parseShort(string);
    }

    @Override
    public void setValue(byte by) {
        this.value = by;
    }

    @Override
    public void setValue(short s) {
        this.value = s;
    }

    @Override
    public void setValue(int n) {
        this.value = (short)n;
    }

    @Override
    public void setValue(long l) {
        this.value = (short)l;
    }

    @Override
    public void setValue(double d) {
        this.value = (short)d;
    }

    @Override
    public double getDouble() {
        return Short.valueOf(this.value).doubleValue();
    }

    @Override
    public void addValue(Value value) {
        CubeUint8 cubeUint8 = (CubeUint8)value;
        this.value = (short)(this.value + cubeUint8.value);
    }

    @Override
    public void subtractValue(Value value) {
        CubeUint8 cubeUint8 = (CubeUint8)value;
        this.value = (short)(this.value - cubeUint8.value);
    }

    @Override
    public void setValueParameters(Vector<Double> vector) throws WrongNumberOfValueParametersException {
    }
}

