/*
 * Decompiled with CFR 0.152.
 */
package scalasca.cubex.cube.datalayout.data.value;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import scalasca.cubex.cube.datalayout.data.value.CubeComplex;
import scalasca.cubex.cube.datalayout.data.value.CubeDouble;
import scalasca.cubex.cube.datalayout.data.value.CubeHistogram;
import scalasca.cubex.cube.datalayout.data.value.CubeInt16;
import scalasca.cubex.cube.datalayout.data.value.CubeInt32;
import scalasca.cubex.cube.datalayout.data.value.CubeInt64;
import scalasca.cubex.cube.datalayout.data.value.CubeInt8;
import scalasca.cubex.cube.datalayout.data.value.CubeMaxDouble;
import scalasca.cubex.cube.datalayout.data.value.CubeMinDouble;
import scalasca.cubex.cube.datalayout.data.value.CubeTauAtomicMetric;
import scalasca.cubex.cube.datalayout.data.value.CubeUint16;
import scalasca.cubex.cube.datalayout.data.value.CubeUint32;
import scalasca.cubex.cube.datalayout.data.value.CubeUint64;
import scalasca.cubex.cube.datalayout.data.value.CubeUint8;
import scalasca.cubex.cube.datalayout.data.value.ValueType;
import scalasca.cubex.cube.errors.UnknownValueTypeException;
import scalasca.cubex.cube.errors.WrongNumberOfValueParametersException;
import scalasca.cubex.cube.services.transformation.Endianess;

public abstract class Value {
    public String getName() {
        return "_no_value_";
    }

    public abstract int size();

    public byte[] correctEndianess(byte[] byArray, Endianess endianess) throws Exception {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            while (dataInputStream.available() > 0) {
                this.correctEndianess(endianess, dataInputStream, dataOutputStream);
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new Exception("Cannot perform endianess correction: " + iOException.toString());
        }
    }

    public abstract void correctEndianess(Endianess var1, DataInputStream var2, DataOutputStream var3) throws IOException;

    public abstract Value clone();

    public abstract Value copy();

    public abstract Value clone(DataInputStream var1) throws IOException;

    public abstract String toString();

    public abstract double getDouble();

    public abstract void setValue(String var1);

    public abstract void setValue(byte var1);

    public abstract void setValue(short var1);

    public abstract void setValue(int var1);

    public abstract void setValue(long var1);

    public abstract void setValue(double var1);

    public abstract void addValue(Value var1);

    public abstract void subtractValue(Value var1);

    public abstract void setValueParameters(Vector<Double> var1) throws WrongNumberOfValueParametersException;

    public static Value getValue(ValueType valueType) throws UnknownValueTypeException {
        switch (valueType) {
            case UINT8: {
                return new CubeUint8();
            }
            case INT8: {
                return new CubeInt8();
            }
            case UINT16: {
                return new CubeUint16();
            }
            case INT16: {
                return new CubeInt16();
            }
            case UINT32: {
                return new CubeUint32();
            }
            case INT32: {
                return new CubeInt32();
            }
            case UINT64: {
                return new CubeUint64();
            }
            case INT64: {
                return new CubeInt64();
            }
            case DOUBLE: {
                return new CubeDouble();
            }
            case MINDOUBLE: {
                return new CubeMinDouble();
            }
            case MAXDOUBLE: {
                return new CubeMaxDouble();
            }
            case TAU_ATOMIC_METRIC: {
                return new CubeTauAtomicMetric();
            }
            case COMPLEX: {
                return new CubeComplex();
            }
            case HISTOGRAM: {
                return new CubeHistogram();
            }
        }
        throw new UnknownValueTypeException(valueType);
    }
}

