/*
 * Decompiled with CFR 0.152.
 */
package scalasca.cubex.cube.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import scalasca.cubex.cube.Cnode;
import scalasca.cubex.cube.Vertex;
import scalasca.cubex.cube.errors.NotEnumeratedCnodeException;

public class CnodesEnumeration {
    protected String name = "Trivial Enumeration (1->1, 2->2, ...)";
    protected Map<Cnode, Integer> enumeration = new HashMap<Cnode, Integer>();

    public CnodesEnumeration() {
    }

    public CnodesEnumeration(ArrayList<Cnode> arrayList) {
        this.enumerate(arrayList);
    }

    public int getCID(Cnode cnode) throws NotEnumeratedCnodeException {
        Integer n = this.enumeration.get(cnode);
        if (n == null) {
            throw new NotEnumeratedCnodeException("Something is wrong. Tried to get a CID of not enumerated Cnode");
        }
        return n;
    }

    protected void enumerate(ArrayList<Cnode> arrayList) {
        ArrayList<Cnode> arrayList2 = this.make_list(arrayList);
        for (int i = 0; i < arrayList2.size(); ++i) {
            this.enumeration.put(arrayList2.get(i), new Integer(arrayList2.get(i).getId()));
        }
    }

    protected ArrayList<Cnode> make_list(ArrayList<Cnode> arrayList) {
        ArrayList<Cnode> arrayList2 = new ArrayList<Cnode>();
        for (Cnode cnode : arrayList) {
            this.addToList(arrayList2, cnode);
        }
        return arrayList2;
    }

    private void addToList(ArrayList<Cnode> arrayList, Cnode cnode) {
        arrayList.add(cnode);
        for (Vertex vertex : cnode.getAllChildren()) {
            this.addToList(arrayList, (Cnode)vertex);
        }
    }
}

