/*
 * Decompiled with CFR 0.152.
 */
package scalasca.cubex.cube.services.transformation;

import scalasca.cubex.cube.services.transformation.Endianess;

public class SwapBytes
extends Endianess {
    @Override
    public char applyOn(char c) {
        return (char)Short.reverseBytes((short)c);
    }

    @Override
    public byte applyOn(byte by) {
        return by;
    }

    @Override
    public short applyOn(short s) {
        return Short.reverseBytes(s);
    }

    @Override
    public int applyOn(int n) {
        return Integer.reverseBytes(n);
    }

    @Override
    public long applyOn(long l) {
        return Long.reverseBytes(l);
    }

    @Override
    public double applyOn(double d) {
        long l = Double.doubleToLongBits(d);
        long l2 = Long.reverseBytes(l);
        return Double.longBitsToDouble(l2);
    }

    @Override
    public Byte applyOn(Byte by) {
        return by;
    }

    @Override
    public Short applyOn(Short s) {
        return new Short(this.applyOn((short)s));
    }

    @Override
    public Integer applyOn(Integer n) {
        return new Integer(this.applyOn((int)n));
    }

    @Override
    public Long applyOn(Long l) {
        return new Long(this.applyOn((long)l));
    }

    @Override
    public Double applyOn(Double d) {
        return new Double(this.applyOn((double)d));
    }

    @Override
    public byte[] applyOn(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        int n = byArray2.length / 2;
        for (int i = 0; i < n; ++i) {
            byte by = byArray2[i];
            byArray2[i] = byArray2[byArray2.length - 1 - i];
            byArray2[byArray2.length - 1 - i] = by;
        }
        return byArray2;
    }
}

