/*
 * Decompiled with CFR 0.152.
 */
package scalasca.cubex.cubexlayout;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import scalasca.cubex.cubexlayout.CubeLayout;

public class Cube3GZIPLayout
extends CubeLayout {
    public Cube3GZIPLayout(String string) {
        super(string);
    }

    @Override
    public void print() {
        System.out.println(" ====== Simply gzipped cube3  layout  ========");
        System.out.println("Anchor size:      " + this.AnchorSize);
        System.out.println("Anchor offset:   " + this.AnchorShift);
    }

    static boolean testLayout(String string) {
        try {
            GZIPInputStream gZIPInputStream = new GZIPInputStream(new FileInputStream(string));
            byte[] byArray = new byte[1024];
            gZIPInputStream.read(byArray);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    @Override
    public byte[] getAnchorBytes() throws IOException {
        try {
            int n;
            GZIPInputStream gZIPInputStream = new GZIPInputStream(new FileInputStream(this.filename));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[0x100000];
            while (gZIPInputStream.available() != 0 && (n = gZIPInputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            gZIPInputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("File " + this.filename + " not found.");
            return new byte[0];
        }
    }
}

