/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.net.AssetURLContext;
import com.jogamp.common.net.Uri;
import com.jogamp.common.nio.Buffers;
import com.jogamp.common.os.MachineDataInfo;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.CustomCompress;
import com.jogamp.common.util.InterruptSource;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.common.util.SecurityUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.SyncFailedException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.security.Permission;
import java.util.regex.Pattern;
import jogamp.common.Debug;
import jogamp.common.os.AndroidUtils;
import jogamp.common.os.PlatformPropsImpl;

public class IOUtil {
    public static final boolean DEBUG;
    private static final boolean DEBUG_EXE;
    private static final boolean DEBUG_EXE_NOSTREAM;
    private static final boolean DEBUG_EXE_EXISTING_FILE;
    private static final String java_io_tmpdir_propkey = "java.io.tmpdir";
    private static final String user_home_propkey = "user.home";
    private static final String XDG_CACHE_HOME_envkey = "XDG_CACHE_HOME";
    public static final String tmpSubDir = "jogamp";
    private static final Pattern patternSingleBS;
    public static final Pattern patternSpaceEnc;
    private static final Object exeTestLock;
    private static WeakReference<byte[]> exeTestCodeRef;
    private static File tempRootExec;
    private static File tempRootNoexec;
    private static volatile boolean tempRootSet;

    private IOUtil() {
    }

    private static final Constructor<?> getFOSCtor() {
        Throwable throwable;
        Constructor<?> constructor;
        try {
            constructor = ReflectionUtil.getConstructor("java.io.FileOutputStream", new Class[]{File.class}, true, IOUtil.class.getClassLoader());
            throwable = null;
        }
        catch (Throwable throwable2) {
            constructor = null;
            throwable = throwable2;
        }
        if (DEBUG) {
            System.err.println("IOUtil: java.io.FileOutputStream available: " + (null != constructor));
            if (null != throwable) {
                throwable.printStackTrace();
            }
        }
        return constructor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copyURLConn2File(URLConnection uRLConnection, File file) throws IOException {
        uRLConnection.connect();
        int n = 0;
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());){
            n = IOUtil.copyStream2File(bufferedInputStream, file, uRLConnection.getContentLength());
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copyStream2File(InputStream inputStream, File file, int n) throws IOException {
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));){
            n = IOUtil.copyStream2Stream(inputStream, bufferedOutputStream, n);
        }
        return n;
    }

    public static int copyStream2Stream(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        return IOUtil.copyStream2Stream(Platform.getMachineDataInfo().pageSizeInBytes(), inputStream, outputStream, n);
    }

    public static int copyStream2Stream(int n, InputStream inputStream, OutputStream outputStream, int n2) throws IOException {
        int n3;
        byte[] byArray = new byte[n];
        int n4 = 0;
        while ((n3 = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n3);
            n4 += n3;
        }
        return n4;
    }

    public static StringBuilder appendCharStream(StringBuilder stringBuilder, Reader reader) throws IOException {
        int n;
        char[] cArray = new char[1024];
        while (0 < (n = reader.read(cArray))) {
            stringBuilder.append(cArray, 0, n);
        }
        return stringBuilder;
    }

    public static byte[] copyStream2ByteArray(InputStream inputStream) throws IOException {
        byte[] byArray;
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        int n = 0;
        int n2 = inputStream.available();
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        do {
            if (n + n2 > byArray2.length) {
                byArray = new byte[n + n2];
                System.arraycopy(byArray2, 0, byArray, 0, n);
                byArray2 = byArray;
            }
            if ((n3 = inputStream.read(byArray2, n, n2)) < 0) continue;
            n += n3;
        } while ((n2 = inputStream.available()) > 0 && n3 >= 0);
        if (n != byArray2.length) {
            byArray = new byte[n];
            System.arraycopy(byArray2, 0, byArray, 0, n);
            byArray2 = byArray;
        }
        return byArray2;
    }

    public static ByteBuffer copyStream2ByteBuffer(InputStream inputStream) throws IOException {
        return IOUtil.copyStream2ByteBuffer(inputStream, -1);
    }

    public static ByteBuffer copyStream2ByteBuffer(InputStream inputStream, int n) throws IOException {
        int n2;
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        if (n < (n2 = inputStream.available())) {
            n = n2;
        }
        MachineDataInfo machineDataInfo = Platform.getMachineDataInfo();
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(machineDataInfo.pageAlignedSize(n));
        byte[] byArray = new byte[machineDataInfo.pageSizeInBytes()];
        int n3 = Math.min(machineDataInfo.pageSizeInBytes(), n2);
        int n4 = 0;
        do {
            if (n2 > byteBuffer.remaining()) {
                ByteBuffer byteBuffer2 = Buffers.newDirectByteBuffer(machineDataInfo.pageAlignedSize(byteBuffer.position() + n2));
                byteBuffer2.put(byteBuffer);
                byteBuffer = byteBuffer2;
            }
            if ((n4 = inputStream.read(byArray, 0, n3)) > 0) {
                byteBuffer.put(byArray, 0, n4);
            }
            n2 = inputStream.available();
            n3 = Math.min(machineDataInfo.pageSizeInBytes(), n2);
        } while (n4 > 0);
        byteBuffer.flip();
        return byteBuffer;
    }

    public static String slashify(String string, boolean bl, boolean bl2) throws URISyntaxException {
        String string2 = patternSingleBS.matcher(string).replaceAll("/");
        if (bl && !string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        if (bl2 && !string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        return IOUtil.cleanPathString(string2);
    }

    public static String getFileSuffix(File file) {
        return IOUtil.getFileSuffix(file.getName());
    }

    public static String getFileSuffix(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return null;
        }
        return IOUtil.toLowerCase(string.substring(n + 1));
    }

    private static String toLowerCase(String string) {
        if (string == null) {
            return null;
        }
        return string.toLowerCase();
    }

    public static FileOutputStream getFileOutputStream(File file, boolean bl) throws IOException {
        Constructor<?> constructor = IOUtil.getFOSCtor();
        if (null == constructor) {
            throw new IOException("Cannot open file (" + file + ") for writing, FileOutputStream feature not available.");
        }
        if (file.exists() && !bl) {
            throw new IOException("File already exists (" + file + ") and overwrite=false");
        }
        try {
            return (FileOutputStream)constructor.newInstance(file);
        }
        catch (Exception exception) {
            throw new IOException("error opening " + file + " for write. ", exception);
        }
    }

    public static String getClassFileName(String string) {
        return string.replace('.', '/') + ".class";
    }

    public static URL getClassURL(String string, ClassLoader classLoader) throws IOException {
        URL uRL = classLoader.getResource(IOUtil.getClassFileName(string));
        if (null == uRL) {
            throw new IOException("Cannot not find: " + string);
        }
        return uRL;
    }

    public static String getBasename(String string) throws URISyntaxException {
        int n = (string = IOUtil.slashify(string, false, false)).lastIndexOf(47);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public static String getDirname(String string) throws URISyntaxException {
        int n = (string = IOUtil.slashify(string, false, false)).lastIndexOf(47);
        if (n >= 0) {
            string = string.substring(0, n + 1);
        }
        return string;
    }

    public static URLConnection getResource(Class<?> clazz, String string) {
        ClassLoader classLoader = null != clazz ? clazz.getClassLoader() : IOUtil.class.getClassLoader();
        return IOUtil.getResource(string, classLoader, clazz);
    }

    public static URLConnection getResource(String string, ClassLoader classLoader, Class<?> clazz) {
        if (null == string) {
            return null;
        }
        URLConnection uRLConnection = null;
        if (null != clazz) {
            String string2 = clazz.getName().replace('.', '/');
            int n = string2.lastIndexOf(47);
            if (n >= 0) {
                String string3 = string2.substring(0, n + 1);
                uRLConnection = IOUtil.getResource(string3 + string, classLoader);
                if (DEBUG) {
                    System.err.println("IOUtil: found <" + string + "> within class package <" + string3 + "> of given class <" + clazz.getName() + ">: " + (null != uRLConnection));
                }
            }
        } else if (DEBUG) {
            System.err.println("IOUtil: null context, skip rel. lookup");
        }
        if (null == uRLConnection) {
            uRLConnection = IOUtil.getResource(string, classLoader);
            if (DEBUG) {
                System.err.println("IOUtil: found <" + string + "> by classloader: " + (null != uRLConnection));
            }
        }
        return uRLConnection;
    }

    public static URLConnection getResource(String string, ClassLoader classLoader) {
        if (null == string) {
            return null;
        }
        if (DEBUG) {
            System.err.println("IOUtil: locating <" + string + ">, has cl: " + (null != classLoader));
        }
        if (string.startsWith("asset:")) {
            try {
                return AssetURLContext.createURL(string, classLoader).openConnection();
            }
            catch (IOException iOException) {
                if (DEBUG) {
                    ExceptionUtils.dumpThrowable("IOUtil", iOException);
                }
                return null;
            }
        }
        try {
            return AssetURLContext.resolve(string, classLoader);
        }
        catch (IOException iOException) {
            if (DEBUG) {
                ExceptionUtils.dumpThrowable("IOUtil", iOException);
            }
            return null;
        }
    }

    public static String getRelativeOf(File file, String string) throws URISyntaxException {
        if (null == string) {
            return null;
        }
        if (file != null) {
            File file2 = new File(file, string);
            return IOUtil.slashify(file2.getPath(), false, false);
        }
        return null;
    }

    public static String getParentOf(String string) throws URISyntaxException {
        int n;
        int n2 = n = null != string ? string.length() : 0;
        if (n == 0) {
            throw new IllegalArgumentException("path is empty <" + string + ">");
        }
        int n3 = string.lastIndexOf("/");
        if (n3 < 0) {
            throw new URISyntaxException(string, "path contains no '/': <" + string + ">");
        }
        if (n3 == 0) {
            throw new URISyntaxException(string, "path has no parents: <" + string + ">");
        }
        if (n3 < n - 1) {
            return string.substring(0, n3 + 1);
        }
        int n4 = string.lastIndexOf("!") + 1;
        int n5 = string.lastIndexOf("/", n3 - 1);
        if (n5 >= n4) {
            return string.substring(0, n5 + 1);
        }
        String string2 = string.substring(n4, n3);
        if (string2.equals("..")) {
            throw new URISyntaxException(string, "parent is unresolved: <" + string + ">");
        }
        return string.substring(0, n4);
    }

    public static String cleanPathString(String string) throws URISyntaxException {
        int n = string.length() - 1;
        while (n >= 1 && (n = string.lastIndexOf("./", n)) >= 0) {
            if (0 < n && string.charAt(n - 1) == '.') {
                n -= 2;
                continue;
            }
            string = string.substring(0, n) + string.substring(n + 2);
            --n;
        }
        n = 0;
        while ((n = string.indexOf("../", n)) >= 0) {
            if (0 == n) {
                n += 3;
                continue;
            }
            string = IOUtil.getParentOf(string.substring(0, n)) + string.substring(n + 3);
            n = 0;
        }
        return string;
    }

    public static String getUriFilePathOrASCII(Uri uri) {
        if (uri.isFileScheme()) {
            return uri.toFile().getPath();
        }
        return uri.toASCIIString().get();
    }

    public static URLConnection openURL(URL uRL) {
        return IOUtil.openURL(uRL, ".");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static URLConnection openURL(URL uRL, String string) {
        if (null != uRL) {
            try {
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.connect();
                if (!DEBUG) return uRLConnection;
                System.err.println("IOUtil: urlExists(" + uRL + ") [" + string + "] - true");
                return uRLConnection;
            }
            catch (IOException iOException) {
                if (!DEBUG) return null;
                ExceptionUtils.dumpThrowable("IOUtil: urlExists(" + uRL + ") [" + string + "] - false -", iOException);
                return null;
            }
        } else {
            if (!DEBUG) return null;
            System.err.println("IOUtil: no url - urlExists(null) [" + string + "]");
        }
        return null;
    }

    private static String getExeTestFileSuffix() {
        switch (PlatformPropsImpl.OS_TYPE) {
            case WINDOWS: {
                if (Platform.CPUFamily.X86 == PlatformPropsImpl.CPU_ARCH.family) {
                    return ".exe";
                }
                return ".bat";
            }
        }
        return ".sh";
    }

    private static String getExeTestShellCode() {
        switch (PlatformPropsImpl.OS_TYPE) {
            case WINDOWS: {
                return "echo off" + PlatformPropsImpl.NEWLINE;
            }
        }
        return null;
    }

    private static String[] getExeTestCommandArgs(String string) {
        switch (PlatformPropsImpl.OS_TYPE) {
            default: 
        }
        return new String[]{string};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final byte[] readCode(String string) throws IOException {
        URLConnection uRLConnection = IOUtil.getResource(string, IOUtil.class.getClassLoader(), IOUtil.class);
        byte[] byArray = null;
        try (InputStream inputStream = uRLConnection.getInputStream();){
            byArray = CustomCompress.inflateFromStream(inputStream);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fillExeTestFile(File file) throws IOException {
        if (Platform.OSType.WINDOWS == PlatformPropsImpl.OS_TYPE && Platform.CPUFamily.X86 == PlatformPropsImpl.CPU_ARCH.family) {
            byte[] byArray;
            Object object = exeTestLock;
            synchronized (object) {
                byte[] byArray2 = null;
                if (null == exeTestCodeRef || null == (byArray2 = (byte[])exeTestCodeRef.get())) {
                    String string = Platform.CPUType.X86_64 == PlatformPropsImpl.CPU_ARCH ? "bin/exe-windows-x86_64.defl" : "bin/exe-windows-i386.defl";
                    byArray = IOUtil.readCode(string);
                    exeTestCodeRef = new WeakReference<byte[]>(byArray);
                } else {
                    byArray = byArray2;
                }
            }
            object = new FileOutputStream(file);
            try {
                ((FileOutputStream)object).write(byArray, 0, byArray.length);
                try {
                    ((FileOutputStream)object).getFD().sync();
                }
                catch (SyncFailedException syncFailedException) {
                    ExceptionUtils.dumpThrowable("", syncFailedException);
                }
            }
            finally {
                ((FileOutputStream)object).close();
            }
        } else {
            String string = IOUtil.getExeTestShellCode();
            if (IOUtil.isStringSet(string)) {
                try (FileWriter fileWriter = new FileWriter(file);){
                    fileWriter.write(string);
                    try {
                        fileWriter.flush();
                    }
                    catch (IOException iOException) {
                        ExceptionUtils.dumpThrowable("", iOException);
                    }
                }
            }
        }
    }

    private static boolean getOSHasNoexecFS() {
        switch (PlatformPropsImpl.OS_TYPE) {
            case OPENKODE: {
                return false;
            }
        }
        return true;
    }

    private static boolean getOSHasFreeDesktopXDG() {
        switch (PlatformPropsImpl.OS_TYPE) {
            case WINDOWS: 
            case OPENKODE: 
            case ANDROID: 
            case MACOS: {
                return false;
            }
        }
        return true;
    }

    public static boolean testFile(File file, boolean bl, boolean bl2) {
        if (!file.exists()) {
            if (DEBUG) {
                System.err.println("IOUtil.testFile: <" + file.getAbsolutePath() + ">: does not exist");
            }
            return false;
        }
        if (bl && !file.isDirectory()) {
            if (DEBUG) {
                System.err.println("IOUtil.testFile: <" + file.getAbsolutePath() + ">: is not a directory");
            }
            return false;
        }
        if (bl2 && !file.canWrite()) {
            if (DEBUG) {
                System.err.println("IOUtil.testFile: <" + file.getAbsolutePath() + ">: is not writable");
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static boolean testDirExec(File var0) throws SecurityException {
        v0 = var1_1 = IOUtil.DEBUG_EXE != false || IOUtil.DEBUG != false;
        if (!IOUtil.testFile(var0, true, true)) {
            if (var1_1) {
                System.err.println("IOUtil.testDirExec: <" + var0.getAbsolutePath() + ">: Not writeable dir");
            }
            return false;
        }
        if (!IOUtil.getOSHasNoexecFS()) {
            if (var1_1) {
                System.err.println("IOUtil.testDirExec: <" + var0.getAbsolutePath() + ">: Always executable");
            }
            return true;
        }
        var2_2 = var1_1 != false ? System.currentTimeMillis() : 0L;
        try {
            v1 = var6_3 = IOUtil.DEBUG_EXE_EXISTING_FILE != false ? new File(var0, "jogamp_exe_tst" + IOUtil.getExeTestFileSuffix()) : null;
            if (null != var6_3 && var6_3.exists()) {
                var4_7 = var6_3;
                var5_8 = true;
            } else {
                var4_7 = File.createTempFile("jogamp_exe_tst", IOUtil.getExeTestFileSuffix(), var0);
                var5_8 = false;
            }
        }
        catch (SecurityException var6_4) {
            throw var6_4;
        }
        catch (IOException var6_5) {
            if (var1_1) {
                var6_5.printStackTrace();
            }
            return false;
        }
        var6_6 = var1_1 != false ? System.currentTimeMillis() : 0L;
        var10_9 = -1;
        var11_10 = -1;
        if (var5_8 || var4_7.setExecutable(true, true)) {
            var12_11 = null;
            try {
                if (!var5_8) {
                    IOUtil.fillExeTestFile(var4_7);
                }
                var8_13 = var1_1 != false ? System.currentTimeMillis() : 0L;
                var12_11 = Runtime.getRuntime().exec(IOUtil.getExeTestCommandArgs(var4_7.getCanonicalPath()), null, null);
                if (IOUtil.DEBUG_EXE && !IOUtil.DEBUG_EXE_NOSTREAM) {
                    new StreamMonitor(new InputStream[]{var12_11.getInputStream(), var12_11.getErrorStream()}, System.err, "Exe-Tst: ");
                }
                var12_11.waitFor();
                var11_10 = var12_11.exitValue();
                var10_9 = 0;
            }
            catch (SecurityException var13_15) {
                throw var13_15;
            }
            catch (Throwable var13_16) {
                var8_13 = var1_1 != false ? System.currentTimeMillis() : 0L;
                var10_9 = -2;
                if (!var1_1) ** GOTO lbl62
                System.err.println("IOUtil.testDirExec: <" + var4_7.getAbsolutePath() + ">: Caught " + var13_16.getClass().getSimpleName() + ": " + var13_16.getMessage());
                var13_16.printStackTrace();
            }
            finally {
                if (null != var12_11) {
                    try {
                        var12_11.destroy();
                    }
                    catch (Throwable var13_17) {
                        ExceptionUtils.dumpThrowable("", var13_17);
                    }
                }
            }
        } else {
            var8_13 = var1_1 != false ? System.currentTimeMillis() : 0L;
        }
lbl62:
        // 4 sources

        v2 = var12_12 = 0 == var10_9;
        if (!IOUtil.DEBUG_EXE && !var5_8) {
            var4_7.delete();
        }
        if (var1_1) {
            var13_19 = System.currentTimeMillis();
            System.err.println("IOUtil.testDirExec(): test-exe <" + var4_7.getAbsolutePath() + ">, existingFile " + var5_8 + ", returned " + var11_10);
            System.err.println("IOUtil.testDirExec(): abs-path <" + var0.getAbsolutePath() + ">: res " + var10_9 + " -> " + var12_12);
            System.err.println("IOUtil.testDirExec(): total " + (var13_19 - var2_2) + "ms, create " + (var6_6 - var2_2) + "ms, fill " + (var8_13 - var6_6) + "ms, execute " + (var13_19 - var8_13) + "ms");
        }
        return var12_12;
    }

    private static File testDirImpl(File file, boolean bl, boolean bl2, String string) throws SecurityException {
        File file2;
        if (bl && !file.exists()) {
            file.mkdirs();
        }
        if (bl2) {
            file2 = IOUtil.testDirExec(file) ? file : null;
        } else {
            File file3 = file2 = IOUtil.testFile(file, true, true) ? file : null;
        }
        if (DEBUG) {
            System.err.println("IOUtil.testDirImpl(" + string + "): <" + file.getAbsolutePath() + ">, create " + bl + ", exec " + bl2 + ": " + (null != file2));
        }
        return file2;
    }

    public static File testDir(File file, boolean bl, boolean bl2) throws SecurityException {
        return IOUtil.testDirImpl(file, bl, bl2, "testDir");
    }

    private static boolean isStringSet(String string) {
        return null != string && 0 < string.length();
    }

    private static File getSubTempDir(File file, String string, boolean bl, String string2) throws SecurityException {
        File file2 = null;
        if (null != IOUtil.testDirImpl(file, true, bl, string2)) {
            for (int i = 0; null == file2 && i <= 9999; ++i) {
                String string3 = String.format("_%04d", i);
                file2 = IOUtil.testDirImpl(new File(file, string + string3), true, bl, string2);
            }
        }
        return file2;
    }

    private static File getFile(String string) {
        if (IOUtil.isStringSet(string)) {
            return new File(string);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static File getTempDir(boolean bl) throws SecurityException, IOException {
        Object object;
        Object object2;
        if (!tempRootSet) {
            object2 = IOUtil.class;
            // MONITORENTER : com.jogamp.common.util.IOUtil.class
            if (!tempRootSet) {
                Object object3;
                String string;
                Object object4;
                Object object5;
                tempRootSet = true;
                object = AndroidUtils.getTempRoot();
                if (null != object) {
                    tempRootExec = tempRootNoexec = IOUtil.getSubTempDir((File)object, tmpSubDir, false, "Android.ctxTemp");
                    // MONITOREXIT : object2
                    return tempRootExec;
                }
                object = IOUtil.getFile(PropertyAccess.getProperty(java_io_tmpdir_propkey, false));
                if (DEBUG) {
                    System.err.println("IOUtil.getTempRoot(): tempX1 <" + object + ">, used " + (null != object));
                }
                if (!IOUtil.isStringSet((String)(object5 = System.getenv("TMPDIR")))) {
                    object5 = System.getenv("TEMP");
                }
                File file = null != (object4 = IOUtil.getFile((String)object5)) && !((File)object4).equals(object) ? object4 : null;
                if (DEBUG) {
                    System.err.println("IOUtil.getTempRoot(): tempX3 <" + object4 + ">, used " + (null != file));
                }
                object5 = IOUtil.getFile(PropertyAccess.getProperty(user_home_propkey, false));
                if (DEBUG) {
                    System.err.println("IOUtil.getTempRoot(): tempX4 <" + object5 + ">, used " + (null != object5));
                }
                if (IOUtil.getOSHasFreeDesktopXDG()) {
                    string = System.getenv(XDG_CACHE_HOME_envkey);
                    if (!IOUtil.isStringSet(string) && null != object5) {
                        string = ((File)object5).getAbsolutePath() + File.separator + ".cache";
                    }
                } else {
                    string = null;
                }
                object4 = null != (object3 = IOUtil.getFile(string)) && !((File)object3).equals(object) ? object3 : null;
                if (DEBUG) {
                    System.err.println("IOUtil.getTempRoot(): tempX2 <" + object3 + ">, used " + (null != object4));
                }
                if (null == tempRootExec && null != object) {
                    tempRootExec = Platform.OSType.MACOS == PlatformPropsImpl.OS_TYPE ? IOUtil.getSubTempDir((File)object, tmpSubDir, false, "tempX1") : IOUtil.getSubTempDir((File)object, tmpSubDir, true, "tempX1");
                }
                if (null == tempRootExec && null != object4) {
                    tempRootExec = IOUtil.getSubTempDir((File)object4, tmpSubDir, true, "tempX2");
                }
                if (null == tempRootExec && null != file) {
                    tempRootExec = IOUtil.getSubTempDir(file, tmpSubDir, true, "tempX3");
                }
                if (null == tempRootExec && null != object5) {
                    tempRootExec = IOUtil.getSubTempDir((File)object5, ".jogamp", true, "tempX4");
                }
                if (null != tempRootExec) {
                    tempRootNoexec = tempRootExec;
                } else {
                    if (null == tempRootNoexec && null != object) {
                        tempRootNoexec = IOUtil.getSubTempDir((File)object, tmpSubDir, false, "temp01");
                    }
                    if (null == tempRootNoexec && null != object4) {
                        tempRootNoexec = IOUtil.getSubTempDir((File)object4, tmpSubDir, false, "temp02");
                    }
                    if (null == tempRootNoexec && null != file) {
                        tempRootNoexec = IOUtil.getSubTempDir(file, tmpSubDir, false, "temp03");
                    }
                    if (null == tempRootNoexec && null != object5) {
                        tempRootNoexec = IOUtil.getSubTempDir((File)object5, ".jogamp", false, "temp04");
                    }
                }
                if (DEBUG) {
                    string = null != tempRootExec ? tempRootExec.getAbsolutePath() : null;
                    object3 = null != tempRootNoexec ? tempRootNoexec.getAbsolutePath() : null;
                    System.err.println("IOUtil.getTempRoot(): temp dirs: exec: " + string + ", noexec: " + (String)object3);
                }
            }
            // MONITOREXIT : object2
        }
        Object object6 = object2 = bl ? tempRootExec : tempRootNoexec;
        if (null != object2) {
            object = new FilePermission(((File)object2).getAbsolutePath(), "read,write,delete");
            SecurityUtil.checkPermission((Permission)object);
            return object2;
        }
        object = bl ? "executable " : "";
        throw new IOException("Could not determine a temporary " + (String)object + "directory");
    }

    public static File createTempFile(String string, String string2, boolean bl) throws IllegalArgumentException, IOException, SecurityException {
        return File.createTempFile(string, string2, IOUtil.getTempDir(bl));
    }

    public static void close(Closeable closeable, boolean bl) throws RuntimeException {
        block4: {
            if (null != closeable) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {
                    if (bl) {
                        throw new RuntimeException(iOException);
                    }
                    if (!DEBUG) break block4;
                    System.err.println("Caught Exception: ");
                    iOException.printStackTrace();
                }
            }
        }
    }

    public static IOException close(Closeable closeable, IOException[] iOExceptionArray, PrintStream printStream) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            if (null == iOExceptionArray[0]) {
                iOExceptionArray[0] = iOException;
            }
            if (null != printStream) {
                printStream.println("Caught " + iOException.getClass().getSimpleName() + ": " + iOException.getMessage());
                iOException.printStackTrace(printStream);
            }
            return iOException;
        }
        return null;
    }

    static {
        Debug.initSingleton();
        DEBUG = Debug.debug("IOUtil");
        DEBUG_EXE = PropertyAccess.isPropertyDefined("jogamp.debug.IOUtil.Exe", true);
        DEBUG_EXE_NOSTREAM = PropertyAccess.isPropertyDefined("jogamp.debug.IOUtil.Exe.NoStream", true);
        DEBUG_EXE_EXISTING_FILE = false;
        patternSingleBS = Pattern.compile("\\\\{1}");
        patternSpaceEnc = Pattern.compile("%20");
        exeTestLock = new Object();
        exeTestCodeRef = null;
        tempRootExec = null;
        tempRootNoexec = null;
        tempRootSet = false;
    }

    public static class StreamMonitor
    implements Runnable {
        private final InputStream[] istreams;
        private final boolean[] eos;
        private final PrintStream ostream;
        private final String prefix;

        public StreamMonitor(InputStream[] inputStreamArray, PrintStream printStream, String string) {
            this.istreams = inputStreamArray;
            this.eos = new boolean[inputStreamArray.length];
            this.ostream = printStream;
            this.prefix = string;
            InterruptSource.Thread thread = new InterruptSource.Thread(null, this, "StreamMonitor-" + Thread.currentThread().getName());
            thread.setDaemon(true);
            thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            byte[] byArray = new byte[4096];
            try {
                int n = this.istreams.length;
                int n2 = 0;
                do {
                    for (int i = 0; i < this.istreams.length; ++i) {
                        if (this.eos[i]) continue;
                        int n3 = this.istreams[i].read(byArray);
                        if (n3 > 0) {
                            if (null == this.ostream) continue;
                            if (null != this.prefix) {
                                this.ostream.write(this.prefix.getBytes());
                            }
                            this.ostream.write(byArray, 0, n3);
                            continue;
                        }
                        ++n2;
                        this.eos[i] = true;
                    }
                    if (null == this.ostream) continue;
                    this.ostream.flush();
                } while (n2 < n);
            }
            catch (IOException iOException) {
            }
            finally {
                if (null != this.ostream) {
                    this.ostream.flush();
                }
            }
        }
    }

    public static class ClassResources {
        public final ClassLoader classLoader;
        public final Class<?> contextCL;
        public final String[] resourcePaths;

        public final int resourceCount() {
            return this.resourcePaths.length;
        }

        public ClassResources(Class<?> clazz, String[] stringArray) {
            this(stringArray, clazz.getClassLoader(), clazz);
        }

        public ClassResources(String[] stringArray, ClassLoader classLoader, Class<?> clazz) {
            for (int i = stringArray.length - 1; i >= 0; --i) {
                if (null != stringArray[i]) continue;
                throw new IllegalArgumentException("resourcePath[" + i + "] is null");
            }
            this.classLoader = classLoader;
            this.contextCL = clazz;
            this.resourcePaths = stringArray;
        }

        public URLConnection resolve(int n) throws ArrayIndexOutOfBoundsException {
            return IOUtil.getResource(this.resourcePaths[n], this.classLoader, this.contextCL);
        }
    }
}

