/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.trace;

import edu.uoregon.tau.trace.EventDescr;
import edu.uoregon.tau.trace.TraceFile;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;

public class TraceWriter
extends TraceFile {
    DataOutputStream Foid;
    private static final int PCXX_EV_INIT = 60000;
    private static final int PCXX_EV_CLOSE = 60003;
    private static final int PCXX_EV_WALL_CLOCK = 60005;
    private static final int TAU_MESSAGE_SEND = 60007;
    private static final int TAU_MESSAGE_RECV = 60008;
    private HashSet<Integer> checkInit = new HashSet();
    private HashMap<Integer, String> nidTidNames = new HashMap();
    long lastTimestamp;

    public TraceWriter(String string, String string2) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            this.Foid = new DataOutputStream(bufferedOutputStream);
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string2));
            bufferedWriter.close();
            this.EdfFile = string2;
            this.EventIdMap = new TreeMap();
            this.IdGroupMap = new HashMap();
            EventDescr eventDescr = new EventDescr(60000, "TRACER", "EV_INIT", 0L, "none");
            this.EventIdMap.put(new Integer(60000), eventDescr);
            eventDescr = new EventDescr(60003, "TRACER", "FLUSH_CLOSE", 0L, "none");
            this.EventIdMap.put(new Integer(60003), eventDescr);
            eventDescr = new EventDescr(60005, "TRACER", "WALL_CLOCK", 0L, "none");
            this.EventIdMap.put(new Integer(60005), eventDescr);
            eventDescr = new EventDescr(60007, "TAU_MESSAGE", "MESSAGE_SEND", -7L, "par");
            this.EventIdMap.put(new Integer(60007), eventDescr);
            eventDescr = new EventDescr(60008, "TAU_MESSAGE", "MESSAGE_RECV", -8L, "par");
            this.EventIdMap.put(new Integer(60008), eventDescr);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private int CharPair(int n, int n2) {
        return (n << 16) + n2;
    }

    private int flushEdf() {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.EdfFile));
            int n = this.EventIdMap.size();
            bufferedWriter.write(n + " dynamic_trace_events\n");
            bufferedWriter.write("# FunctionId Group Tag \"Name Type\" Parameters\n");
            for (EventDescr eventDescr : this.EventIdMap.values()) {
                int n2 = eventDescr.getEventId();
                bufferedWriter.write(n2 + " " + eventDescr.getGroup() + " " + eventDescr.getTag() + " \"" + eventDescr.getEventName() + "\" " + eventDescr.getParameter() + "\n");
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("Error opening edf file");
            return -1;
        }
        return 0;
    }

    public int defThread(int n, int n2, String string) {
        Integer n3 = new Integer(this.CharPair(n, n2));
        if (!this.nidTidNames.containsKey(n3)) {
            this.nidTidNames.put(n3, string);
        }
        return 0;
    }

    public int defStateGroup(String string, int n) {
        this.IdGroupMap.put(new Integer(n), string);
        return 0;
    }

    public int defState(int n, String string, int n2) {
        if (!this.IdGroupMap.containsKey(new Integer(n2))) {
            return -1;
        }
        EventDescr eventDescr = new EventDescr(n, (String)this.IdGroupMap.get(new Integer(n2)), string, 0L, "EntryExit");
        this.EventIdMap.put(new Integer(n), eventDescr);
        return 0;
    }

    public int writeEvent(int n, char c, char c2, long l, long l2) {
        try {
            if (this.checkInit.add(new Integer(this.CharPair(c, c2)))) {
                this.Foid.writeInt(60000);
                this.Foid.writeChar(c);
                this.Foid.writeChar(c2);
                this.Foid.writeLong(3L);
                this.Foid.writeLong(l2);
            }
            this.Foid.writeInt(n);
            this.Foid.writeChar(c);
            this.Foid.writeChar(c2);
            this.Foid.writeLong(l);
            this.Foid.writeLong(l2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return 0;
    }

    public int closeTrace() {
        Set<Integer> set = this.nidTidNames.keySet();
        for (int n : set) {
            char c = (char)(n >>> 16);
            char c2 = (char)n;
            this.writeEvent(60003, c, c2, 0L, this.lastTimestamp);
            this.writeEvent(60005, c, c2, 0L, this.lastTimestamp);
        }
        this.flushEdf();
        try {
            this.Foid.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return 0;
    }

    private int enterExit(long l, int n, int n2, int n3, int n4) {
        this.writeEvent(n3, (char)n, (char)n2, n4, l);
        this.lastTimestamp = l;
        return 0;
    }

    public int enterState(long l, int n, int n2, int n3) {
        return this.enterExit(l, n, n2, n3, 1);
    }

    public int leaveState(long l, int n, int n2, int n3) {
        return this.enterExit(l, n, n2, n3, -1);
    }

    public int defClkPeriod(double d) {
        return 0;
    }

    private int sendRecv(long l, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        long l2 = n3;
        long l3 = n6;
        long l4 = n5;
        long l5 = n7;
        long l6 = l4 >> 16 << 54 >> 22 | (l3 >> 8 & 0xFFL) << 48 | (l2 >> 8 & 0xFFL) << 56 | l4 & 0xFFFFL | (l3 & 0xFFL) << 16 | (l2 & 0xFFL) << 24 | l5 << 58 >> 16;
        this.writeEvent(n8, (char)n, (char)n2, l6, l);
        this.lastTimestamp = l;
        return 0;
    }

    public int sendMessage(long l, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return this.sendRecv(l, n, n2, n3, n4, n5, n6, n7, 60007);
    }

    public int recvMessage(long l, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return this.sendRecv(l, n3, n4, n, n2, n5, n6, n7, 60008);
    }

    public int defUserEvent(int n, String string, int n2) {
        EventDescr eventDescr = new EventDescr(n, "TAUEVENT", string, n2, "TriggerValue");
        this.EventIdMap.put(new Integer(n), eventDescr);
        return 0;
    }

    public int eventTrigger(long l, int n, int n2, int n3, long l2) {
        this.writeEvent(n3, (char)n, (char)n2, l2, l);
        this.lastTimestamp = l;
        return 0;
    }
}

