/*
 * Decompiled with CFR 0.152.
 */
package com.graphbuilder.struc;

public class LinkedList {
    protected Node head = null;
    protected Node tail = null;
    protected int size = 0;

    protected Node createNode(Object object) {
        return new Node(this, object);
    }

    protected void insertBefore(Node node, Object object) {
        Node node2 = this.createNode(object);
        if (this.size == 0) {
            this.head = node2;
            this.tail = node2;
        } else if (node == this.head) {
            node2.next = this.head;
            this.head.prev = node2;
            this.head = node2;
        } else {
            node.prev.next = node2;
            node2.prev = node.prev;
            node.prev = node2;
            node2.next = node;
        }
        ++this.size;
    }

    protected void insertAfter(Node node, Object object) {
        Node node2 = this.createNode(object);
        if (this.size == 0) {
            this.head = node2;
            this.tail = node2;
        } else if (node == this.tail) {
            node2.prev = this.tail;
            this.tail.next = node2;
            this.tail = node2;
        } else {
            node.next.prev = node2;
            node2.next = node.next;
            node.next = node2;
            node2.prev = node;
        }
        ++this.size;
    }

    protected Object removeNode(Node node) {
        if (this.size == 0) {
            return null;
        }
        Object object = node.userObject;
        if (node == this.head) {
            this.head = this.head.next;
            if (this.head == null) {
                this.tail = null;
            } else {
                this.head.prev = null;
            }
        } else if (node == this.tail) {
            this.tail = this.tail.prev;
            this.tail.next = null;
        } else {
            node.prev.next = node.next;
            node.next.prev = node.prev;
        }
        node.list = null;
        --this.size;
        return object;
    }

    public Node getHead() {
        return this.head;
    }

    public Node getTail() {
        return this.tail;
    }

    public void addToHead(Object object) {
        this.insertBefore(this.head, object);
    }

    public void addToTail(Object object) {
        this.insertAfter(this.tail, object);
    }

    public Object removeHead() {
        return this.removeNode(this.head);
    }

    public Object removeTail() {
        return this.removeNode(this.tail);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(6 * this.size);
        stringBuffer.append("[");
        Node node = this.head;
        if (node != null) {
            stringBuffer.append(node.userObject);
            node = node.next;
        }
        while (node != null) {
            stringBuffer.append(", ");
            stringBuffer.append(node.userObject);
            node = node.next;
        }
        return stringBuffer.append("]").toString();
    }

    public static class Node {
        protected LinkedList list = null;
        protected Node next = null;
        protected Node prev = null;
        protected Object userObject = null;

        protected Node(LinkedList linkedList, Object object) {
            this.list = linkedList;
            this.userObject = object;
        }

        public LinkedList list() {
            return this.list;
        }

        public Node next() {
            return this.next;
        }

        public Node prev() {
            return this.prev;
        }

        public Object getUserObject() {
            return this.userObject;
        }

        public void setUserObject(Object object) {
            this.userObject = object;
        }

        public void insertBefore(Object object) {
            this.list.insertBefore(this, object);
        }

        public void insertAfter(Object object) {
            this.list.insertAfter(this, object);
        }

        public void remove() {
            this.list.removeNode(this);
        }
    }
}

