/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.paraprof.ColorDefaultsWindow;
import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.PPFunctionProfile;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.Preferences;
import edu.uoregon.tau.paraprof.enums.SortType;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.Group;
import edu.uoregon.tau.perfdmf.UserEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorChooser
implements WindowListener {
    private Vector<Color> colors = new Vector();
    private Vector<Color> groupColors = new Vector();
    private Color functionHighlightColor = Color.red;
    private Color groupHighlightColor = new Color(0, 255, 255);
    private Color userEventHighlightColor = new Color(255, 255, 0);
    private Color miscFunctionColor = Color.black;
    private boolean clrChooserFrameShowing = false;
    private ColorDefaultsWindow clrChooserFrame;

    public ColorChooser(Preferences preferences) {
        if (preferences != null) {
            this.colors = preferences.getColors();
            this.groupColors = preferences.getGroupColors();
            this.functionHighlightColor = preferences.getHighlightColor();
            this.groupHighlightColor = preferences.getGroupHighlightColor();
            this.userEventHighlightColor = preferences.getUserEventHighlightColor();
            this.miscFunctionColor = preferences.getMiscFunctionColor();
            if (this.functionHighlightColor == null) {
                this.functionHighlightColor = Color.red;
            }
            if (this.groupHighlightColor == null) {
                this.groupHighlightColor = new Color(0, 255, 255);
            }
            if (this.userEventHighlightColor == null) {
                this.userEventHighlightColor = new Color(255, 255, 0);
            }
            if (this.miscFunctionColor == null) {
                this.miscFunctionColor = Color.black;
            }
        } else {
            this.setDefaultColors();
            this.setDefaultGroupColors();
        }
    }

    public void showColorChooser(Component component) {
        if (!this.clrChooserFrameShowing) {
            this.clrChooserFrame = new ColorDefaultsWindow(this, component);
            this.clrChooserFrame.addWindowListener(this);
            this.clrChooserFrame.setVisible(true);
            this.clrChooserFrameShowing = true;
        } else {
            this.clrChooserFrame.setVisible(true);
        }
    }

    public void setSavedColors() {
        ParaProf.preferences.setColors(this.colors);
        ParaProf.preferences.setGroupColors(this.groupColors);
        ParaProf.preferences.setHighlightColor(this.functionHighlightColor);
        ParaProf.preferences.setGroupHighlightColor(this.groupHighlightColor);
        ParaProf.preferences.setMiscFunctionColor(this.miscFunctionColor);
    }

    public int getNumberOfColors() {
        return this.colors.size();
    }

    public int getNumberOfGroupColors() {
        return this.groupColors.size();
    }

    public void addColor(Color color) {
        this.colors.add(color);
    }

    public void setColor(Color color, int n) {
        this.colors.setElementAt(color, n);
    }

    public Color getColor(int n) {
        return this.colors.get(n);
    }

    public Vector<Color> getColors() {
        return this.colors;
    }

    public void addGroupColor(Color color) {
        this.groupColors.add(color);
    }

    public void setGroupColor(Color color, int n) {
        this.groupColors.setElementAt(color, n);
    }

    public Color getGroupColor(int n) {
        return this.groupColors.elementAt(n);
    }

    public Vector<Color> getGroupColors() {
        return this.groupColors;
    }

    public void setHighlightColor(Color color) {
        this.functionHighlightColor = color;
    }

    public Color getHighlightColor() {
        return this.functionHighlightColor;
    }

    public void setGroupHighlightColor(Color color) {
        this.groupHighlightColor = color;
    }

    public Color getGroupHighlightColor() {
        return this.groupHighlightColor;
    }

    public void setUserEventHighlightColor(Color color) {
        this.userEventHighlightColor = color;
    }

    public Color getUserEventHighlightColor() {
        return this.userEventHighlightColor;
    }

    public void setMiscFunctionColor(Color color) {
        this.miscFunctionColor = color;
    }

    public Color getMiscFunctionColor() {
        return this.miscFunctionColor;
    }

    public void setDefaultColors() {
        this.colors.clear();
        this.addColor(new Color(115, 165, 255));
        this.addColor(new Color(215, 0, 0));
        this.addColor(new Color(70, 215, 70));
        this.addColor(new Color(105, 17, 169));
        this.addColor(new Color(255, 153, 0));
        this.addColor(new Color(0, 0, 255));
        this.addColor(new Color(204, 255, 51));
        this.addColor(new Color(0, 227, 154));
        this.addColor(new Color(233, 107, 53));
        this.addColor(new Color(204, 194, 220));
        this.addColor(new Color(44, 238, 202));
        this.addColor(new Color(30, 175, 141));
        this.addColor(new Color(132, 127, 121));
        this.addColor(new Color(246, 211, 47));
        for (int i = 0; i < 50; ++i) {
            this.addColor(new Color(i * i * 525 % 255, (i * i * i * 33 + 125) % 255, (i * 666 + 205) % 255));
        }
    }

    public void setDefaultGroupColors() {
        this.groupColors.clear();
        this.addGroupColor(new Color(102, 0, 102));
        this.addGroupColor(new Color(51, 51, 0));
        this.addGroupColor(new Color(204, 0, 51));
        this.addGroupColor(new Color(0, 102, 102));
        this.addGroupColor(new Color(255, 255, 102));
        this.addGroupColor(new Color(0, 0, 102));
        this.addGroupColor(new Color(153, 153, 255));
        this.addGroupColor(new Color(255, 51, 0));
        this.addGroupColor(new Color(255, 153, 0));
        this.addGroupColor(new Color(255, 102, 102));
        this.addGroupColor(new Color(51, 0, 51));
        this.addGroupColor(new Color(255, 255, 102));
    }

    public Color getColorLocation(int n) {
        return this.getColor(n % this.getNumberOfColors());
    }

    public void setColors(ParaProfTrial paraProfTrial, int n) {
        Object object;
        Object object2;
        int n2;
        if (n == -1 || n == 0) {
            n2 = this.getNumberOfColors();
            object2 = new DataSorter(paraProfTrial);
            ((DataSorter)object2).setSortType(SortType.MEAN_VALUE);
            ((DataSorter)object2).setDescendingOrder(true);
            object = ((DataSorter)object2).getFunctionProfiles(paraProfTrial.getDataSource().getMeanData());
            for (int i = 0; i < object.size(); ++i) {
                Function function = ((PPFunctionProfile)object.get(i)).getFunction();
                Color color = ParaProf.colorMap.getColor(function);
                if (color != null) {
                    function.setSpecificColor(color);
                    function.setColorFlag(true);
                } else {
                    function.setColorFlag(false);
                    function.setSpecificColor(null);
                }
                if (function.getColor() != null) continue;
                function.setColor(this.getColor(i % n2));
            }
        }
        if (n == -1 || n == 1) {
            n2 = this.getNumberOfGroupColors();
            object2 = paraProfTrial.getDataSource().getGroups();
            while (object2.hasNext()) {
                object = (Group)object2.next();
                object.setColor(this.getGroupColor(object.getID() % n2));
            }
        }
        if (n == -1 || n == 2) {
            n2 = this.getNumberOfColors();
            object2 = paraProfTrial.getDataSource().getUserEventIterator();
            while (object2.hasNext()) {
                object = (UserEvent)object2.next();
                object.setColor(this.getColor(object.getID() % n2));
            }
        }
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getSource() == this.clrChooserFrame) {
            this.clrChooserFrameShowing = false;
        }
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

