/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.paraprof.ColorMapWindow;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.perfdmf.Function;
import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Vector;
import javax.swing.JColorChooser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorMap
extends Observable
implements Serializable {
    private static final long serialVersionUID = -381806020540973756L;
    private Map<String, Color> colors = new HashMap<String, Color>();

    public Map<String, Color> getMap() {
        return this.colors;
    }

    public void setMap(Map<String, Color> map) {
        if (map == null) {
            this.colors.clear();
        } else {
            this.colors = map;
            if (ParaProf.paraProfManagerWindow != null) {
                Vector<ParaProfTrial> vector = ParaProf.paraProfManagerWindow.getLoadedTrials();
                for (ParaProfTrial paraProfTrial : vector) {
                    ParaProf.colorChooser.setColors(paraProfTrial, -1);
                    paraProfTrial.updateRegisteredObjects("colorEvent");
                }
                this.setChanged();
                this.notifyObservers("colorMap");
            }
        }
    }

    public Color getColor(Function function) {
        return this.colors.get(function.getName());
    }

    public Color getColor(String string) {
        return this.colors.get(string);
    }

    void putColor(Function function, Color color) {
        this.colors.put(function.getName(), color);
        this.reassignColors();
        this.setChanged();
        this.notifyObservers("colorMap");
    }

    void removeColor(Function function) {
        this.removeColor(function.getName());
    }

    void removeColor(String string) {
        this.colors.remove(string);
        this.reassignColors();
        this.setChanged();
        this.notifyObservers("colorMap");
    }

    void assignColor(Component component, Function function) {
        Color color = function.getColor();
        if ((color = JColorChooser.showDialog(component, "Please select a new color", color)) != null) {
            this.putColor(function, color);
        }
    }

    public Iterator<String> getFunctions() {
        return this.colors.keySet().iterator();
    }

    public void removeAll() {
        this.colors.clear();
        this.reassignColors();
        this.setChanged();
        this.notifyObservers("colorMap");
    }

    public void reassignColors() {
        Vector<ParaProfTrial> vector = ParaProf.paraProfManagerWindow.getLoadedTrials();
        for (ParaProfTrial paraProfTrial : vector) {
            ParaProf.colorChooser.setColors(paraProfTrial, -1);
            paraProfTrial.updateRegisteredObjects("colorEvent");
        }
    }

    public void assignColorsFromTrial(ParaProfTrial paraProfTrial) {
        Iterator iterator = paraProfTrial.getDataSource().getFunctionIterator();
        while (iterator.hasNext()) {
            Function function = (Function)iterator.next();
            this.colors.put(function.getName(), function.getColor());
        }
        this.reassignColors();
        this.setChanged();
        this.notifyObservers("colorMap");
    }

    public void showColorMap(Component component) {
        ColorMapWindow colorMapWindow = new ColorMapWindow(component);
        colorMapWindow.setVisible(true);
        this.addObserver(colorMapWindow);
    }
}

