/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.common.Utility;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.WindowPlacer;
import edu.uoregon.tau.paraprof.interfaces.ParaProfWindow;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UserEventProfile;
import edu.uoregon.tau.vis.HeatMapData;
import edu.uoregon.tau.vis.HeatMapWindow;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Scanner;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;

public class CommunicationMatrixWindow
implements ParaProfWindow,
Observer,
Printable {
    private HeatMapData mapData = null;
    private static final String allPaths = "All Paths";
    private static final int COUNT = 0;
    private static final int MAX = 1;
    private static final int MIN = 2;
    private static final int MEAN = 3;
    private static final int STDDEV = 4;
    private static final int VOLUME = 5;
    private static final int[] figdexs = new int[]{0, 1, 2, 3, 4, 5};
    private static final String[] figures = new String[]{"CALLS", "MAX", "MIN", "MEAN", "STDDEV", "VOLUME"};
    private HeatMapWindow window = null;
    private ParaProfTrial ppTrial;

    private CommunicationMatrixWindow(ParaProfTrial paraProfTrial) {
        this.ppTrial = paraProfTrial;
    }

    public static JFrame createCommunicationMatrixWindow(ParaProfTrial paraProfTrial, JFrame jFrame) {
        CommunicationMatrixWindow communicationMatrixWindow = new CommunicationMatrixWindow(paraProfTrial);
        JFrame jFrame2 = communicationMatrixWindow.doCommunicationMatrix(paraProfTrial.getDataSource(), jFrame);
        if (jFrame2 == null) {
            return jFrame2;
        }
        jFrame2.setLocation(WindowPlacer.getNewLocation(jFrame2, jFrame));
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(ParaProfUtils.createFileMenu(communicationMatrixWindow, communicationMatrixWindow, jFrame2));
        jMenuBar.add(ParaProfUtils.createWindowsMenu(paraProfTrial, jFrame2));
        jMenuBar.add(ParaProfUtils.createHelpMenu(jFrame2, communicationMatrixWindow));
        jFrame2.setJMenuBar(jMenuBar);
        jFrame2.pack();
        if (ParaProf.getHelpWindow().isVisible()) {
            communicationMatrixWindow.help(false);
        }
        ParaProf.incrementNumWindows();
        paraProfTrial.addObserver(communicationMatrixWindow);
        return jFrame2;
    }

    public static void writeCommCSV(DataSource dataSource, OutputStream outputStream, int n) {
        HeatMapData heatMapData = CommunicationMatrixWindow.getMapData(dataSource, n);
        heatMapData.reset();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        Set set = heatMapData.getPaths();
        StringBuilder stringBuilder = new StringBuilder("x cord,y coord,z coord");
        for (String string : set) {
            for (String string2 : figures) {
                stringBuilder.append(", " + string + " " + (String)string2);
            }
        }
        try {
            bufferedWriter.write(stringBuilder.toString());
            bufferedWriter.newLine();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        while (heatMapData.hasNext()) {
            HeatMapData.NextValue nextValue = heatMapData.next();
            stringBuilder.setLength(0);
            int n2 = nextValue.receiver;
            int n3 = nextValue.sender;
            stringBuilder.append(n2 + "," + n3 + ",0");
            for (String string : set) {
                for (Object object : (String)figdexs) {
                    double d = nextValue.getValue(string, (int)object);
                    stringBuilder.append("," + d);
                }
            }
            try {
                bufferedWriter.write(stringBuilder.toString());
                bufferedWriter.newLine();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        try {
            bufferedWriter.close();
            outputStreamWriter.close();
            outputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static HeatMapData getMapData(DataSource dataSource, int n) {
        boolean bl = false;
        int n2 = 0;
        int n3 = dataSource.getNodeMap().size();
        HeatMapData heatMapData = new HeatMapData(n3);
        for (Thread thread : dataSource.getAllThreads()) {
            if (thread.getThreadID() != 0 || thread.getContextID() != 0) continue;
            Iterator iterator = thread.getUserEventProfiles();
            while (iterator.hasNext()) {
                UserEventProfile userEventProfile = (UserEventProfile)iterator.next();
                if (userEventProfile == null || !(userEventProfile.getNumSamples(n) > 0.0)) continue;
                String string = userEventProfile.getName();
                if (string.startsWith("Message size") && string.indexOf("=>") == -1) {
                    bl = CommunicationMatrixWindow.extractData(userEventProfile, n2, string, string, allPaths, n3, n, heatMapData) || bl;
                    continue;
                }
                if (!string.startsWith("Message size") || string.indexOf("=>") < 0) continue;
                bl = true;
                StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
                String string2 = stringTokenizer.nextToken().trim();
                String string3 = stringTokenizer.nextToken().trim();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "=>");
                String string4 = null;
                while (stringTokenizer2.hasMoreTokens()) {
                    string4 = stringTokenizer2.nextToken().trim();
                    if (string4.equals(".TAU application")) continue;
                    CommunicationMatrixWindow.extractData(userEventProfile, n2, string, string2, string4, n3, n, heatMapData);
                }
            }
            ++n2;
        }
        if (bl) {
            heatMapData.massageData();
            return heatMapData;
        }
        return null;
    }

    private boolean updateMapData(DataSource dataSource) {
        this.mapData = CommunicationMatrixWindow.getMapData(dataSource, this.ppTrial.getSelectedSnapshot());
        return this.mapData != null;
    }

    private JFrame doCommunicationMatrix(DataSource dataSource, JFrame jFrame) {
        boolean bl = this.updateMapData(dataSource);
        if (!bl) {
            JOptionPane.showMessageDialog(jFrame, "This trial does not have communication matrix data.\nTo collect communication matrix data, set the environment variable TAU_COMM_MATRIX=1 before executing your application.", "No Communication Matrix Data", 0);
            return null;
        }
        this.window = new HeatMapWindow("Message Size Heat Maps", this.mapData);
        URL uRL = Utility.getResource((String)"tau32x32.gif");
        if (uRL != null) {
            this.window.setIconImage(Toolkit.getDefaultToolkit().getImage(uRL));
        }
        return this.window;
    }

    private static boolean extractData(UserEventProfile userEventProfile, int n, String string, String string2, String string3, int n2, int n3, HeatMapData heatMapData) {
        if (string2.contains("all nodes")) {
            return false;
        }
        Scanner scanner = new Scanner(string2);
        int n4 = -1;
        while (scanner.hasNext()) {
            if (!scanner.hasNextInt()) {
                scanner.next();
                continue;
            }
            n4 = scanner.nextInt();
        }
        scanner.close();
        if (n4 == -1) {
            return false;
        }
        if (n4 >= n2) {
            System.err.printf("Warning: %s but there is no node %d.\n", string, n4);
            return false;
        }
        if (string2.contains("sent")) {
            int n5 = n4;
            int n6 = n;
            CommunicationMatrixWindow.addMapData(userEventProfile, n6, n5, string3, n3, heatMapData);
            return true;
        }
        if (string2.contains("received")) {
            int n7 = n4;
            int n8 = n;
            CommunicationMatrixWindow.addMapData(userEventProfile, n7, n8, string3, n3, heatMapData);
            return true;
        }
        return false;
    }

    private static void addMapData(UserEventProfile userEventProfile, int n, int n2, String string, int n3, HeatMapData heatMapData) {
        double d = 0.0;
        double[] dArray = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] dArray2 = heatMapData.get(n, n2, string);
        if (dArray2 == null) {
            dArray2 = dArray;
            heatMapData.put(n, n2, string, dArray2);
        }
        double d2 = userEventProfile.getNumSamples(n3);
        dArray2[0] = dArray2[0] + d2;
        double d3 = userEventProfile.getMaxValue(n3);
        dArray2[1] = Math.max(d3, dArray2[1]);
        double d4 = userEventProfile.getMinValue(n3);
        dArray2[2] = dArray2[2] > 0.0 ? Math.min(dArray2[2], d4) : d4;
        double d5 = userEventProfile.getMeanValue(n3);
        dArray2[3] = dArray2[3] + d5;
        double d6 = userEventProfile.getStdDev(n3);
        dArray2[4] = dArray2[4] + d6;
        d = d2 * d5;
        dArray2[5] = dArray2[5] + d;
    }

    public JFrame getWindow() {
        try {
            this.window.setVisible(false);
            ParaProf.decrementNumWindows();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.window.dispose();
        return this.window;
    }

    public void closeThisWindow() {
        this.window.setVisible(false);
    }

    public void help(boolean bl) {
        ParaProf.getHelpWindow().clearText();
        if (bl) {
            ParaProf.getHelpWindow().setVisible(true);
        }
        ParaProf.getHelpWindow().writeText("Communication Matrix Window");
        ParaProf.getHelpWindow().writeText("");
        ParaProf.getHelpWindow().writeText("This window shows communication data between nodes.");
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        return 0;
    }

    public JFrame getFrame() {
        return this.window;
    }

    public void update(Observable observable, Object object) {
        String string = (String)object;
        if (string.equals("subWindowCloseEvent")) {
            this.closeThisWindow();
        } else if (!string.equals("prefEvent") && !string.equals("colorEvent") && string.equals("dataEvent")) {
            this.updateMapData(this.ppTrial.getDataSource());
            this.window.setMapData(this.mapData);
        }
    }
}

