/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.paraprof.MetricNotFoundException;
import edu.uoregon.tau.paraprof.ParaProfApplication;
import edu.uoregon.tau.paraprof.ParaProfExperiment;
import edu.uoregon.tau.paraprof.ParaProfExpression;
import edu.uoregon.tau.paraprof.ParaProfManagerWindow;
import edu.uoregon.tau.paraprof.ParaProfMetric;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.ParaProfView;
import edu.uoregon.tau.paraprof.ParsingException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DerivedMetricPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -7689602756381821252L;
    private ParaProfManagerWindow paraProfManager = null;
    private JTextField arg1Field = new JTextField("", 30);

    public DerivedMetricPanel(ParaProfManagerWindow paraProfManagerWindow) {
        this.paraProfManager = paraProfManagerWindow;
        int n = 800;
        int n2 = 200;
        this.setSize(new Dimension(n, n2));
        this.arg1Field.setEditable(true);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(new JLabel("Expression:"), gridBagConstraints, 0, 0, 1, 1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(this.arg1Field, gridBagConstraints, 1, 0, 7, 1);
        JButton jButton = new JButton("Clear");
        jButton.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(jButton, gridBagConstraints, 8, 0, 1, 1);
        JButton jButton2 = new JButton("Apply");
        jButton2.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(jButton2, gridBagConstraints, 7, 2, 1, 1);
        JButton jButton3 = new JButton("(");
        jButton3.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(jButton3, gridBagConstraints, 5, 2, 1, 1);
        JButton jButton4 = new JButton(")");
        jButton4.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(jButton4, gridBagConstraints, 6, 2, 1, 1);
        JButton jButton5 = new JButton("+");
        jButton5.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(jButton5, gridBagConstraints, 0, 2, 1, 1);
        JButton jButton6 = new JButton("-");
        jButton6.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(jButton6, gridBagConstraints, 1, 2, 1, 1);
        JButton jButton7 = new JButton("*");
        jButton7.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(jButton7, gridBagConstraints, 2, 2, 1, 1);
        JButton jButton8 = new JButton("/ ");
        jButton8.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(jButton8, gridBagConstraints, 3, 2, 1, 1);
        JButton jButton9 = new JButton("=");
        jButton9.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(jButton9, gridBagConstraints, 4, 2, 1, 1);
        JMenuItem jMenuItem = new JMenuItem("Copy");
        jMenuItem.addActionListener(this);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        jMenuItem.setMnemonic(67);
        JMenuItem jMenuItem2 = new JMenuItem("Cut");
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        jMenuItem2.setMnemonic(84);
        jMenuItem2.addActionListener(this);
        JMenuItem jMenuItem3 = new JMenuItem("Paste");
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        jMenuItem3.setMnemonic(80);
        jMenuItem3.addActionListener(this);
    }

    public void setArg1Field(String string) {
        this.arg1Field.setText(string);
    }

    public String getArg1Field() {
        return this.arg1Field.getText().trim();
    }

    private void applyToTrial(ParaProfTrial paraProfTrial, String string) throws MetricNotFoundException {
        if (paraProfTrial != null) {
            while (paraProfTrial.loading()) {
                DerivedMetricPanel.sleep(500);
            }
            try {
                this.paraProfManager.expandTrial(paraProfTrial);
                ParaProfExpression paraProfExpression = new ParaProfExpression();
                ParaProfMetric paraProfMetric = paraProfExpression.evaluateExpression(paraProfTrial, string);
                if (paraProfMetric != null) {
                    if (paraProfMetric.getParaProfTrial().dBTrial()) {
                        this.paraProfManager.uploadMetric(paraProfMetric);
                    }
                    this.paraProfManager.populateTrialMetrics(paraProfMetric.getParaProfTrial());
                }
            }
            catch (ParsingException parsingException) {
                parsingException.printStackTrace();
            }
        }
    }

    public void applyOperation() {
        if (!ParaProfExpression.validate(this.arg1Field.getText())) {
            JOptionPane.showMessageDialog(this.paraProfManager, "The expression entered is not valid.", "Expression Error", 0);
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = this.paraProfManager.getSelectedObject();
        if (defaultMutableTreeNode == null) {
            JOptionPane.showMessageDialog(this.paraProfManager, "Please select a trial, experiment or application.", "Warning", 2);
            return;
        }
        ArrayList<ParaProfTrial> arrayList = this.collectTrials(defaultMutableTreeNode);
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (int i = 0; i < arrayList.size(); ++i) {
            try {
                this.applyToTrial(arrayList.get(i), this.arg1Field.getText());
                continue;
            }
            catch (MetricNotFoundException metricNotFoundException) {
                arrayList2.add(arrayList.get(i));
            }
        }
        if (arrayList2.size() > 0) {
            arrayList2.add(0, "The metric could not be derived for the following trials because they did not contain all of the metrics required.\n");
            JOptionPane.showMessageDialog(this.paraProfManager, arrayList2.toArray(), "Warning", 2);
        }
    }

    private ArrayList<ParaProfTrial> collectTrials(DefaultMutableTreeNode defaultMutableTreeNode) {
        ArrayList<ParaProfTrial> arrayList = new ArrayList<ParaProfTrial>();
        this.collectTrials(defaultMutableTreeNode, arrayList);
        return arrayList;
    }

    private void collectTrials(DefaultMutableTreeNode defaultMutableTreeNode, ArrayList<ParaProfTrial> arrayList) {
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof ParaProfMetric) {
            ParaProfMetric paraProfMetric = (ParaProfMetric)object;
            arrayList.add(paraProfMetric.getParaProfTrial());
        } else if (object instanceof ParaProfTrial) {
            arrayList.add((ParaProfTrial)object);
        } else if (object instanceof ParaProfExperiment || object instanceof ParaProfApplication || object instanceof ParaProfView) {
            this.paraProfManager.expand(defaultMutableTreeNode);
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                this.paraProfManager.expand(defaultMutableTreeNode2);
                this.collectTrials(defaultMutableTreeNode2, arrayList);
            }
        } else {
            JOptionPane.showMessageDialog(this.paraProfManager, "Please select a trial, experiment or application.", "Warning", 2);
        }
    }

    private static void sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (Exception exception) {
            throw new RuntimeException("Exception while sleeping");
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            String string = actionEvent.getActionCommand().trim();
            if (string.equals("Apply")) {
                this.applyOperation();
            } else if (string.equals("Clear")) {
                this.arg1Field.setText("");
            } else if (string.equals("+")) {
                this.insertString("+");
            } else if (string.equals("+")) {
                this.insertString("+");
            } else if (string.equals("-")) {
                this.insertString("-");
            } else if (string.equals("*")) {
                this.insertString("*");
            } else if (string.equals("/")) {
                this.insertString("/");
            } else if (string.equals("(")) {
                this.insertString("(");
            } else if (string.equals(")")) {
                this.insertString(")");
            } else if (string.equals("=")) {
                this.insertString("=");
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.add(component, gridBagConstraints);
    }

    public void insertMetric(ParaProfMetric paraProfMetric) {
        String string = paraProfMetric.getName();
        if (!(string = string.replace(' ', '\"')).startsWith("(") || !string.endsWith(")")) {
            this.arg1Field.replaceSelection("\"" + string + "\"");
        } else {
            this.arg1Field.replaceSelection(string);
        }
        this.arg1Field.requestFocusInWindow();
        int n = this.arg1Field.getSelectionStart();
        this.arg1Field.setCaretPosition(n);
        if (this.arg1Field.getText().length() == n) {
            this.arg1Field.setText(this.arg1Field.getText() + " ");
            this.arg1Field.setCaretPosition(n);
        }
    }

    public void removeMetric(ParaProfMetric paraProfMetric) {
        int n = this.arg1Field.getSelectionStart();
        String string = this.arg1Field.getText();
        String string2 = paraProfMetric.getName();
        int n2 = string2.length();
        int n3 = n - (n2 + 2);
        String string3 = "";
        if (n3 > 0) {
            string.substring(0, n3);
        }
        int n4 = n + 1;
        String string4 = "";
        if (n4 > 0) {
            string4 = string.substring(n4);
        }
        this.arg1Field.setText(string3 + string4);
        if ((n -= paraProfMetric.getName().length() + 2) >= 0 && n < this.arg1Field.getText().length()) {
            this.arg1Field.setCaretPosition(n);
        }
        if (this.arg1Field.getText().length() == n) {
            this.arg1Field.setText(this.arg1Field.getText() + " ");
            this.arg1Field.setCaretPosition(n);
        }
    }

    private void insertString(String string) {
        this.arg1Field.replaceSelection(string);
        this.arg1Field.requestFocusInWindow();
        int n = this.arg1Field.getSelectionStart();
        this.arg1Field.setCaretPosition(n);
        if (this.arg1Field.getText().length() == n) {
            this.arg1Field.setText(this.arg1Field.getText() + " ");
            this.arg1Field.setCaretPosition(n);
        }
    }

    public void applyExpressionFile(LineNumberReader lineNumberReader) throws IOException {
        String string = lineNumberReader.readLine();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        DefaultMutableTreeNode defaultMutableTreeNode = this.paraProfManager.getSelectedObject();
        if (defaultMutableTreeNode == null) {
            JOptionPane.showMessageDialog(this.paraProfManager, "Please select a trial, experiment or application.", "Warning", 2);
            return;
        }
        if (!(defaultMutableTreeNode.getUserObject() instanceof ParaProfMetric || defaultMutableTreeNode.getUserObject() instanceof ParaProfTrial || defaultMutableTreeNode.getUserObject() instanceof ParaProfTrial || defaultMutableTreeNode.getUserObject() instanceof ParaProfApplication)) {
            JOptionPane.showMessageDialog(this.paraProfManager, "Please select a trial, experiment or application.", "Warning", 2);
            return;
        }
        while (string != null) {
            if (!(string = string.trim()).equals("")) {
                if (!ParaProfExpression.validate(string)) {
                    JOptionPane.showMessageDialog(this.paraProfManager, "The expression entered is not valid.", "Expression Error", 0);
                } else {
                    ArrayList<ParaProfTrial> arrayList2 = this.collectTrials(defaultMutableTreeNode);
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        try {
                            this.applyToTrial(arrayList2.get(i), string);
                            continue;
                        }
                        catch (MetricNotFoundException metricNotFoundException) {
                            arrayList.add(arrayList2.get(i));
                        }
                    }
                }
            }
            string = lineNumberReader.readLine();
        }
        if (arrayList.size() > 0) {
            arrayList.add(0, "The metric could not be derived for the follow trials because they did not contain all of the metrics required.\n");
            JOptionPane.showMessageDialog(this.paraProfManager, arrayList.toArray(), "Warning", 2);
        }
    }
}

