/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.common.AlphanumComparator;
import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.ParaProfException;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.enums.SortType;
import edu.uoregon.tau.paraprof.enums.ValueType;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Group;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UtilFncs;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PPFunctionProfile
implements Comparable<PPFunctionProfile> {
    private DataSorter dataSorter;
    private Thread thread;
    private FunctionProfile functionProfile;
    private static AlphanumComparator alphanum = new AlphanumComparator();

    public PPFunctionProfile(DataSorter dataSorter, Thread thread, FunctionProfile functionProfile) {
        this.dataSorter = dataSorter;
        this.thread = thread;
        this.functionProfile = functionProfile;
    }

    public FunctionProfile getMeanProfile() {
        return this.functionProfile.getFunction().getMeanProfile();
    }

    public int getID() {
        return this.functionProfile.getFunction().getID();
    }

    public int getNodeID() {
        return this.thread.getNodeID();
    }

    public int getContextID() {
        return this.thread.getContextID();
    }

    public int getThreadID() {
        return this.thread.getThreadID();
    }

    public FunctionProfile getFunctionProfile() {
        return this.functionProfile;
    }

    public Function getFunction() {
        return this.functionProfile.getFunction();
    }

    public ParaProfTrial getPPTrial() {
        return this.dataSorter.getPpTrial();
    }

    public String getDisplayName() {
        return ParaProfUtils.getDisplayName(this.functionProfile.getFunction());
    }

    public Color getColor() {
        return this.functionProfile.getFunction().getColor();
    }

    public boolean isGroupMember(Group group) {
        return this.functionProfile.getFunction().isGroupMember(group);
    }

    public boolean isCallPathObject() {
        return this.functionProfile.getFunction().isCallPathFunction();
    }

    public double getInclusiveValue() {
        return this.functionProfile.getInclusive(this.dataSorter.getSelectedMetric().getID());
    }

    public double getExclusiveValue() {
        if (this.functionProfile.getFunction().isPhase() && this.functionProfile.getFunction().isCallPathFunction()) {
            return this.functionProfile.getInclusive(this.dataSorter.getSelectedMetric().getID());
        }
        return this.functionProfile.getExclusive(this.dataSorter.getSelectedMetric().getID());
    }

    public double getInclusivePercentValue() {
        return this.functionProfile.getInclusivePercent(this.dataSorter.getSelectedMetric().getID());
    }

    public double getExclusivePercentValue() {
        return this.functionProfile.getExclusivePercent(this.dataSorter.getSelectedMetric().getID());
    }

    public double getNumberOfCalls() {
        return this.functionProfile.getNumCalls();
    }

    public double getNumberOfSubRoutines() {
        return this.functionProfile.getNumSubr();
    }

    public double getInclusivePerCall() {
        return this.functionProfile.getInclusivePerCall(this.dataSorter.getSelectedSnapshot(), this.dataSorter.getSelectedMetric().getID());
    }

    public Iterator<FunctionProfile> getChildProfiles() {
        return this.functionProfile.getChildProfiles();
    }

    public Iterator<FunctionProfile> getParentProfiles() {
        return this.functionProfile.getParentProfiles();
    }

    public DataSorter getDataSorter() {
        return this.dataSorter;
    }

    public double getValue() {
        boolean bl = false;
        int n = this.dataSorter.getSelectedSnapshot();
        if (bl && n > 0) {
            double d = this.dataSorter.getValueType().getValue(this.getFunctionProfile(), this.dataSorter.getSelectedMetric().getID(), n - 1);
            double d2 = this.dataSorter.getValueType().getValue(this.getFunctionProfile(), this.dataSorter.getSelectedMetric().getID(), n);
            return d2 - d;
        }
        return this.dataSorter.getValueType().getValue(this.getFunctionProfile(), this.dataSorter.getSelectedMetric().getID(), this.dataSorter.getSelectedSnapshot());
    }

    public double getSortValue() {
        boolean bl = false;
        int n = this.dataSorter.getSelectedSnapshot();
        if (bl && n > 0) {
            double d = this.dataSorter.getSortValueType().getValue(this.getFunctionProfile(), this.dataSorter.getSortMetric().getID(), n - 1);
            double d2 = this.dataSorter.getSortValueType().getValue(this.getFunctionProfile(), this.dataSorter.getSortMetric().getID(), n);
            return d2 - d;
        }
        return this.dataSorter.getSortValueType().getValue(this.getFunctionProfile(), this.dataSorter.getSortMetric(), this.dataSorter.getSelectedSnapshot());
    }

    private int checkDescending(int n) {
        if (this.dataSorter.getDescendingOrder()) {
            return -n;
        }
        return n;
    }

    private int compareNCT(PPFunctionProfile pPFunctionProfile) {
        if (pPFunctionProfile.getNodeID() != this.getNodeID()) {
            return this.checkDescending(this.getNodeID() - pPFunctionProfile.getNodeID());
        }
        if (pPFunctionProfile.getContextID() != this.getContextID()) {
            return this.checkDescending(this.getContextID() - pPFunctionProfile.getContextID());
        }
        return this.checkDescending(this.getThreadID() - pPFunctionProfile.getThreadID());
    }

    @Override
    public int compareTo(PPFunctionProfile pPFunctionProfile) {
        ValueType valueType = this.dataSorter.getSortValueType();
        PPFunctionProfile pPFunctionProfile2 = pPFunctionProfile;
        if (this.dataSorter.getSortType() == SortType.NAME) {
            return this.checkDescending(alphanum.compare(pPFunctionProfile2.getDisplayName(), this.getDisplayName()));
        }
        if (this.dataSorter.getSortType() == SortType.NCT) {
            return this.compareNCT(pPFunctionProfile2);
        }
        if (this.dataSorter.getSortType() == SortType.MEAN_VALUE) {
            return this.checkDescending(this.compareToHelper(valueType.getValue(this.getMeanProfile(), this.dataSorter.getSortMetric(), this.dataSorter.getSelectedSnapshot()), valueType.getValue(pPFunctionProfile2.getMeanProfile(), this.dataSorter.getSortMetric(), this.dataSorter.getSelectedSnapshot()), this.getMeanProfile(), pPFunctionProfile2.getMeanProfile()));
        }
        if (this.dataSorter.getSortType() == SortType.VALUE) {
            return this.checkDescending(this.compareToHelper(this.getSortValue(), pPFunctionProfile2.getSortValue()));
        }
        throw new ParaProfException("Unexpected sort type: " + this.dataSorter.getSortType());
    }

    private int compareToHelper(double d, double d2) {
        double d3 = d - d2;
        if (d3 < 0.0) {
            return -1;
        }
        if (d3 == 0.0) {
            return 0;
        }
        return 1;
    }

    private int compareToHelper(double d, double d2, FunctionProfile functionProfile, FunctionProfile functionProfile2) {
        double d3 = d - d2;
        if (d3 < 0.0) {
            return -1;
        }
        if (d3 == 0.0) {
            return functionProfile.getFunction().compareTo(functionProfile2.getFunction());
        }
        return 1;
    }

    public String getStatString(int n) {
        int n2 = this.dataSorter.getSelectedMetric().getID();
        boolean bl = this.dataSorter.getSelectedMetric().isTimeDenominator();
        DecimalFormat decimalFormat = new DecimalFormat("##0.0");
        String string = UtilFncs.lpad((String)decimalFormat.format(this.functionProfile.getInclusivePercent(this.dataSorter.getSelectedSnapshot(), n2)), (int)13);
        string = this.functionProfile.getFunction().isPhase() && this.functionProfile.getFunction().isCallPathFunction() ? string + "  " + UtilFncs.getOutputString((int)n, (double)this.functionProfile.getInclusive(this.dataSorter.getSelectedSnapshot(), n2), (int)14, (boolean)bl) : string + "  " + UtilFncs.getOutputString((int)n, (double)this.functionProfile.getExclusive(this.dataSorter.getSelectedSnapshot(), n2), (int)14, (boolean)bl);
        string = string + "  " + UtilFncs.getOutputString((int)n, (double)this.functionProfile.getInclusive(this.dataSorter.getSelectedSnapshot(), n2), (int)16, (boolean)bl);
        string = string + "  " + UtilFncs.formatDouble((double)this.functionProfile.getNumCalls(this.dataSorter.getSelectedSnapshot()), (int)12, (boolean)true);
        string = string + "  " + UtilFncs.formatDouble((double)this.functionProfile.getNumSubr(this.dataSorter.getSelectedSnapshot()), (int)12, (boolean)true);
        string = string + "  " + UtilFncs.getOutputString((int)n, (double)this.functionProfile.getInclusivePerCall(this.dataSorter.getSelectedSnapshot(), n2), (int)19, (boolean)bl);
        return string;
    }

    public String toString() {
        return this.functionProfile.toString();
    }

    public Thread getThread() {
        return this.thread;
    }

    public static String getStatStringHeading(String string) {
        return UtilFncs.lpad((String)("%Total " + string), (int)13) + UtilFncs.lpad((String)"Exclusive", (int)16) + UtilFncs.lpad((String)"Inclusive", (int)18) + UtilFncs.lpad((String)"#Calls", (int)14) + UtilFncs.lpad((String)"#Child Calls", (int)14) + UtilFncs.lpad((String)"Inclusive/Call", (int)21) + "   ";
    }
}

