/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.common.Utility;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.Snapshot;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SnapshotControlWindow
extends JFrame {
    private static final long serialVersionUID = 4729291331179383482L;
    private ParaProfTrial ppTrial;
    private DataSource dataSource;
    private JSlider slider;
    private JLabel indexLabel = new JLabel("");
    private JLabel timeLabel = new JLabel("");
    private JLabel nameLabel = new JLabel("");
    private int numSnapshots;
    private int selectedSnapshot = -1;
    private JCheckBox animateCheckbox = new JCheckBox("Replay");
    private JSlider animateSlider = new JSlider(0, 100);
    private Animator animator;
    private volatile float rotateSpeed = 0.5f;

    public SnapshotControlWindow(ParaProfTrial paraProfTrial) {
        this.ppTrial = paraProfTrial;
        this.dataSource = paraProfTrial.getDataSource();
        this.setTitle("TAU: ParaProf: Snapshot Controller: " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        this.setSize(new Dimension(300, 180));
        this.numSnapshots = this.dataSource.getMeanData().getNumSnapshots();
        this.selectedSnapshot = this.numSnapshots - 1;
        this.slider = new JSlider(0, this.selectedSnapshot);
        this.slider.setSnapToTicks(true);
        this.slider.setPaintTicks(true);
        this.slider.setValue(this.selectedSnapshot);
        this.slider.setBackground(Color.white);
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                SnapshotControlWindow.this.selectedSnapshot = SnapshotControlWindow.this.slider.getValue();
                SnapshotControlWindow.this.setLabels();
                SnapshotControlWindow.this.ppTrial.setSelectedSnapshot(SnapshotControlWindow.this.selectedSnapshot);
            }
        });
        this.animateSlider.setBackground(Color.white);
        this.animateCheckbox.setBackground(Color.white);
        this.animateCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (SnapshotControlWindow.this.animateCheckbox.isSelected()) {
                        SnapshotControlWindow.this.animator = new Animator();
                        SnapshotControlWindow.this.animator.start();
                    } else {
                        SnapshotControlWindow.this.animator.end();
                        SnapshotControlWindow.this.animator = null;
                    }
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        });
        this.setLabels();
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        Utility.addCompItem((Container)jPanel, (Component)this.indexLabel, (GridBagConstraints)gridBagConstraints, (int)0, (int)0, (int)2, (int)1);
        gridBagConstraints.fill = 2;
        Utility.addCompItem((Container)jPanel, (Component)this.slider, (GridBagConstraints)gridBagConstraints, (int)0, (int)1, (int)2, (int)1);
        gridBagConstraints.fill = 0;
        Utility.addCompItem((Container)jPanel, (Component)this.nameLabel, (GridBagConstraints)gridBagConstraints, (int)0, (int)2, (int)2, (int)1);
        Utility.addCompItem((Container)jPanel, (Component)this.timeLabel, (GridBagConstraints)gridBagConstraints, (int)0, (int)3, (int)2, (int)1);
        gridBagConstraints.anchor = 15;
        Utility.addCompItem((Container)jPanel, (Component)this.animateCheckbox, (GridBagConstraints)gridBagConstraints, (int)0, (int)4, (int)1, (int)1);
        Utility.addCompItem((Container)jPanel, (Component)this.animateSlider, (GridBagConstraints)gridBagConstraints, (int)1, (int)4, (int)1, (int)1);
        this.getContentPane().add(jPanel);
        ParaProfUtils.setFrameIcon(this);
    }

    private void setLabels() {
        this.indexLabel.setText("Snapshot " + this.selectedSnapshot);
        Snapshot snapshot = (Snapshot)this.dataSource.getMeanData().getSnapshots().get(this.selectedSnapshot);
        long l = snapshot.getTimestamp() - this.dataSource.getMeanData().getStartTime();
        l = (long)((double)l / 1000000.0);
        this.timeLabel.setText("Time Position: " + l + " Seconds");
        this.nameLabel.setText("Name: " + snapshot.getName());
    }

    private class Animator
    extends Thread {
        private volatile boolean stop = false;

        private Animator() {
        }

        public void run() {
            this.stop = false;
            while (!this.stop) {
                try {
                    if (SnapshotControlWindow.this.rotateSpeed == 0.0f) {
                        Thread.sleep(250L);
                        continue;
                    }
                    Runnable runnable = new Runnable(){

                        public void run() {
                            if (SnapshotControlWindow.this.slider.getValue() >= SnapshotControlWindow.this.slider.getMaximum()) {
                                SnapshotControlWindow.this.slider.setValue(0);
                            } else {
                                SnapshotControlWindow.this.slider.setValue(SnapshotControlWindow.this.slider.getValue() + 2);
                            }
                        }
                    };
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (Exception exception) {}
            }
        }

        public void end() {
            this.stop = true;
        }
    }
}

