/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.common.MetaDataMap;
import edu.uoregon.tau.common.Utility;
import edu.uoregon.tau.paraprof.FunctionSelectorDialog;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.ThreeDeeGeneralPlotUtils;
import edu.uoregon.tau.paraprof.ThreeDeeScalePanel;
import edu.uoregon.tau.paraprof.ThreeDeeSettings;
import edu.uoregon.tau.paraprof.ThreeDeeWindow;
import edu.uoregon.tau.paraprof.enums.UserEventValueType;
import edu.uoregon.tau.paraprof.enums.ValueType;
import edu.uoregon.tau.paraprof.enums.VisType;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UserEvent;
import edu.uoregon.tau.perfdmf.UtilFncs;
import edu.uoregon.tau.vis.Plot;
import edu.uoregon.tau.vis.SteppedComboBox;
import edu.uoregon.tau.vis.VisRenderer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreeDeeControlPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -8413853906212906751L;
    private ThreeDeeSettings settings;
    private ThreeDeeWindow window;
    private ParaProfTrial ppTrial;
    private SteppedComboBox heightValueBox;
    private SteppedComboBox heightMetricBox;
    private SteppedComboBox colorValueBox;
    private SteppedComboBox colorMetricBox;
    private JScrollPane spane;
    private VisRenderer visRenderer;
    private JTextField heightValueField = new JTextField("");
    private JTextField colorValueField = new JTextField("");
    private JTextField minTopoField = new JTextField("");
    private JTextField maxTopoField = new JTextField("");
    private int selectedTab;
    private JTabbedPane tabbedPane;
    private ThreeDeeScalePanel scalePanel;
    private SteppedComboBox topoComboBox;
    private int customTopoDex = -1;
    private int selectedTopoDex = 0;
    private static final String CUSTOM = "Custom";
    private static final String MAP = "Map";
    boolean mySlide = false;
    int lockDiff = 0;
    JSlider minTopoSlider;
    JSlider maxTopoSlider;
    JLabel[] customAxisLabels = new JLabel[3];
    JSpinner[] customAxisSpinners = new JSpinner[3];
    JLabel[] selectAxisLabels = new JLabel[3];
    JSlider[] selectAxisSliders = new JSlider[3];
    private static final String[] topoLabelStrings = new String[]{"X Axis", "Y Axis", "Z Axis"};
    boolean firstSet = false;
    JCheckBox lockBox;
    JTextArea topoValField;
    JLabel topoValLabel;
    private JPanel[] topoSelectPanels = new JPanel[4];
    private boolean topoCreated = false;
    private static final String CV = "Color Value (Event 3): ";
    private static final String ACV = "Avg Color Value (Event 3): ";

    public ThreeDeeControlPanel(ThreeDeeWindow threeDeeWindow, ThreeDeeSettings threeDeeSettings, ParaProfTrial paraProfTrial, VisRenderer visRenderer) {
        this.settings = threeDeeSettings;
        this.window = threeDeeWindow;
        this.ppTrial = paraProfTrial;
        this.visRenderer = visRenderer;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButton jRadioButton = new JRadioButton(VisType.TRIANGLE_MESH_PLOT.toString(), threeDeeSettings.getVisType() == VisType.TRIANGLE_MESH_PLOT);
        jRadioButton.addActionListener(this);
        buttonGroup.add(jRadioButton);
        this.addCompItem(this, jRadioButton, gridBagConstraints, 0, 0, 1, 1);
        jRadioButton = new JRadioButton(VisType.BAR_PLOT.toString(), threeDeeSettings.getVisType() == VisType.BAR_PLOT);
        jRadioButton.addActionListener(this);
        buttonGroup.add(jRadioButton);
        this.addCompItem(this, jRadioButton, gridBagConstraints, 0, 2, 1, 1);
        jRadioButton = new JRadioButton(VisType.SCATTER_PLOT.toString(), threeDeeSettings.getVisType() == VisType.SCATTER_PLOT);
        jRadioButton.addActionListener(this);
        buttonGroup.add(jRadioButton);
        this.addCompItem(this, jRadioButton, gridBagConstraints, 0, 3, 1, 1);
        jRadioButton = new JRadioButton(VisType.TOPO_PLOT.toString(), threeDeeSettings.getVisType() == VisType.TOPO_PLOT);
        jRadioButton.addActionListener(this);
        buttonGroup.add(jRadioButton);
        this.addCompItem(this, jRadioButton, gridBagConstraints, 0, 4, 1, 1);
        this.createSubPanel();
    }

    private void createSubPanel() {
        if (this.spane != null) {
            this.remove(this.spane);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        JPanel jPanel = null;
        jPanel = this.settings.getVisType() == VisType.SCATTER_PLOT ? this.createScatterPanel() : (this.settings.getVisType() == VisType.TOPO_PLOT ? this.createTopoPanel() : (this.settings.getVisType() == VisType.CALLGRAPH ? this.createCallGraphPanel() : this.createFullDataPanel()));
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        Dimension dimension = jPanel.getMinimumSize();
        jPanel.setPreferredSize(new Dimension((int)dimension.getWidth(), (int)dimension.getHeight() + 100));
        jPanel.setSize(jPanel.getPreferredSize());
        this.spane = new JScrollPane(jPanel);
        this.addCompItem(this, this.spane, gridBagConstraints, 0, 5, 1, 1);
        this.revalidate();
        this.validate();
        this.spane.setMinimumSize(new Dimension((int)dimension.getWidth() + 25, (int)dimension.getHeight()));
        this.setPreferredSize(this.getMinimumSize());
    }

    private JPanel createScatterSelectionPanel(String string, final int n) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        String string2 = "   <none>";
        if (this.settings.getScatterFunctions()[n] != null) {
            string2 = this.settings.getScatterFunctions()[n].getName();
        }
        final JTextField jTextField = new JTextField(string2);
        jTextField.setToolTipText(string2);
        jTextField.setEditable(false);
        jTextField.setBorder(BorderFactory.createLoweredBevelBorder());
        jTextField.setCaretPosition(0);
        final SteppedComboBox steppedComboBox = new SteppedComboBox((Object[])ValueType.VALUES);
        Dimension dimension = steppedComboBox.getPreferredSize();
        steppedComboBox.setMinimumSize(new Dimension(50, steppedComboBox.getMinimumSize().height));
        steppedComboBox.setPopupWidth(dimension.width);
        final SteppedComboBox steppedComboBox2 = new SteppedComboBox((Object[])this.ppTrial.getMetricArray());
        dimension = steppedComboBox2.getPreferredSize();
        steppedComboBox2.setMinimumSize(new Dimension(50, steppedComboBox2.getMinimumSize().height));
        steppedComboBox2.setPopupWidth(dimension.width);
        steppedComboBox.setSelectedItem((Object)this.settings.getScatterValueTypes()[n]);
        steppedComboBox2.setSelectedItem((Object)this.settings.getScatterMetrics()[n]);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ThreeDeeControlPanel.this.settings.setScatterValueType((ValueType)steppedComboBox.getSelectedItem(), n);
                    ThreeDeeControlPanel.this.settings.setScatterMetric((Metric)steppedComboBox2.getSelectedItem(), n);
                    ThreeDeeControlPanel.this.window.redraw();
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        };
        steppedComboBox.addActionListener(actionListener);
        steppedComboBox2.addActionListener(actionListener);
        JButton jButton = new JButton("...");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    FunctionSelectorDialog functionSelectorDialog = new FunctionSelectorDialog(ThreeDeeControlPanel.this.window, true, ThreeDeeControlPanel.this.ppTrial.getDisplayedFunctions().iterator(), ThreeDeeControlPanel.this.settings.getScatterFunctions()[n], true, false);
                    if (functionSelectorDialog.choose()) {
                        Function function = (Function)functionSelectorDialog.getSelectedObject();
                        ThreeDeeControlPanel.this.settings.setScatterFunction(function, n);
                        String string = "   <none>";
                        if (ThreeDeeControlPanel.this.settings.getScatterFunctions()[n] != null) {
                            string = ParaProfUtils.getDisplayName(ThreeDeeControlPanel.this.settings.getScatterFunctions()[n]);
                        }
                        jTextField.setText(string);
                        jTextField.setToolTipText(string);
                        ThreeDeeControlPanel.this.window.redraw();
                    }
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        this.addCompItem(jPanel2, jTextField, gridBagConstraints, 0, 0, 1, 1);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        this.addCompItem(jPanel2, jButton, gridBagConstraints, 1, 0, 1, 1);
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        this.addCompItem(jPanel, jPanel2, gridBagConstraints, 1, 0, 2, 1);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        this.addCompItem(jPanel, (Component)steppedComboBox, gridBagConstraints, 1, 1, 1, 1);
        this.addCompItem(jPanel, (Component)steppedComboBox2, gridBagConstraints, 2, 1, 1, 1);
        return jPanel;
    }

    private JPanel createTopoIntervalSelectionPanel(String string, final int n) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        String[] stringArray = new String[]{"Timer", "Atomic", "Metadata"};
        final JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.setToolTipText("Select type of values to use for this axis");
        String string2 = "   <none>";
        if (this.settings.getTopoFunction(n) == null && this.settings.getScatterFunctions()[n] != null) {
            this.settings.setTopoFunction(this.settings.getScatterFunctions()[n], n);
        }
        if (this.settings.getTopoFunction(n) != null) {
            string2 = this.settings.getTopoFunction(n).getName();
        }
        final JTextField jTextField = new JTextField(string2);
        jTextField.setToolTipText(string2);
        jTextField.setEditable(false);
        jTextField.setBorder(BorderFactory.createLoweredBevelBorder());
        jTextField.setCaretPosition(0);
        final SteppedComboBox steppedComboBox = new SteppedComboBox((Object[])ValueType.VALUES);
        Dimension dimension = steppedComboBox.getPreferredSize();
        steppedComboBox.setMinimumSize(new Dimension(50, steppedComboBox.getMinimumSize().height));
        steppedComboBox.setPopupWidth(dimension.width);
        final SteppedComboBox steppedComboBox2 = new SteppedComboBox((Object[])this.ppTrial.getMetricArray());
        dimension = steppedComboBox2.getPreferredSize();
        steppedComboBox2.setMinimumSize(new Dimension(50, steppedComboBox2.getMinimumSize().height));
        steppedComboBox2.setPopupWidth(dimension.width);
        steppedComboBox.setSelectedItem((Object)this.settings.getTopoValueType(n));
        steppedComboBox2.setSelectedItem((Object)this.settings.getTopoMetric(n));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object object = steppedComboBox.getSelectedItem();
                    if (object == null) {
                        return;
                    }
                    if (jComboBox.getSelectedIndex() == 0 && object instanceof ValueType) {
                        ThreeDeeControlPanel.this.settings.setTopoValueType((ValueType)steppedComboBox.getSelectedItem(), n);
                        ThreeDeeControlPanel.this.settings.setTopoMetric((Metric)steppedComboBox2.getSelectedItem(), n);
                        ((ThreeDeeControlPanel)ThreeDeeControlPanel.this).settings.intervalETDex[n] = steppedComboBox.getSelectedIndex();
                    } else if (jComboBox.getSelectedIndex() == 1 && object instanceof UserEventValueType) {
                        ThreeDeeControlPanel.this.settings.setTopoUserEventValueType((UserEventValueType)steppedComboBox.getSelectedItem(), n);
                        ((ThreeDeeControlPanel)ThreeDeeControlPanel.this).settings.atomicETDex[n] = steppedComboBox.getSelectedIndex();
                    } else if (jComboBox.getSelectedIndex() == 2) {
                        // empty if block
                    }
                    ThreeDeeControlPanel.this.window.redraw();
                    ThreeDeeControlPanel.this.minTopoField.setText(ThreeDeeControlPanel.this.window.getSelectedMinTopoValue());
                    ThreeDeeControlPanel.this.maxTopoField.setText(ThreeDeeControlPanel.this.window.getSelectedMaxTopoValue());
                    ThreeDeeControlPanel.this.topoValField.setText(ThreeDeeControlPanel.this.window.getStatMean() + ThreeDeeControlPanel.this.window.getSelectedThread());
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        };
        steppedComboBox.addActionListener(actionListener);
        steppedComboBox2.addActionListener(actionListener);
        jComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = null;
                if (jComboBox.getSelectedIndex() == 1) {
                    int n2 = ThreeDeeControlPanel.this.ppTrial.getDataSource().getNumUserEvents();
                    if (n2 < 1) {
                        jComboBox.setSelectedIndex(0);
                        return;
                    }
                    steppedComboBox2.setEnabled(false);
                    steppedComboBox.setEditable(true);
                    steppedComboBox.removeAllItems();
                    for (int i = 0; i < UserEventValueType.VALUES.length; ++i) {
                        steppedComboBox.addItem((Object)UserEventValueType.VALUES[i]);
                    }
                    steppedComboBox.setSelectedIndex(((ThreeDeeControlPanel)ThreeDeeControlPanel.this).settings.atomicETDex[n]);
                    if (ThreeDeeControlPanel.this.settings.getTopoAtomic(n) == null) {
                        UserEvent userEvent = (UserEvent)ThreeDeeControlPanel.this.ppTrial.getDataSource().getUserEventIterator().next();
                        ThreeDeeControlPanel.this.settings.setTopoAtomic(userEvent, n);
                    }
                    string = ThreeDeeControlPanel.this.settings.getTopoAtomic(n).getName();
                } else if (jComboBox.getSelectedIndex() == 0) {
                    steppedComboBox2.setEnabled(true);
                    steppedComboBox.setEditable(true);
                    steppedComboBox.removeAllItems();
                    for (int i = 0; i < ValueType.VALUES.length; ++i) {
                        steppedComboBox.addItem((Object)ValueType.VALUES[i]);
                    }
                    steppedComboBox.setSelectedIndex(((ThreeDeeControlPanel)ThreeDeeControlPanel.this).settings.intervalETDex[n]);
                    string = ParaProfUtils.getDisplayName(ThreeDeeControlPanel.this.settings.getTopoFunction(n));
                } else if (jComboBox.getSelectedIndex() == 2) {
                    steppedComboBox2.setEnabled(false);
                    steppedComboBox.removeAllItems();
                    steppedComboBox.setEditable(false);
                    MetaDataMap.MetaDataKey metaDataKey = ThreeDeeControlPanel.this.settings.getTopoMetadata(n);
                    if (metaDataKey == null) {
                        Thread thread = ThreeDeeControlPanel.this.ppTrial.getDataSource().getThread(0, 0, 0);
                        if (thread == null) {
                            thread = (Thread)ThreeDeeControlPanel.this.ppTrial.getDataSource().getThreads().get(0);
                        }
                        metaDataKey = (MetaDataMap.MetaDataKey)thread.getMetaData().keySet().iterator().next();
                        ThreeDeeControlPanel.this.settings.setTopoMetadata(metaDataKey, n);
                    }
                    string = metaDataKey.toString();
                }
                ThreeDeeControlPanel.this.settings.setDataType(jComboBox.getSelectedIndex(), n);
                jTextField.setText(string);
                jTextField.setToolTipText(string);
                ThreeDeeControlPanel.this.window.redraw();
                ThreeDeeControlPanel.this.minTopoField.setText(ThreeDeeControlPanel.this.window.getSelectedMinTopoValue());
                ThreeDeeControlPanel.this.maxTopoField.setText(ThreeDeeControlPanel.this.window.getSelectedMaxTopoValue());
                ThreeDeeControlPanel.this.topoValField.setText(ThreeDeeControlPanel.this.window.getStatMean() + ThreeDeeControlPanel.this.window.getSelectedThread());
            }
        });
        JButton jButton = new JButton("...");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    String string = jTextField.getText();
                    if (string == null || string.length() == 0) {
                        string = "   <none>";
                    }
                    if (jComboBox.getSelectedIndex() == 0) {
                        FunctionSelectorDialog functionSelectorDialog = new FunctionSelectorDialog(ThreeDeeControlPanel.this.window, true, ThreeDeeControlPanel.this.ppTrial.getDisplayedFunctions().iterator(), ThreeDeeControlPanel.this.settings.getTopoFunction(n), true, false);
                        if (functionSelectorDialog.choose()) {
                            Function function = (Function)functionSelectorDialog.getSelectedObject();
                            ThreeDeeControlPanel.this.settings.setTopoFunction(function, n);
                            if (ThreeDeeControlPanel.this.settings.getTopoFunction(n) != null) {
                                string = ParaProfUtils.getDisplayName(ThreeDeeControlPanel.this.settings.getTopoFunction(n));
                            }
                        }
                    } else if (jComboBox.getSelectedIndex() == 1) {
                        FunctionSelectorDialog functionSelectorDialog = new FunctionSelectorDialog(ThreeDeeControlPanel.this.window, true, ThreeDeeControlPanel.this.ppTrial.getDataSource().getUserEventIterator(), ThreeDeeControlPanel.this.settings.getTopoAtomic(n), true, false);
                        if (functionSelectorDialog.choose()) {
                            UserEvent userEvent = (UserEvent)functionSelectorDialog.getSelectedObject();
                            ThreeDeeControlPanel.this.settings.setTopoAtomic(userEvent, n);
                            if (ThreeDeeControlPanel.this.settings.getTopoAtomic(n) != null) {
                                string = ThreeDeeControlPanel.this.settings.getTopoAtomic(n).getName();
                            }
                        }
                    } else if (jComboBox.getSelectedIndex() == 2) {
                        Thread thread = ThreeDeeControlPanel.this.ppTrial.getDataSource().getThread(0, 0, 0);
                        if (thread == null) {
                            thread = (Thread)ThreeDeeControlPanel.this.ppTrial.getDataSource().getThreads().get(0);
                        }
                        TreeSet treeSet = new TreeSet();
                        treeSet.addAll(thread.getMetaData().keySet());
                        treeSet.addAll(ThreeDeeControlPanel.this.ppTrial.getDataSource().getMetaData().keySet());
                        FunctionSelectorDialog functionSelectorDialog = new FunctionSelectorDialog(ThreeDeeControlPanel.this.window, true, treeSet.iterator(), ThreeDeeControlPanel.this.settings.getTopoMetadata(n), true, false);
                        if (functionSelectorDialog.choose()) {
                            MetaDataMap.MetaDataKey metaDataKey = (MetaDataMap.MetaDataKey)functionSelectorDialog.getSelectedObject();
                            ThreeDeeControlPanel.this.settings.setTopoMetadata(metaDataKey, n);
                            if (ThreeDeeControlPanel.this.settings.getTopoMetadata(n) != null) {
                                string = ThreeDeeControlPanel.this.settings.getTopoMetadata(n).toString();
                            }
                        }
                    }
                    jTextField.setText(string);
                    jTextField.setToolTipText(string);
                    ThreeDeeControlPanel.this.window.redraw();
                    ThreeDeeControlPanel.this.minTopoField.setText(ThreeDeeControlPanel.this.window.getSelectedMinTopoValue());
                    ThreeDeeControlPanel.this.maxTopoField.setText(ThreeDeeControlPanel.this.window.getSelectedMaxTopoValue());
                    ThreeDeeControlPanel.this.topoValField.setText(ThreeDeeControlPanel.this.window.getStatMean() + ThreeDeeControlPanel.this.window.getSelectedThread());
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        this.addCompItem(jPanel2, jTextField, gridBagConstraints, 0, 0, 1, 1);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        this.addCompItem(jPanel2, jButton, gridBagConstraints, 1, 0, 1, 1);
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addCompItem(jPanel, new JLabel(string), gridBagConstraints, 1, 0, 1, 1);
        this.addCompItem(jPanel, jComboBox, gridBagConstraints, 2, 0, 1, 1);
        gridBagConstraints.fill = 2;
        this.addCompItem(jPanel, jPanel2, gridBagConstraints, 1, 1, 2, 1);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        this.addCompItem(jPanel, (Component)steppedComboBox, gridBagConstraints, 1, 2, 1, 1);
        this.addCompItem(jPanel, (Component)steppedComboBox2, gridBagConstraints, 2, 2, 1, 1);
        return jPanel;
    }

    private void updateTopoList() {
        int n;
        for (int i = n = this.topoComboBox.getItemCount() - 1; i > this.customTopoDex + 1; --i) {
            this.topoComboBox.removeItemAt(i);
        }
        String string = this.settings.getTopoDefFile();
        if (string != null) {
            List<String> list = ThreeDeeGeneralPlotUtils.getCustomTopoNames(string);
            for (int i = 0; i < list.size(); ++i) {
                this.topoComboBox.addItem((Object)list.get(i));
            }
        }
    }

    private boolean checkDisableTopoWidgets(String string) {
        boolean bl = string.equals(CUSTOM) || string.equals("BGQ") || string.equals(MAP) || string.startsWith("Topo");
        return !bl;
    }

    private void switchTopoSelectPanels(boolean bl) {
        for (int i = 0; i < 3; ++i) {
            if (this.topoSelectPanels[i] == null) continue;
            this.topoSelectPanels[i].setEnabled(bl);
            Component[] componentArray = this.topoSelectPanels[i].getComponents();
            for (int j = 0; j < componentArray.length; ++j) {
                componentArray[j].setEnabled(bl);
                if (!(componentArray[j] instanceof JPanel)) continue;
                Component[] componentArray2 = ((JPanel)componentArray[j]).getComponents();
                for (int k = 0; k < componentArray2.length; ++k) {
                    componentArray2[k].setEnabled(bl);
                }
            }
        }
    }

    private JPanel createTopoSelectionPanel(String string) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        Vector<String> vector = this.ppTrial.getTopologyArray();
        vector.add(CUSTOM);
        this.customTopoDex = vector.size() - 1;
        vector.add(MAP);
        this.topoComboBox = new SteppedComboBox(vector);
        if (this.selectedTopoDex < this.topoComboBox.getItemCount()) {
            this.topoComboBox.setSelectedIndex(this.selectedTopoDex);
        }
        Dimension dimension = this.topoComboBox.getPreferredSize();
        this.topoComboBox.setMinimumSize(new Dimension(100, this.topoComboBox.getMinimumSize().height));
        this.topoComboBox.setPopupWidth(dimension.width);
        this.updateTopoList();
        this.settings.setTopoCart((String)this.topoComboBox.getSelectedItem());
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    String string;
                    boolean bl;
                    ThreeDeeControlPanel.this.settings.setTopoCart((String)ThreeDeeControlPanel.this.topoComboBox.getSelectedItem());
                    boolean bl2 = ThreeDeeControlPanel.this.topoComboBox.getSelectedIndex() > ThreeDeeControlPanel.this.customTopoDex + 1;
                    ThreeDeeControlPanel.this.settings.setCustomTopo(bl2);
                    ThreeDeeControlPanel.this.switchTopoSelectPanels(ThreeDeeControlPanel.this.checkDisableTopoWidgets((String)ThreeDeeControlPanel.this.topoComboBox.getSelectedItem()));
                    boolean bl3 = bl = ThreeDeeControlPanel.this.topoComboBox.getSelectedIndex() == ThreeDeeControlPanel.this.customTopoDex + 1;
                    if (bl && (string = ThreeDeeControlPanel.this.settings.getTopoMapFile()) == null) {
                        ThreeDeeControlPanel.this.topoComboBox.setSelectedIndex(ThreeDeeControlPanel.this.selectedTopoDex);
                        System.out.println("Select a valid map file");
                        return;
                    }
                    ThreeDeeControlPanel.this.selectedTopoDex = ThreeDeeControlPanel.this.topoComboBox.getSelectedIndex();
                    ThreeDeeControlPanel.this.resetTopoAxisSliders(true);
                    ThreeDeeControlPanel.this.window.redraw();
                    ThreeDeeControlPanel.this.resetTopoAxisSliders(true);
                    for (int i = 0; i < 3; ++i) {
                        if (ThreeDeeControlPanel.this.customAxisSpinners[i] == null) continue;
                        ThreeDeeControlPanel.this.customAxisSpinners[i].setEnabled(ThreeDeeControlPanel.this.settings.getTopoCart().equals(ThreeDeeControlPanel.CUSTOM));
                    }
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        };
        this.topoComboBox.addActionListener(actionListener);
        if (this.selectedTopoDex < this.topoComboBox.getItemCount()) {
            this.topoComboBox.setSelectedIndex(this.selectedTopoDex);
        }
        JButton jButton = new JButton("...");
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    File file;
                    JFileChooser jFileChooser = new JFileChooser("Select a topology definition file");
                    if (ParaProf.schemaLocation != null && (file = new File(ParaProf.schemaLocation + File.separatorChar + "topology")).canRead()) {
                        jFileChooser.setCurrentDirectory(file);
                    }
                    jFileChooser.showOpenDialog(ThreeDeeControlPanel.this.window);
                    file = jFileChooser.getSelectedFile();
                    if (file != null && file.exists() && file.canRead()) {
                        String string = file.getAbsolutePath();
                        ThreeDeeControlPanel.this.settings.setTopoDefFile(string);
                        ThreeDeeControlPanel.this.updateTopoList();
                    }
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        };
        jButton.addActionListener(actionListener2);
        JButton jButton2 = new JButton(MAP);
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    JFileChooser jFileChooser = new JFileChooser("Select a topology map file");
                    jFileChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
                    jFileChooser.showOpenDialog(ThreeDeeControlPanel.this.window);
                    File file = jFileChooser.getSelectedFile();
                    if (file != null && file.exists() && file.canRead()) {
                        String string = file.getAbsolutePath();
                        ThreeDeeControlPanel.this.settings.setTopoMapFile(string);
                    }
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        };
        jButton2.addActionListener(actionListener3);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        this.addCompItem(jPanel, new JLabel("Topology"), gridBagConstraints, 0, 1, 1, 1);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.addCompItem(jPanel, (Component)this.topoComboBox, gridBagConstraints, 1, 1, 1, 1);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        this.addCompItem(jPanel, jButton, gridBagConstraints, 2, 1, 1, 1);
        this.addCompItem(jPanel, jButton2, gridBagConstraints, 3, 1, 1, 1);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        this.customAxisLabels[0] = new JLabel("X Axis");
        this.addCompItem(jPanel, this.customAxisLabels[0], gridBagConstraints, 0, 3, 1, 1);
        this.addCompItem(jPanel, this.createTopoCustomAxisSpinnerPanel(0, this.customAxisSpinners), gridBagConstraints, 1, 3, 1, 1);
        gridBagConstraints.weightx = 0.0;
        this.customAxisLabels[1] = new JLabel("Y Axis");
        this.addCompItem(jPanel, this.customAxisLabels[1], gridBagConstraints, 0, 4, 1, 1);
        this.addCompItem(jPanel, this.createTopoCustomAxisSpinnerPanel(1, this.customAxisSpinners), gridBagConstraints, 1, 4, 1, 1);
        gridBagConstraints.weightx = 0.0;
        this.customAxisLabels[2] = new JLabel("Z Axis");
        this.addCompItem(jPanel, this.customAxisLabels[2], gridBagConstraints, 0, 5, 1, 1);
        this.addCompItem(jPanel, this.createTopoCustomAxisSpinnerPanel(2, this.customAxisSpinners), gridBagConstraints, 1, 5, 1, 1);
        return jPanel;
    }

    private JPanel createTopoMinRangeSelectionPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.minTopoSlider = new JSlider(0, 0, 100, 0);
        this.minTopoField.setEditable(false);
        this.minTopoSlider.setValue(this.settings.getMinTopoRange());
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (ThreeDeeControlPanel.this.mySlide) {
                    return;
                }
                try {
                    if (ThreeDeeControlPanel.this.lockBox.isSelected()) {
                        ThreeDeeControlPanel.this.mySlide = true;
                        ThreeDeeControlPanel.this.maxTopoSlider.setValue(ThreeDeeControlPanel.this.minTopoSlider.getValue() + ThreeDeeControlPanel.this.lockDiff);
                        ThreeDeeControlPanel.this.settings.setMaxTopoRange(ThreeDeeControlPanel.this.maxTopoSlider.getValue());
                        ThreeDeeControlPanel.this.mySlide = false;
                    }
                    ThreeDeeControlPanel.this.settings.setMinTopoRange(ThreeDeeControlPanel.this.minTopoSlider.getValue());
                    ThreeDeeControlPanel.this.window.redraw();
                    ThreeDeeControlPanel.this.minTopoField.setText(ThreeDeeControlPanel.this.window.getSelectedMinTopoValue());
                    ThreeDeeControlPanel.this.maxTopoField.setText(ThreeDeeControlPanel.this.window.getSelectedMaxTopoValue());
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        };
        this.minTopoSlider.addChangeListener(changeListener);
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        this.addCompItem(jPanel, this.minTopoSlider, gridBagConstraints, 0, 0, 1, 1);
        this.addCompItem(jPanel, this.minTopoField, gridBagConstraints, 0, 1, 1, 1);
        return jPanel;
    }

    private JPanel createTopoMaxRangeSelectionPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.maxTopoSlider = new JSlider(0, 0, 100, 100);
        this.maxTopoField.setEditable(false);
        this.maxTopoSlider.setValue(this.settings.getMaxTopoRange());
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (ThreeDeeControlPanel.this.mySlide) {
                    return;
                }
                try {
                    if (ThreeDeeControlPanel.this.lockBox.isSelected()) {
                        ThreeDeeControlPanel.this.mySlide = true;
                        ThreeDeeControlPanel.this.minTopoSlider.setValue(ThreeDeeControlPanel.this.maxTopoSlider.getValue() - ThreeDeeControlPanel.this.lockDiff);
                        ThreeDeeControlPanel.this.settings.setMinTopoRange(ThreeDeeControlPanel.this.minTopoSlider.getValue());
                        ThreeDeeControlPanel.this.mySlide = false;
                    }
                    ThreeDeeControlPanel.this.settings.setMaxTopoRange(ThreeDeeControlPanel.this.maxTopoSlider.getValue());
                    ThreeDeeControlPanel.this.window.redraw();
                    ThreeDeeControlPanel.this.minTopoField.setText(ThreeDeeControlPanel.this.window.getSelectedMinTopoValue());
                    ThreeDeeControlPanel.this.maxTopoField.setText(ThreeDeeControlPanel.this.window.getSelectedMaxTopoValue());
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        };
        this.maxTopoSlider.addChangeListener(changeListener);
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        this.addCompItem(jPanel, this.maxTopoSlider, gridBagConstraints, 0, 0, 1, 1);
        this.addCompItem(jPanel, this.maxTopoField, gridBagConstraints, 0, 1, 1, 1);
        return jPanel;
    }

    private JPanel createTopoAxisSelectionPanel(int n) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.selectAxisSliders[n] = new JSlider(0, -1, 100, -1);
        final int n2 = n;
        this.selectAxisSliders[n].setValue(this.settings.getTopoVisAxis(n));
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                try {
                    if (!ThreeDeeControlPanel.this.firstSet) {
                        int n = ThreeDeeControlPanel.this.selectAxisSliders[n2].getValue();
                        ThreeDeeControlPanel.this.settings.setTopoVisAxis(n, n2);
                        ThreeDeeControlPanel.this.window.redraw();
                        if (n == -1) {
                            ThreeDeeControlPanel.this.selectAxisLabels[n2].setText(topoLabelStrings[n2]);
                        } else {
                            ThreeDeeControlPanel.this.selectAxisLabels[n2].setText(topoLabelStrings[n2] + ": " + n);
                        }
                        ThreeDeeControlPanel.this.topoValField.setText(ThreeDeeControlPanel.this.window.getStatMean() + ThreeDeeControlPanel.this.window.getSelectedThread());
                        if (ThreeDeeControlPanel.this.allAxesOn()) {
                            ThreeDeeControlPanel.this.topoValLabel.setText(ThreeDeeControlPanel.CV);
                        } else {
                            ThreeDeeControlPanel.this.topoValLabel.setText(ThreeDeeControlPanel.ACV);
                        }
                    } else {
                        ThreeDeeControlPanel.this.firstSet = false;
                    }
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        };
        this.selectAxisSliders[n].addChangeListener(changeListener);
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        this.addCompItem(jPanel, this.selectAxisSliders[n], gridBagConstraints, 0, 0, 1, 1);
        return jPanel;
    }

    private JPanel createTopoCustomAxisSpinnerPanel(int n, final JSpinner[] jSpinnerArray) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        jSpinnerArray[n] = new JSpinner();
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(20, 0, 1000, 1);
        jSpinnerArray[n].setModel(spinnerNumberModel);
        jSpinnerArray[n].setEnabled(((String)this.topoComboBox.getSelectedItem()).equals(CUSTOM));
        final int n2 = n;
        int n3 = this.settings.getCustomTopoAxis(n);
        if (n3 > 0) {
            jSpinnerArray[n].setValue(this.settings.getCustomTopoAxis(n));
        } else {
            this.settings.setCustomTopoAxis(20, n);
        }
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                try {
                    int n = (Integer)jSpinnerArray[n2].getModel().getValue();
                    ThreeDeeControlPanel.this.settings.setCustomTopoAxis(n, n2);
                    ThreeDeeControlPanel.this.resetTopoAxisSliders(true);
                    ThreeDeeControlPanel.this.window.redraw();
                    ThreeDeeControlPanel.this.resetTopoAxisSliders(true);
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        };
        jSpinnerArray[n].addChangeListener(changeListener);
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        this.addCompItem(jPanel, jSpinnerArray[n], gridBagConstraints, 0, 0, 1, 1);
        return jPanel;
    }

    private JPanel createCallGraphPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.addCompItem(jPanel, new JLabel("Thread"), gridBagConstraints, 0, 0, 1, 1);
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        arrayList.add(this.ppTrial.getDataSource().getMeanData());
        arrayList.add(this.ppTrial.getDataSource().getStdDevData());
        arrayList.addAll(this.ppTrial.getDataSource().getAllThreads());
        final SliderComboBox sliderComboBox = new SliderComboBox(arrayList.toArray());
        sliderComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ThreeDeeControlPanel.this.settings.setSelectedThread((Thread)sliderComboBox.getSelectedItem());
                System.out.println("bargle");
                ThreeDeeControlPanel.this.window.redraw();
            }
        });
        this.addCompItem(jPanel, sliderComboBox, gridBagConstraints, 1, 0, 1, 1);
        this.tabbedPane = new JTabbedPane();
        Plot plot = this.window.getPlot();
        this.tabbedPane.addTab(plot.getName(), plot.getControlPanel(this.visRenderer));
        this.tabbedPane.addTab("ColorScale", this.window.getColorScale().getControlPanel(this.visRenderer));
        this.tabbedPane.addTab("Render", this.visRenderer.getControlPanel());
        this.tabbedPane.setMinimumSize(new Dimension(300, 250));
        this.tabbedPane.setSelectedIndex(0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        this.addCompItem(jPanel, this.tabbedPane, gridBagConstraints, 0, 1, 2, 1);
        return jPanel;
    }

    private JPanel createScatterPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.weightx = 0.0;
        this.addCompItem(jPanel, new JLabel("Width"), gridBagConstraints, 0, 0, 1, 1);
        this.addCompItem(jPanel, this.createScatterSelectionPanel("Width", 0), gridBagConstraints, 1, 0, 1, 1);
        gridBagConstraints.weightx = 0.0;
        this.addCompItem(jPanel, new JLabel("Depth"), gridBagConstraints, 0, 1, 1, 1);
        this.addCompItem(jPanel, this.createScatterSelectionPanel("Depth", 1), gridBagConstraints, 1, 1, 1, 1);
        gridBagConstraints.weightx = 0.0;
        this.addCompItem(jPanel, new JLabel("Height"), gridBagConstraints, 0, 2, 1, 1);
        this.addCompItem(jPanel, this.createScatterSelectionPanel("Height", 2), gridBagConstraints, 1, 2, 1, 1);
        gridBagConstraints.weightx = 0.0;
        this.addCompItem(jPanel, new JLabel("Color"), gridBagConstraints, 0, 3, 1, 1);
        this.addCompItem(jPanel, this.createScatterSelectionPanel("Color", 3), gridBagConstraints, 1, 3, 1, 1);
        this.tabbedPane = new JTabbedPane();
        Plot plot = this.window.getPlot();
        this.tabbedPane.addTab(plot.getName(), plot.getControlPanel(this.visRenderer));
        this.tabbedPane.addTab("Axes", plot.getAxes().getControlPanel(this.visRenderer));
        this.tabbedPane.addTab("ColorScale", this.window.getColorScale().getControlPanel(this.visRenderer));
        this.tabbedPane.addTab("Render", this.visRenderer.getControlPanel());
        this.tabbedPane.setMinimumSize(new Dimension(300, 250));
        this.selectedTab = Math.min(this.selectedTab, this.tabbedPane.getTabCount() - 1);
        this.tabbedPane.setSelectedIndex(this.selectedTab);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        this.addCompItem(jPanel, this.tabbedPane, gridBagConstraints, 0, 4, 2, 1);
        return jPanel;
    }

    private JPanel createTopoSettingsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.weightx = 0.0;
        this.addCompItem(jPanel, new JLabel("Minimum Visible"), gridBagConstraints, 0, 0, 1, 1);
        gridBagConstraints.weightx = 0.1;
        this.addCompItem(jPanel, this.createTopoMinRangeSelectionPanel(), gridBagConstraints, 1, 0, 1, 1);
        gridBagConstraints.weightx = 0.0;
        this.addCompItem(jPanel, new JLabel("Maximum Visible"), gridBagConstraints, 0, 1, 1, 1);
        gridBagConstraints.weightx = 0.1;
        this.addCompItem(jPanel, this.createTopoMaxRangeSelectionPanel(), gridBagConstraints, 1, 1, 1, 1);
        this.lockBox = new JCheckBox("Lock Range");
        this.addCompItem(jPanel, this.lockBox, gridBagConstraints, 0, 2, 1, 1);
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ThreeDeeControlPanel.this.lockDiff = ThreeDeeControlPanel.this.lockBox.isSelected() ? ThreeDeeControlPanel.this.maxTopoSlider.getValue() - ThreeDeeControlPanel.this.minTopoSlider.getValue() : 0;
            }
        };
        this.lockBox.addChangeListener(changeListener);
        gridBagConstraints.weightx = 0.0;
        this.selectAxisLabels[0] = new JLabel("X Axis");
        this.addCompItem(jPanel, this.selectAxisLabels[0], gridBagConstraints, 0, 3, 1, 1);
        gridBagConstraints.weightx = 0.1;
        this.addCompItem(jPanel, this.createTopoAxisSelectionPanel(0), gridBagConstraints, 1, 3, 1, 1);
        gridBagConstraints.weightx = 0.0;
        this.selectAxisLabels[1] = new JLabel("Y Axis");
        this.addCompItem(jPanel, this.selectAxisLabels[1], gridBagConstraints, 0, 4, 1, 1);
        gridBagConstraints.weightx = 0.1;
        this.addCompItem(jPanel, this.createTopoAxisSelectionPanel(1), gridBagConstraints, 1, 4, 1, 1);
        gridBagConstraints.weightx = 0.0;
        this.selectAxisLabels[2] = new JLabel("Z Axis");
        this.addCompItem(jPanel, this.selectAxisLabels[2], gridBagConstraints, 0, 5, 1, 1);
        gridBagConstraints.weightx = 0.1;
        this.addCompItem(jPanel, this.createTopoAxisSelectionPanel(2), gridBagConstraints, 1, 5, 1, 1);
        gridBagConstraints.weightx = 0.0;
        this.topoValLabel = new JLabel("Average Color Value: ");
        this.addCompItem(jPanel, this.topoValLabel, gridBagConstraints, 0, 6, 1, 2);
        gridBagConstraints.weightx = 0.1;
        this.topoValField = new JTextArea();
        this.addCompItem(jPanel, this.topoValField, gridBagConstraints, 1, 6, 1, 2);
        this.topoValField.setRows(2);
        this.topoValField.setEditable(false);
        this.topoValField.setText(this.window.getStatMean() + this.window.getSelectedThread());
        if (this.allAxesOn()) {
            this.topoValLabel.setText(CV);
        } else {
            this.topoValLabel.setText(ACV);
        }
        gridBagConstraints.weightx = 0.1;
        this.addCompItem(jPanel, this.createTopoSelectionPanel("Topology"), gridBagConstraints, 0, 8, 2, 1);
        if (this.topoComboBox.getItemCount() > this.selectedTopoDex) {
            this.topoComboBox.setSelectedIndex(this.selectedTopoDex);
        } else {
            this.topoComboBox.setSelectedIndex(0);
        }
        return jPanel;
    }

    private JPanel createTopoSelectPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.weightx = 0.1;
        this.topoSelectPanels[0] = this.createTopoIntervalSelectionPanel("event0", 0);
        this.addCompItem(jPanel, this.topoSelectPanels[0], gridBagConstraints, 0, 0, 2, 1);
        gridBagConstraints.weightx = 0.1;
        this.topoSelectPanels[1] = this.createTopoIntervalSelectionPanel("event1", 1);
        this.addCompItem(jPanel, this.topoSelectPanels[1], gridBagConstraints, 0, 1, 2, 1);
        gridBagConstraints.weightx = 0.1;
        this.topoSelectPanels[2] = this.createTopoIntervalSelectionPanel("event2", 2);
        this.addCompItem(jPanel, this.topoSelectPanels[2], gridBagConstraints, 0, 2, 2, 1);
        gridBagConstraints.weightx = 0.1;
        this.topoSelectPanels[3] = this.createTopoIntervalSelectionPanel("event3 (Color)", 3);
        this.addCompItem(jPanel, this.topoSelectPanels[3], gridBagConstraints, 0, 3, 2, 1);
        return jPanel;
    }

    private JPanel createTopoPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab("Layout", this.createTopoSettingsPanel());
        jTabbedPane.addTab("Events", this.createTopoSelectPanel());
        this.tabbedPane = new JTabbedPane();
        Plot plot = this.window.getPlot();
        this.tabbedPane.addTab(plot.getName(), plot.getControlPanel(this.visRenderer));
        this.tabbedPane.addTab("Axes", plot.getAxes().getControlPanel(this.visRenderer));
        this.tabbedPane.addTab("ColorScale", this.window.getColorScale().getControlPanel(this.visRenderer));
        this.tabbedPane.addTab("Render", this.visRenderer.getControlPanel());
        this.tabbedPane.setMinimumSize(new Dimension(300, 250));
        this.selectedTab = Math.min(this.selectedTab, this.tabbedPane.getTabCount() - 1);
        this.tabbedPane.setSelectedIndex(this.selectedTab);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        this.addCompItem(jPanel, jTabbedPane, gridBagConstraints, 0, 0, 1, 1);
        this.addCompItem(jPanel, this.tabbedPane, gridBagConstraints, 0, 1, 1, 1);
        this.maxTopoField.setText(this.window.getSelectedMaxTopoValue());
        this.minTopoField.setText(this.window.getSelectedMinTopoValue());
        this.resetTopoAxisSliders(false);
        this.switchTopoSelectPanels(this.checkDisableTopoWidgets((String)this.topoComboBox.getSelectedItem()));
        this.topoCreated = true;
        return jPanel;
    }

    private void resetTopoAxisSliders(boolean bl) {
        if (this.window.tsizes != null) {
            for (int i = 0; i < 3; ++i) {
                this.firstSet = true;
                this.selectAxisSliders[i].setMaximum(this.window.tsizes[i]);
                if (this.window.tsizes[i] < 1) {
                    this.selectAxisSliders[i].setEnabled(false);
                } else {
                    this.selectAxisSliders[i].setEnabled(true);
                }
                if (!bl) continue;
                this.selectAxisSliders[i].setValue(-1);
                this.settings.setTopoVisAxis(-1, i);
                this.selectAxisLabels[i].setText(topoLabelStrings[i]);
            }
        }
    }

    private JPanel createSelectorPanel(int n, int n2, final List<String> list, final int n3) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.settings.getSelections()[n3] = Math.min(this.settings.getSelections()[n3], n2);
        this.settings.getSelections()[n3] = Math.max(this.settings.getSelections()[n3], n);
        final JScrollBar jScrollBar = new JScrollBar(0, this.settings.getSelections()[n3], 1, n, n2);
        jScrollBar.setBlockIncrement((n2 - n) / 10);
        final JTextField jTextField = new JTextField("<none>");
        jTextField.setHorizontalAlignment(0);
        if (this.settings.getSelections()[n3] >= 0 && list != null) {
            jTextField.setText(list.get(this.settings.getSelections()[n3]));
        }
        jTextField.setEditable(false);
        jTextField.setCaretPosition(0);
        jScrollBar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                int n = jScrollBar.getValue();
                ThreeDeeControlPanel.this.settings.setSelection(n3, n);
                if (n >= 0 && list != null) {
                    jTextField.setText((String)list.get(n));
                } else {
                    jTextField.setText("<none>");
                }
                jTextField.setCaretPosition(0);
                ThreeDeeControlPanel.this.heightValueField.setText(ThreeDeeControlPanel.this.window.getSelectedHeightValue());
                ThreeDeeControlPanel.this.colorValueField.setText(ThreeDeeControlPanel.this.window.getSelectedColorValue());
                ThreeDeeControlPanel.this.scalePanel.setPosition(0, ThreeDeeControlPanel.this.window.getSelectedHeightRatio());
                ThreeDeeControlPanel.this.scalePanel.setPosition(1, ThreeDeeControlPanel.this.window.getSelectedColorRatio());
                ThreeDeeControlPanel.this.window.redraw();
            }
        });
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        Utility.addCompItem((Container)jPanel, (Component)jTextField, (GridBagConstraints)gridBagConstraints, (int)1, (int)0, (int)1, (int)1);
        Utility.addCompItem((Container)jPanel, (Component)jScrollBar, (GridBagConstraints)gridBagConstraints, (int)1, (int)1, (int)1, (int)1);
        return jPanel;
    }

    private String getScaleString(double d, Metric metric, ValueType valueType) {
        int n = this.window.getUnits();
        if (!metric.isTimeMetric() || !ValueType.isTimeUnits(valueType)) {
            n = 0;
        }
        return UtilFncs.getOutputString((int)n, (double)d, (int)6, (boolean)metric.isTimeDenominator()).trim();
    }

    private void updateScalePanel() {
        String[] stringArray = new String[2];
        String[] stringArray2 = new String[2];
        stringArray[0] = "0";
        stringArray[1] = "0";
        stringArray2[0] = this.getScaleString(this.window.getMaxHeightValue(), this.settings.getHeightMetric(), this.settings.getHeightValue());
        stringArray2[1] = this.getScaleString(this.window.getMaxColorValue(), this.settings.getColorMetric(), this.settings.getColorValue());
        String[] stringArray3 = new String[]{"height", "color"};
        String[] stringArray4 = new String[]{this.window.getHeightUnitLabel(), this.window.getColorUnitLabel()};
        this.scalePanel.setRanges(stringArray, stringArray2, stringArray3, stringArray4);
        this.scalePanel.setPosition(0, this.window.getSelectedHeightRatio());
        this.scalePanel.setPosition(1, this.window.getSelectedColorRatio());
    }

    private JPanel createScalePanel() {
        if (this.scalePanel == null) {
            this.scalePanel = ThreeDeeScalePanel.CreateScalePanel();
            this.updateScalePanel();
        }
        return this.scalePanel.getJPanel();
    }

    private JPanel createFullDataPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Plot plot = ThreeDeeControlPanel.this.window.getPlot();
                    ThreeDeeControlPanel.this.settings.setHeightMetric((Metric)ThreeDeeControlPanel.this.heightMetricBox.getSelectedItem());
                    ThreeDeeControlPanel.this.settings.setColorMetric((Metric)ThreeDeeControlPanel.this.colorMetricBox.getSelectedItem());
                    ThreeDeeControlPanel.this.settings.setHeightValue((ValueType)ThreeDeeControlPanel.this.heightValueBox.getSelectedItem());
                    ThreeDeeControlPanel.this.settings.setColorValue((ValueType)ThreeDeeControlPanel.this.colorValueBox.getSelectedItem());
                    ThreeDeeControlPanel.this.settings.setSize((int)plot.getWidth(), (int)plot.getDepth(), (int)plot.getHeight());
                    ThreeDeeControlPanel.this.settings.setRegularAim(ThreeDeeControlPanel.this.visRenderer.getAim());
                    ThreeDeeControlPanel.this.settings.setRegularEye(ThreeDeeControlPanel.this.visRenderer.getEye());
                    ThreeDeeControlPanel.this.heightValueField.setText(ThreeDeeControlPanel.this.window.getSelectedHeightValue());
                    ThreeDeeControlPanel.this.colorValueField.setText(ThreeDeeControlPanel.this.window.getSelectedColorValue());
                    ThreeDeeControlPanel.this.window.redraw();
                    ThreeDeeControlPanel.this.updateScalePanel();
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        };
        this.heightValueBox = new SteppedComboBox((Object[])ValueType.VALUES);
        Dimension dimension = this.heightValueBox.getPreferredSize();
        this.heightValueBox.setMinimumSize(new Dimension(50, this.heightValueBox.getMinimumSize().height));
        this.heightValueBox.setPopupWidth(dimension.width);
        this.heightValueBox.setSelectedItem((Object)this.settings.getHeightValue());
        this.heightValueBox.addActionListener(actionListener);
        this.colorValueBox = new SteppedComboBox((Object[])ValueType.VALUES);
        dimension = this.colorValueBox.getPreferredSize();
        this.colorValueBox.setMinimumSize(new Dimension(50, this.colorValueBox.getMinimumSize().height));
        this.colorValueBox.setPopupWidth(dimension.width);
        this.colorValueBox.setSelectedItem((Object)this.settings.getColorValue());
        this.colorValueBox.addActionListener(actionListener);
        this.heightMetricBox = new SteppedComboBox((Object[])this.ppTrial.getMetricArray());
        dimension = this.heightMetricBox.getPreferredSize();
        this.heightMetricBox.setMinimumSize(new Dimension(50, this.heightMetricBox.getMinimumSize().height));
        this.heightMetricBox.setPopupWidth(dimension.width);
        this.heightMetricBox.setSelectedItem((Object)this.settings.getHeightMetric());
        this.heightMetricBox.addActionListener(actionListener);
        this.colorMetricBox = new SteppedComboBox((Object[])this.ppTrial.getMetricArray());
        dimension = this.colorMetricBox.getPreferredSize();
        this.colorMetricBox.setMinimumSize(new Dimension(50, this.colorMetricBox.getMinimumSize().height));
        this.colorMetricBox.setPopupWidth(dimension.width);
        this.colorMetricBox.setSelectedItem((Object)this.settings.getColorMetric());
        this.colorMetricBox.addActionListener(actionListener);
        this.tabbedPane = new JTabbedPane();
        Plot plot = this.window.getPlot();
        this.tabbedPane.setTabLayoutPolicy(1);
        this.tabbedPane.addTab("Scales", this.createScalePanel());
        this.tabbedPane.addTab("Plot", plot.getControlPanel(this.visRenderer));
        this.tabbedPane.addTab("Axes", plot.getAxes().getControlPanel(this.visRenderer));
        this.tabbedPane.addTab("Color", this.window.getColorScale().getControlPanel(this.visRenderer));
        this.tabbedPane.addTab("Render", this.visRenderer.getControlPanel());
        this.tabbedPane.setMinimumSize(new Dimension(300, 200));
        this.tabbedPane.setSelectedIndex(this.selectedTab);
        JPanel jPanel2 = this.createSelectorPanel(-1, this.window.getFunctionNames().size(), this.window.getFunctionNames(), 0);
        JPanel jPanel3 = this.createSelectorPanel(0, this.ppTrial.getDataSource().getNumThreads(), this.window.getThreadNames(), 1);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(jPanel, new JLabel("Height Metric"), gridBagConstraints, 0, 0, 2, 1);
        this.addCompItem(jPanel, new JLabel("Color Metric"), gridBagConstraints, 0, 2, 2, 1);
        gridBagConstraints.weightx = 0.5;
        this.addCompItem(jPanel, (Component)this.heightValueBox, gridBagConstraints, 0, 1, 1, 1);
        this.addCompItem(jPanel, (Component)this.heightMetricBox, gridBagConstraints, 1, 1, 1, 1);
        this.addCompItem(jPanel, (Component)this.colorValueBox, gridBagConstraints, 0, 3, 1, 1);
        this.addCompItem(jPanel, (Component)this.colorMetricBox, gridBagConstraints, 1, 3, 1, 1);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        this.heightValueField.setEditable(false);
        this.colorValueField.setEditable(false);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        this.addCompItem(jPanel4, new JLabel("Function"), gridBagConstraints, 0, 0, 1, 1);
        this.addCompItem(jPanel4, new JLabel("Thread"), gridBagConstraints, 0, 1, 1, 1);
        this.addCompItem(jPanel4, new JLabel("Height value"), gridBagConstraints, 0, 2, 1, 1);
        this.addCompItem(jPanel4, new JLabel("Color value"), gridBagConstraints, 0, 3, 1, 1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.addCompItem(jPanel4, jPanel2, gridBagConstraints, 1, 0, 1, 1);
        this.addCompItem(jPanel4, jPanel3, gridBagConstraints, 1, 1, 1, 1);
        this.addCompItem(jPanel4, this.heightValueField, gridBagConstraints, 1, 2, 1, 1);
        this.addCompItem(jPanel4, this.colorValueField, gridBagConstraints, 1, 3, 1, 1);
        this.addCompItem(jPanel, jPanel4, gridBagConstraints, 0, 4, 2, 1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        this.addCompItem(jPanel, this.tabbedPane, gridBagConstraints, 0, 5, 2, 1);
        return jPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JRadioButton) {
                this.selectedTab = this.tabbedPane.getSelectedIndex();
                this.selectedTab = 0;
                String string = actionEvent.getActionCommand();
                Plot plot = this.window.getPlot();
                if (this.settings.getVisType() == VisType.BAR_PLOT || this.settings.getVisType() == VisType.TRIANGLE_MESH_PLOT) {
                    this.settings.setSize((int)plot.getWidth(), (int)plot.getDepth(), (int)plot.getHeight());
                    this.settings.setRegularAim(this.visRenderer.getAim());
                    this.settings.setRegularEye(this.visRenderer.getEye());
                } else if (this.settings.getVisType() == VisType.SCATTER_PLOT || this.settings.getVisType() == VisType.TOPO_PLOT) {
                    this.settings.setScatterAim(this.visRenderer.getAim());
                    this.settings.setScatterEye(this.visRenderer.getEye());
                }
                if (string.equals(VisType.BAR_PLOT.toString())) {
                    this.settings.setVisType(VisType.BAR_PLOT);
                } else if (string.equals(VisType.TRIANGLE_MESH_PLOT.toString())) {
                    this.settings.setVisType(VisType.TRIANGLE_MESH_PLOT);
                } else if (string.equals(VisType.SCATTER_PLOT.toString())) {
                    this.settings.setVisType(VisType.SCATTER_PLOT);
                } else if (string.equals(VisType.CALLGRAPH.toString())) {
                    this.settings.setVisType(VisType.CALLGRAPH);
                } else if (string.equals(VisType.TOPO_PLOT.toString())) {
                    this.settings.setVisType(VisType.TOPO_PLOT);
                }
                this.window.resetSplitPane();
                this.createSubPanel();
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void dataChanged() {
        this.window.redraw();
        this.updateScalePanel();
        this.createSubPanel();
        this.heightValueField.setText(this.window.getSelectedHeightValue());
        this.colorValueField.setText(this.window.getSelectedColorValue());
        if (this.topoCreated) {
            this.minTopoField.setText(this.window.getSelectedMinTopoValue());
            this.maxTopoField.setText(this.window.getSelectedMaxTopoValue());
            this.topoValField.setText(this.window.getStatMean() + this.window.getSelectedThread());
            if (this.allAxesOn()) {
                this.topoValLabel.setText(CV);
            } else {
                this.topoValLabel.setText(ACV);
            }
        }
    }

    private boolean allAxesOn() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.selectAxisSliders.length; ++i) {
            if (!this.selectAxisSliders[i].isEnabled()) {
                ++n;
            }
            if (this.selectAxisSliders[i].getValue() <= -1) continue;
            ++n2;
        }
        if (n == this.selectAxisSliders.length) {
            return true;
        }
        if (n2 == 0) {
            return false;
        }
        return this.selectAxisSliders.length - n == n2;
    }

    private void addCompItem(JPanel jPanel, Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        jPanel.add(component, gridBagConstraints);
    }

    public class SliderComboBox
    extends JComboBox {
        private static final long serialVersionUID = -7178282357180311147L;

        public SliderComboBox() {
            this.setUI(new SliderComboUI());
        }

        public SliderComboBox(Object[] objectArray) {
            super(objectArray);
            this.setUI(new SliderComboUI());
        }

        public class SliderComboUI
        extends MetalComboBoxUI {
            protected ComboPopup createPopup() {
                BasicComboPopup basicComboPopup = new BasicComboPopup(this.comboBox){
                    private static final long serialVersionUID = -2126557896237148500L;

                    protected JScrollPane createScroller() {
                        return new JScrollPane(this.list, 20, 30);
                    }
                };
                return basicComboPopup;
            }
        }
    }
}

