/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.tablemodel;

import edu.uoregon.tau.paraprof.ParaProfManagerWindow;
import edu.uoregon.tau.paraprof.ParaProfView;
import edu.uoregon.tau.perfdmf.DatabaseAPI;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultTreeModel;

public class ViewTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 7691740386199068018L;
    private ParaProfView view;
    private String[] columnNames = new String[]{"View Field", "Value"};
    private ParaProfManagerWindow paraProfManager;
    private DefaultTreeModel defaultTreeModel;
    private List<String> fieldNames;

    public ViewTableModel(ParaProfManagerWindow paraProfManagerWindow, ParaProfView paraProfView, DefaultTreeModel defaultTreeModel) {
        this.view = paraProfView;
        this.paraProfManager = paraProfManagerWindow;
        this.defaultTreeModel = defaultTreeModel;
        this.fieldNames = new ArrayList<String>();
        for (int i = 0; i < this.view.getNumFields(); ++i) {
            this.fieldNames.add(ParaProfView.getFieldName((int)i));
        }
    }

    public void updateDatabaseFields(ParaProfView paraProfView) {
        if (paraProfView != null) {
            int n;
            this.fieldNames = new ArrayList<String>();
            for (n = 0; n < this.view.getNumFields(); ++n) {
                this.fieldNames.add(ParaProfView.getFieldName((int)n));
            }
            for (n = 0; n < paraProfView.getNumFields(); ++n) {
                this.fieldNames.add(ParaProfView.getFieldName((int)n));
            }
        }
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public int getRowCount() {
        return this.fieldNames.size();
    }

    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return this.fieldNames.get(n);
        }
        return this.view.getField(n);
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 == 1 && n != 1 && n != 2;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        if (!(object instanceof String)) {
            return;
        }
        String string = (String)object;
        this.view.setField(n, string);
        this.updateDB();
        this.defaultTreeModel.nodeChanged(this.view.getDMTN());
    }

    private void updateDB() {
        DatabaseAPI databaseAPI = this.paraProfManager.getDatabaseAPI(this.view.getDatabase());
        if (databaseAPI != null) {
            try {
                this.view.saveView(databaseAPI.db());
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            databaseAPI.terminate();
        }
    }
}

