/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyBaseString;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyComplex;
import org.python.core.PyDataDescr;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode$exposed___new__;
import org.python.core.PyUnicode$unicode___cmp___exposer;
import org.python.core.PyUnicode$unicode___contains___exposer;
import org.python.core.PyUnicode$unicode___getslice___exposer;
import org.python.core.PyUnicode$unicode___rmul___exposer;
import org.python.core.PyUnicode$unicode_expandtabs_exposer;
import org.python.core.PyUnicode$unicode_find_exposer;
import org.python.core.PyUnicode$unicode_isdecimal_exposer;
import org.python.core.PyUnicode$unicode_isnumeric_exposer;
import org.python.core.PyUnicode$unicode_lower_exposer;
import org.python.core.PyUnicode$unicode_rjust_exposer;
import org.python.core.PyUnicode$unicode_startswith_exposer;
import org.python.core.PyUnicode$unicode_swapcase_exposer;
import org.python.core.PyUnicodeDerived;
import org.python.core.StringFormatter;
import org.python.core.codecs;
import org.python.expose.BaseTypeBuilder;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.modules._codecs;
import org.python.util.Generic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExposedType(name="unicode", base=PyBaseString.class)
public class PyUnicode
extends PyString
implements Iterable {
    private volatile Plane plane = Plane.UNKNOWN;
    private volatile int codePointCount = -1;
    public static final PyType TYPE;

    public PyUnicode() {
        this(TYPE, "");
    }

    public PyUnicode(String string) {
        this(TYPE, string);
    }

    public PyUnicode(String string, boolean isBasic) {
        this(TYPE, string);
        this.plane = isBasic ? Plane.BASIC : Plane.UNKNOWN;
    }

    public PyUnicode(PyType subtype, String string) {
        super(subtype, string);
    }

    public PyUnicode(PyString pystring) {
        this(TYPE, pystring);
    }

    public PyUnicode(PyType subtype, PyString pystring) {
        this(subtype, pystring instanceof PyUnicode ? pystring.string : pystring.decode().toString());
    }

    public PyUnicode(char c) {
        this(TYPE, String.valueOf(c));
    }

    public PyUnicode(int codepoint) {
        this(TYPE, new String(new int[]{codepoint}, 0, 1));
    }

    public PyUnicode(int[] codepoints) {
        this(new String(codepoints, 0, codepoints.length));
    }

    PyUnicode(StringBuilder buffer) {
        this(TYPE, new String(buffer));
    }

    private static StringBuilder fromCodePoints(Iterator<Integer> iter) {
        StringBuilder buffer = new StringBuilder();
        while (iter.hasNext()) {
            buffer.appendCodePoint(iter.next());
        }
        return buffer;
    }

    public PyUnicode(Iterator<Integer> iter) {
        this(PyUnicode.fromCodePoints(iter));
    }

    public PyUnicode(Collection<Integer> ucs4) {
        this(ucs4.iterator());
    }

    @Override
    public int[] toCodePoints() {
        int n = this.getCodePointCount();
        int[] codePoints = new int[n];
        int i = 0;
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            codePoints[i] = iter.next();
            ++i;
        }
        return codePoints;
    }

    @Override
    public String substring(int start, int end) {
        if (this.isBasicPlane()) {
            return super.substring(start, end);
        }
        return new PyUnicode(this.newSubsequenceIterator((int)start, (int)end, (int)1)).string;
    }

    public static PyUnicode fromInterned(String interned) {
        PyUnicode uni = new PyUnicode(TYPE, interned);
        uni.interned = true;
        return uni;
    }

    public boolean isBasicPlane() {
        if (this.plane == Plane.BASIC) {
            return true;
        }
        if (this.plane == Plane.UNKNOWN) {
            this.plane = this.string.length() == this.getCodePointCount() ? Plane.BASIC : Plane.ASTRAL;
        }
        return this.plane == Plane.BASIC;
    }

    public int getCodePointCount() {
        if (this.codePointCount >= 0) {
            return this.codePointCount;
        }
        this.codePointCount = this.string.codePointCount(0, this.string.length());
        return this.codePointCount;
    }

    @ExposedNew
    static final PyObject unicode_new(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        ArgParser ap = new ArgParser("unicode", args, keywords, new String[]{"string", "encoding", "errors"}, 0);
        PyObject S = ap.getPyObject(0, null);
        String encoding = ap.getString(1, null);
        String errors = ap.getString(2, null);
        if (new_.for_type == subtype) {
            if (S == null) {
                return new PyUnicode("");
            }
            if (S instanceof PyUnicode) {
                return new PyUnicode(((PyUnicode)S).string);
            }
            if (S instanceof PyString) {
                if (S.getType() != PyString.TYPE && encoding == null && errors == null) {
                    return S.__unicode__();
                }
                PyObject decoded = codecs.decode((PyString)S, encoding, errors);
                if (decoded instanceof PyUnicode) {
                    return new PyUnicode((PyUnicode)decoded);
                }
                throw Py.TypeError("decoder did not return an unicode object (type=" + decoded.getType().fastGetName() + ")");
            }
            return S.__unicode__();
        }
        if (S == null) {
            return new PyUnicodeDerived(subtype, Py.EmptyString);
        }
        if (S instanceof PyUnicode) {
            return new PyUnicodeDerived(subtype, (PyUnicode)S);
        }
        return new PyUnicodeDerived(subtype, S.__str__());
    }

    @Override
    public PyString createInstance(String str) {
        return new PyUnicode(str);
    }

    @Override
    protected PyString createInstance(String str, boolean isBasic) {
        return new PyUnicode(str, isBasic);
    }

    @Override
    public PyObject __mod__(PyObject other) {
        return this.unicode___mod__(other);
    }

    final PyObject unicode___mod__(PyObject other) {
        StringFormatter fmt = new StringFormatter(this.string, true);
        return fmt.format(other);
    }

    @Override
    public PyUnicode __unicode__() {
        return this;
    }

    @Override
    public PyString __str__() {
        return this.unicode___str__();
    }

    final PyString unicode___str__() {
        return new PyString(this.encode());
    }

    @Override
    public int __len__() {
        return this.unicode___len__();
    }

    final int unicode___len__() {
        return this.getCodePointCount();
    }

    @Override
    public PyString __repr__() {
        return this.unicode___repr__();
    }

    final PyString unicode___repr__() {
        return new PyString("u" + PyUnicode.encode_UnicodeEscape(this.string, true));
    }

    final PyObject unicode___getitem__(PyObject index) {
        return this.str___getitem__(index);
    }

    final PyObject unicode___getslice__(PyObject start, PyObject stop, PyObject step) {
        return this.seq___getslice__(start, stop, step);
    }

    @Override
    protected PyObject getslice(int start, int stop, int step) {
        if (this.isBasicPlane()) {
            return super.getslice(start, stop, step);
        }
        if (step > 0 && stop < start) {
            stop = start;
        }
        StringBuilder buffer = new StringBuilder(PyUnicode.sliceLength(start, stop, step));
        Iterator<Integer> iter = this.newSubsequenceIterator(start, stop, step);
        while (iter.hasNext()) {
            buffer.appendCodePoint(iter.next());
        }
        return this.createInstance(new String(buffer));
    }

    final int unicode___cmp__(PyObject other) {
        return this.str___cmp__(other);
    }

    final PyObject unicode___eq__(PyObject other) {
        return this.str___eq__(other);
    }

    final PyObject unicode___ne__(PyObject other) {
        return this.str___ne__(other);
    }

    final int unicode___hash__() {
        return this.str___hash__();
    }

    @Override
    protected PyObject pyget(int i) {
        if (this.isBasicPlane()) {
            return Py.makeCharacter(this.string.charAt(i), true);
        }
        int k = 0;
        while (i > 0) {
            char W1 = this.string.charAt(k);
            k = W1 >= '\ud800' && W1 < '\udc00' ? (k += 2) : ++k;
            --i;
        }
        int codepoint = this.string.codePointAt(k);
        return Py.makeCharacter(codepoint, true);
    }

    public Iterator<Integer> newSubsequenceIterator() {
        return new SubsequenceIteratorImpl();
    }

    public Iterator<Integer> newSubsequenceIterator(int start, int stop, int step) {
        if (step < 0) {
            return new SteppedIterator(step * -1, new ReversedIterator(new SubsequenceIteratorImpl(stop + 1, start + 1, 1)));
        }
        return new SubsequenceIteratorImpl(start, stop, step);
    }

    private PyUnicode coerceToUnicode(PyObject o) {
        if (o == null) {
            return null;
        }
        if (o instanceof PyUnicode) {
            return (PyUnicode)o;
        }
        if (o instanceof PyString) {
            return new PyUnicode(o.toString());
        }
        if (o == Py.None) {
            return null;
        }
        throw Py.TypeError("coercing to Unicode: need string or buffer, " + o.getType().fastGetName() + "found");
    }

    final boolean unicode___contains__(PyObject o) {
        return this.str___contains__(o);
    }

    final PyObject unicode___mul__(PyObject o) {
        return this.str___mul__(o);
    }

    final PyObject unicode___rmul__(PyObject o) {
        return this.str___rmul__(o);
    }

    @Override
    public PyObject __add__(PyObject other) {
        return this.unicode___add__(other);
    }

    final PyObject unicode___add__(PyObject other) {
        PyUnicode otherUnicode;
        if (other instanceof PyUnicode) {
            otherUnicode = (PyUnicode)other;
        } else if (other instanceof PyString) {
            otherUnicode = (PyUnicode)((PyString)other).decode();
        } else {
            return null;
        }
        return new PyUnicode(this.string.concat(otherUnicode.string));
    }

    final PyObject unicode_lower() {
        return new PyUnicode(this.str_lower());
    }

    final PyObject unicode_upper() {
        return new PyUnicode(this.str_upper());
    }

    final PyObject unicode_title() {
        if (this.isBasicPlane()) {
            return new PyUnicode(this.str_title());
        }
        StringBuilder buffer = new StringBuilder(this.string.length());
        boolean previous_is_cased = false;
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            int codePoint = iter.next();
            if (previous_is_cased) {
                buffer.appendCodePoint(Character.toLowerCase(codePoint));
            } else {
                buffer.appendCodePoint(Character.toTitleCase(codePoint));
            }
            if (Character.isLowerCase(codePoint) || Character.isUpperCase(codePoint) || Character.isTitleCase(codePoint)) {
                previous_is_cased = true;
                continue;
            }
            previous_is_cased = false;
        }
        return new PyUnicode(buffer);
    }

    final PyObject unicode_swapcase() {
        if (this.isBasicPlane()) {
            return new PyUnicode(this.str_swapcase());
        }
        StringBuilder buffer = new StringBuilder(this.string.length());
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            int codePoint = iter.next();
            if (Character.isUpperCase(codePoint)) {
                buffer.appendCodePoint(Character.toLowerCase(codePoint));
                continue;
            }
            if (Character.isLowerCase(codePoint)) {
                buffer.appendCodePoint(Character.toUpperCase(codePoint));
                continue;
            }
            buffer.appendCodePoint(codePoint);
        }
        return new PyUnicode(buffer);
    }

    private PyUnicode coerceStripSepToUnicode(PyObject o) {
        if (o == null) {
            return null;
        }
        if (o instanceof PyUnicode) {
            return (PyUnicode)o;
        }
        if (o instanceof PyString) {
            return new PyUnicode(((PyString)o).decode().toString());
        }
        if (o == Py.None) {
            return null;
        }
        throw Py.TypeError("strip arg must be None, unicode or str");
    }

    final PyObject unicode_strip(PyObject sepObj) {
        PyUnicode sep = this.coerceStripSepToUnicode(sepObj);
        if (this.isBasicPlane() && (sep == null || sep.isBasicPlane())) {
            if (sep == null) {
                return new PyUnicode(this.str_strip(null));
            }
            return new PyUnicode(this.str_strip(sep.string));
        }
        return new PyUnicode(new ReversedIterator(new StripIterator(sep, new ReversedIterator(new StripIterator(sep, this.newSubsequenceIterator())))));
    }

    final PyObject unicode_lstrip(PyObject sepObj) {
        PyUnicode sep = this.coerceStripSepToUnicode(sepObj);
        if (this.isBasicPlane() && (sep == null || sep.isBasicPlane())) {
            if (sep == null) {
                return new PyUnicode(this.str_lstrip(null));
            }
            return new PyUnicode(this.str_lstrip(sep.string));
        }
        return new PyUnicode(new StripIterator(sep, this.newSubsequenceIterator()));
    }

    final PyObject unicode_rstrip(PyObject sepObj) {
        PyUnicode sep = this.coerceStripSepToUnicode(sepObj);
        if (this.isBasicPlane() && (sep == null || sep.isBasicPlane())) {
            if (sep == null) {
                return new PyUnicode(this.str_rstrip(null));
            }
            return new PyUnicode(this.str_rstrip(sep.string));
        }
        return new PyUnicode(new ReversedIterator(new StripIterator(sep, new ReversedIterator<Integer>(this.newSubsequenceIterator()))));
    }

    @Override
    public PyTuple partition(PyObject sep) {
        return this.unicode_partition(sep);
    }

    final PyTuple unicode_partition(PyObject sep) {
        return this.unicodePartition(sep);
    }

    private SplitIterator newSplitIterator(PyUnicode sep, int maxsplit) {
        if (sep == null) {
            return new WhitespaceSplitIterator(maxsplit);
        }
        if (sep.getCodePointCount() == 0) {
            throw Py.ValueError("empty separator");
        }
        return new SepSplitIterator(sep, maxsplit);
    }

    @Override
    public PyTuple rpartition(PyObject sep) {
        return this.unicode_rpartition(sep);
    }

    final PyTuple unicode_rpartition(PyObject sep) {
        return this.unicodeRpartition(sep);
    }

    final PyList unicode_split(PyObject sepObj, int maxsplit) {
        PyUnicode sep = this.coerceToUnicode(sepObj);
        if (sep != null) {
            return this.str_split(sep.string, maxsplit);
        }
        return this.str_split(null, maxsplit);
    }

    final PyList unicode_rsplit(PyObject sepObj, int maxsplit) {
        PyUnicode sep = this.coerceToUnicode(sepObj);
        if (sep != null) {
            return this.str_rsplit(sep.string, maxsplit);
        }
        return this.str_rsplit(null, maxsplit);
    }

    final PyList unicode_splitlines(boolean keepends) {
        if (this.isBasicPlane()) {
            return this.str_splitlines(keepends);
        }
        return new PyList(new LineSplitIterator(keepends));
    }

    @Override
    protected PyString fromSubstring(int begin, int end) {
        assert (this.isBasicPlane());
        return new PyUnicode(this.string.substring(begin, end));
    }

    final int unicode_index(String sub, int start, PyObject end) {
        return this.str_index(sub, start, end);
    }

    final int unicode_rindex(String sub, int start, PyObject end) {
        return this.str_rindex(sub, start, end);
    }

    final int unicode_count(PyObject subObj, int start, PyObject end) {
        PyUnicode sub = this.coerceToUnicode(subObj);
        if (this.isBasicPlane()) {
            return this.str_count(sub.string, start, end);
        }
        int[] indices = this.translateIndices(start, end);
        int count = 0;
        Iterator<Integer> mainIter = this.newSubsequenceIterator(indices[0], indices[1], 1);
        while (mainIter.hasNext()) {
            int matched = sub.getCodePointCount();
            Iterator<Integer> subIter = sub.newSubsequenceIterator();
            while (mainIter.hasNext() && subIter.hasNext() && mainIter.next() == subIter.next()) {
                --matched;
            }
            if (matched != 0) continue;
            ++count;
        }
        return count;
    }

    final int unicode_find(String sub, int start, PyObject end) {
        return this.str_find(sub, start, end);
    }

    final int unicode_rfind(String sub, int start, PyObject end) {
        return this.str_rfind(sub, start, end);
    }

    private static String padding(int n, int pad) {
        StringBuilder buffer = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            buffer.appendCodePoint(pad);
        }
        return buffer.toString();
    }

    private static int parse_fillchar(String function, String fillchar) {
        if (fillchar == null) {
            return 32;
        }
        if (fillchar.codePointCount(0, fillchar.length()) != 1) {
            throw Py.TypeError(function + "() argument 2 must be char, not str");
        }
        return fillchar.codePointAt(0);
    }

    final PyObject unicode_ljust(int width, String padding) {
        int n = width - this.getCodePointCount();
        if (n <= 0) {
            return new PyUnicode(this.string);
        }
        return new PyUnicode(this.string + PyUnicode.padding(n, PyUnicode.parse_fillchar("ljust", padding)));
    }

    final PyObject unicode_rjust(int width, String padding) {
        int n = width - this.getCodePointCount();
        if (n <= 0) {
            return new PyUnicode(this.string);
        }
        return new PyUnicode(PyUnicode.padding(n, PyUnicode.parse_fillchar("ljust", padding)) + this.string);
    }

    final PyObject unicode_center(int width, String padding) {
        int n = width - this.getCodePointCount();
        if (n <= 0) {
            return new PyUnicode(this.string);
        }
        int half = n / 2;
        if (n % 2 > 0 && width % 2 > 0) {
            ++half;
        }
        int pad = PyUnicode.parse_fillchar("center", padding);
        return new PyUnicode(PyUnicode.padding(half, pad) + this.string + PyUnicode.padding(n - half, pad));
    }

    final PyObject unicode_zfill(int width) {
        int n = this.getCodePointCount();
        if (n >= width) {
            return new PyUnicode(this.string);
        }
        if (this.isBasicPlane()) {
            return new PyUnicode(this.str_zfill(width));
        }
        StringBuilder buffer = new StringBuilder(width);
        int nzeros = width - n;
        boolean first = true;
        boolean leadingSign = false;
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            int codePoint = iter.next();
            if (first) {
                first = false;
                if (codePoint == 43 || codePoint == 45) {
                    buffer.appendCodePoint(codePoint);
                    leadingSign = true;
                }
                for (int i = 0; i < nzeros; ++i) {
                    buffer.appendCodePoint(48);
                }
                if (leadingSign) continue;
                buffer.appendCodePoint(codePoint);
                continue;
            }
            buffer.appendCodePoint(codePoint);
        }
        if (first) {
            for (int i = 0; i < nzeros; ++i) {
                buffer.appendCodePoint(48);
            }
        }
        return new PyUnicode(buffer);
    }

    final PyObject unicode_expandtabs(int tabsize) {
        return new PyUnicode(this.str_expandtabs(tabsize));
    }

    final PyObject unicode_capitalize() {
        if (this.string.length() == 0) {
            return this;
        }
        if (this.isBasicPlane()) {
            return new PyUnicode(this.str_capitalize());
        }
        StringBuilder buffer = new StringBuilder(this.string.length());
        boolean first = true;
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            if (first) {
                buffer.appendCodePoint(Character.toUpperCase(iter.next()));
                first = false;
                continue;
            }
            buffer.appendCodePoint(Character.toLowerCase(iter.next()));
        }
        return new PyUnicode(buffer);
    }

    final PyObject unicode_replace(PyObject oldPieceObj, PyObject newPieceObj, int maxsplit) {
        PyUnicode newPiece = this.coerceToUnicode(newPieceObj);
        PyUnicode oldPiece = this.coerceToUnicode(oldPieceObj);
        if (this.isBasicPlane() && newPiece.isBasicPlane() && oldPiece.isBasicPlane()) {
            return this.replace(oldPiece, newPiece, maxsplit);
        }
        StringBuilder buffer = new StringBuilder();
        if (oldPiece.getCodePointCount() == 0) {
            Iterator<Integer> iter = this.newSubsequenceIterator();
            for (int i = 1; (maxsplit == -1 || i < maxsplit) && iter.hasNext(); ++i) {
                if (i == 1) {
                    buffer.append(newPiece.string);
                }
                buffer.appendCodePoint(iter.next());
                buffer.append(newPiece.string);
            }
            while (iter.hasNext()) {
                buffer.appendCodePoint(iter.next());
            }
            return new PyUnicode(buffer);
        }
        SplitIterator iter = this.newSplitIterator(oldPiece, maxsplit);
        int numSplits = 0;
        while (iter.hasNext()) {
            buffer.append(((PyUnicode)iter.next()).string);
            if (iter.hasNext()) {
                buffer.append(newPiece.string);
            }
            ++numSplits;
        }
        if (iter.getEndsWithSeparator() && (maxsplit == -1 || numSplits <= maxsplit)) {
            buffer.append(newPiece.string);
        }
        return new PyUnicode(buffer);
    }

    @Override
    public PyString join(PyObject seq) {
        return this.unicode_join(seq);
    }

    final PyUnicode unicode_join(PyObject seq) {
        return this.unicodeJoin(seq);
    }

    final boolean unicode_startswith(PyObject prefix, int start, PyObject end) {
        return this.str_startswith(prefix, start, end);
    }

    final boolean unicode_endswith(PyObject suffix, int start, PyObject end) {
        return this.str_endswith(suffix, start, end);
    }

    final PyObject unicode_translate(PyObject table) {
        String trans = _codecs.translate_charmap(this.string, "ignore", table, true).__getitem__(0).toString();
        return new PyUnicode(trans);
    }

    final boolean unicode_islower() {
        if (this.isBasicPlane()) {
            return this.str_islower();
        }
        boolean cased = false;
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            int codepoint = iter.next();
            if (Character.isUpperCase(codepoint) || Character.isTitleCase(codepoint)) {
                return false;
            }
            if (cased || !Character.isLowerCase(codepoint)) continue;
            cased = true;
        }
        return cased;
    }

    final boolean unicode_isupper() {
        if (this.isBasicPlane()) {
            return this.str_isupper();
        }
        boolean cased = false;
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            int codepoint = iter.next();
            if (Character.isLowerCase(codepoint) || Character.isTitleCase(codepoint)) {
                return false;
            }
            if (cased || !Character.isUpperCase(codepoint)) continue;
            cased = true;
        }
        return cased;
    }

    final boolean unicode_isalpha() {
        if (this.isBasicPlane()) {
            return this.str_isalpha();
        }
        if (this.getCodePointCount() == 0) {
            return false;
        }
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            if (Character.isLetter(iter.next())) continue;
            return false;
        }
        return true;
    }

    final boolean unicode_isalnum() {
        if (this.isBasicPlane()) {
            return this.str_isalnum();
        }
        if (this.getCodePointCount() == 0) {
            return false;
        }
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            int codePoint = iter.next();
            if (Character.isLetterOrDigit(codePoint) || Character.getType(codePoint) == 10) continue;
            return false;
        }
        return true;
    }

    final boolean unicode_isdecimal() {
        if (this.isBasicPlane()) {
            return this.str_isdecimal();
        }
        if (this.getCodePointCount() == 0) {
            return false;
        }
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            if (Character.getType(iter.next()) == 9) continue;
            return false;
        }
        return true;
    }

    final boolean unicode_isdigit() {
        if (this.isBasicPlane()) {
            return this.str_isdigit();
        }
        if (this.getCodePointCount() == 0) {
            return false;
        }
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            if (Character.isDigit(iter.next())) continue;
            return false;
        }
        return true;
    }

    final boolean unicode_isnumeric() {
        if (this.isBasicPlane()) {
            return this.str_isnumeric();
        }
        if (this.getCodePointCount() == 0) {
            return false;
        }
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            int type = Character.getType(iter.next());
            if (type == 9 || type == 10 || type == 11) continue;
            return false;
        }
        return true;
    }

    final boolean unicode_istitle() {
        if (this.isBasicPlane()) {
            return this.str_istitle();
        }
        if (this.getCodePointCount() == 0) {
            return false;
        }
        boolean cased = false;
        boolean previous_is_cased = false;
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            int codePoint = iter.next();
            if (Character.isUpperCase(codePoint) || Character.isTitleCase(codePoint)) {
                if (previous_is_cased) {
                    return false;
                }
                previous_is_cased = true;
                cased = true;
                continue;
            }
            if (Character.isLowerCase(codePoint)) {
                if (!previous_is_cased) {
                    return false;
                }
                previous_is_cased = true;
                cased = true;
                continue;
            }
            previous_is_cased = false;
        }
        return cased;
    }

    final boolean unicode_isspace() {
        if (this.isBasicPlane()) {
            return this.str_isspace();
        }
        if (this.getCodePointCount() == 0) {
            return false;
        }
        Iterator<Integer> iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            if (Character.isWhitespace(iter.next())) continue;
            return false;
        }
        return true;
    }

    final boolean unicode_isunicode() {
        Py.warning(Py.DeprecationWarning, "isunicode is deprecated.");
        return true;
    }

    final String unicode_encode(String encoding, String errors) {
        return this.str_encode(encoding, errors);
    }

    final PyObject unicode_decode(String encoding, String errors) {
        return this.str_decode(encoding, errors);
    }

    final PyTuple unicode___getnewargs__() {
        return new PyTuple(new PyUnicode(this.string));
    }

    public Iterator<Integer> iterator() {
        return this.newSubsequenceIterator();
    }

    @Override
    public PyComplex __complex__() {
        return new PyString(this.encodeDecimal()).__complex__();
    }

    @Override
    public int atoi(int base) {
        return new PyString(this.encodeDecimal()).atoi(base);
    }

    @Override
    public PyLong atol(int base) {
        return new PyString(this.encodeDecimal()).atol(base);
    }

    @Override
    public double atof() {
        return new PyString(this.encodeDecimal()).atof();
    }

    /*
     * WARNING - void declaration
     */
    private String encodeDecimal() {
        if (this.isBasicPlane()) {
            return this.encodeDecimalBasic();
        }
        StringBuilder stringBuilder = new StringBuilder();
        int sb = 0;
        Iterator<Integer> i = this.newSubsequenceIterator();
        while (i.hasNext()) {
            int iter = i.next();
            if (Character.isWhitespace(iter)) {
                stringBuilder.append(' ');
            } else {
                void digit;
                int codePoint = Character.digit(iter, 10);
                if (codePoint >= 0) {
                    digit.append(codePoint);
                } else if (0 < iter && iter < 256) {
                    digit.appendCodePoint(iter);
                } else {
                    codecs.encoding_error("strict", "decimal", this.string, sb, sb + 1, "invalid decimal Unicode string");
                }
            }
            ++sb;
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    private String encodeDecimalBasic() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int sb = 0; sb < this.string.length(); ++sb) {
            void digit;
            char i = this.string.charAt(sb);
            if (Character.isWhitespace(i)) {
                stringBuilder.append(' ');
                continue;
            }
            int ch = Character.digit(i, 10);
            if (ch >= 0) {
                digit.append(ch);
                continue;
            }
            if ('\u0000' < i && i < '\u0100') {
                digit.append(i);
                continue;
            }
            codecs.encoding_error("strict", "decimal", this.string, sb, sb + 1, "invalid decimal Unicode string");
        }
        return stringBuilder.toString();
    }

    static {
        PyType.addBuilder(PyUnicode.class, new PyUnicode$PyExposer());
        TYPE = PyType.fromClass(PyUnicode.class);
    }

    private class SepSplitIterator
    extends SplitIterator {
        private final PyUnicode sep;

        SepSplitIterator(PyUnicode sep, int maxsplit) {
            super(maxsplit);
            this.sep = sep;
        }

        public PyUnicode next() {
            StringBuilder buffer = new StringBuilder();
            this.addLookahead(buffer);
            if (this.numSplits == this.maxsplit) {
                while (this.iter.hasNext()) {
                    buffer.appendCodePoint((Integer)this.iter.next());
                }
                return new PyUnicode(buffer);
            }
            boolean inSeparator = true;
            while (this.iter.hasNext()) {
                inSeparator = true;
                Iterator<Integer> sepIter = this.sep.newSubsequenceIterator();
                while (sepIter.hasNext()) {
                    int codepoint = (Integer)this.iter.next();
                    if (codepoint != sepIter.next()) {
                        this.addLookahead(buffer);
                        buffer.appendCodePoint(codepoint);
                        inSeparator = false;
                        break;
                    }
                    this.lookahead.add(codepoint);
                }
                if (!inSeparator) continue;
                this.lookahead.clear();
                break;
            }
            ++this.numSplits;
            this.completeSeparator = inSeparator;
            return new PyUnicode(buffer);
        }
    }

    private class LineSplitIterator
    implements Iterator {
        private final PeekIterator<Integer> iter;
        private final boolean keepends;

        LineSplitIterator(boolean keepends) {
            this.iter = new PeekIterator<Integer>(PyUnicode.this.newSubsequenceIterator());
            this.keepends = keepends;
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            StringBuilder buffer = new StringBuilder();
            while (this.iter.hasNext()) {
                int codepoint = this.iter.next();
                if (codepoint == 13 && this.iter.peek() != null && this.iter.peek() == 10) {
                    if (this.keepends) {
                        buffer.appendCodePoint(codepoint);
                        buffer.appendCodePoint(this.iter.next());
                        break;
                    }
                    this.iter.next();
                    break;
                }
                if (codepoint == 10 || codepoint == 13 || Character.getType(codepoint) == 13) {
                    if (!this.keepends) break;
                    buffer.appendCodePoint(codepoint);
                    break;
                }
                buffer.appendCodePoint(codepoint);
            }
            return new PyUnicode(buffer);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReversedIterator<T>
    implements Iterator {
        private final List<T> reversed = Generic.list();
        private final Iterator<T> iter;

        ReversedIterator(Iterator<T> iter) {
            while (iter.hasNext()) {
                this.reversed.add(iter.next());
            }
            Collections.reverse(this.reversed);
            this.iter = this.reversed.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public T next() {
            return this.iter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PeekIterator<T>
    implements Iterator {
        private T lookahead = null;
        private final Iterator<T> iter;

        public PeekIterator(Iterator<T> iter) {
            this.iter = iter;
            this.next();
        }

        public T peek() {
            return this.lookahead;
        }

        @Override
        public boolean hasNext() {
            return this.lookahead != null;
        }

        public T next() {
            T peeked = this.lookahead;
            this.lookahead = this.iter.hasNext() ? this.iter.next() : null;
            return peeked;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class WhitespaceSplitIterator
    extends SplitIterator {
        WhitespaceSplitIterator(int maxsplit) {
            super(maxsplit);
        }

        public PyUnicode next() {
            boolean atBeginning;
            StringBuilder buffer = new StringBuilder();
            this.addLookahead(buffer);
            if (this.numSplits == this.maxsplit) {
                while (this.iter.hasNext()) {
                    buffer.appendCodePoint((Integer)this.iter.next());
                }
                return new PyUnicode(buffer);
            }
            boolean inSeparator = false;
            boolean bl = atBeginning = this.numSplits == 0;
            while (this.iter.hasNext()) {
                int codepoint = (Integer)this.iter.next();
                if (Character.isWhitespace(codepoint)) {
                    this.completeSeparator = true;
                    if (!atBeginning) {
                        inSeparator = true;
                    }
                } else if (!inSeparator) {
                    this.completeSeparator = false;
                    buffer.appendCodePoint(codepoint);
                } else {
                    this.completeSeparator = false;
                    this.lookahead.add(codepoint);
                    break;
                }
                atBeginning = false;
            }
            ++this.numSplits;
            return new PyUnicode(buffer);
        }
    }

    private abstract class SplitIterator
    implements Iterator {
        protected final int maxsplit;
        protected final Iterator<Integer> iter;
        protected final LinkedList<Integer> lookahead;
        protected int numSplits;
        protected boolean completeSeparator;

        SplitIterator(int maxsplit) {
            this.iter = PyUnicode.this.newSubsequenceIterator();
            this.lookahead = new LinkedList();
            this.numSplits = 0;
            this.completeSeparator = false;
            this.maxsplit = maxsplit;
        }

        public boolean hasNext() {
            return this.lookahead.peek() != null || this.iter.hasNext() && (this.maxsplit == -1 || this.numSplits <= this.maxsplit);
        }

        protected void addLookahead(StringBuilder buffer) {
            Iterator i$ = this.lookahead.iterator();
            while (i$.hasNext()) {
                int codepoint = (Integer)i$.next();
                buffer.appendCodePoint(codepoint);
            }
            this.lookahead.clear();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean getEndsWithSeparator() {
            return this.completeSeparator && !this.hasNext();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StripIterator
    implements Iterator {
        private final Iterator<Integer> iter;
        private int lookahead = -1;

        public StripIterator(PyUnicode sep, Iterator<Integer> iter) {
            this.iter = iter;
            if (sep != null) {
                Set sepSet = Generic.set();
                Iterator<Integer> sepIter = sep.newSubsequenceIterator();
                while (sepIter.hasNext()) {
                    sepSet.add(sepIter.next());
                }
                while (iter.hasNext()) {
                    int codePoint = iter.next();
                    if (sepSet.contains(codePoint)) continue;
                    this.lookahead = codePoint;
                    return;
                }
            } else {
                while (iter.hasNext()) {
                    int codePoint = iter.next();
                    if (Character.isWhitespace(codePoint)) continue;
                    this.lookahead = codePoint;
                    return;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.lookahead != -1;
        }

        public Object next() {
            int old = this.lookahead;
            this.lookahead = this.iter.hasNext() ? this.iter.next() : -1;
            return old;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SteppedIterator<T>
    implements Iterator {
        private final Iterator<T> iter;
        private final int step;
        private T lookahead = null;

        public SteppedIterator(int step, Iterator<T> iter) {
            this.iter = iter;
            this.step = step;
            this.lookahead = this.advance();
        }

        private T advance() {
            if (this.iter.hasNext()) {
                T elem = this.iter.next();
                for (int i = 1; i < this.step && this.iter.hasNext(); ++i) {
                    this.iter.next();
                }
                return elem;
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.lookahead != null;
        }

        public T next() {
            T old = this.lookahead;
            if (this.iter.hasNext()) {
                this.lookahead = this.iter.next();
                for (int i = 1; i < this.step && this.iter.hasNext(); ++i) {
                    this.iter.next();
                }
            } else {
                this.lookahead = null;
            }
            return old;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class SubsequenceIteratorImpl
    implements Iterator {
        private int current;
        private int k = 0;
        private int start;
        private int stop;
        private int step;

        SubsequenceIteratorImpl(int start, int stop, int step) {
            this.current = start;
            this.start = start;
            this.stop = stop;
            this.step = step;
            for (int i = 0; i < start; ++i) {
                this.nextCodePoint();
            }
        }

        SubsequenceIteratorImpl() {
            this(0, pyUnicode.getCodePointCount(), 1);
        }

        public boolean hasNext() {
            return this.current < this.stop;
        }

        public Object next() {
            int codePoint = this.nextCodePoint();
            ++this.current;
            for (int j = 1; j < this.step && this.hasNext(); ++j) {
                this.nextCodePoint();
                ++this.current;
            }
            return codePoint;
        }

        /*
         * WARNING - void declaration
         */
        private int nextCodePoint() {
            void var3_3;
            char c = PyUnicode.this.string.charAt(this.k);
            if (c >= '\ud800' && c < '\udc00') {
                char W1 = PyUnicode.this.string.charAt(this.k + 1);
                int W2 = ((c & 0x3FF) << 10 | W1 & 0x3FF) + 65536;
                this.k += 2;
            } else {
                void U;
                var3_3 = U;
                ++this.k;
            }
            return (int)var3_3;
        }

        public void remove() {
            throw new UnsupportedOperationException("Not supported on PyUnicode objects (immutable)");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Plane {
        UNKNOWN,
        BASIC,
        ASTRAL;

    }

    public class PyUnicode$unicode___mod___exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode___mod___exposer(String string) {
            super(string, 2, 2);
            this.doc = "x.__mod__(y) <==> x%y";
        }

        public PyUnicode$unicode___mod___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__mod__(y) <==> x%y";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode___mod___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyUnicode)this.self).unicode___mod__(pyObject);
        }
    }

    public class PyUnicode$unicode___str___exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode___str___exposer(String string) {
            super(string, 1, 1);
            this.doc = "x.__str__() <==> str(x)";
        }

        public PyUnicode$unicode___str___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__str__() <==> str(x)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode___str___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyUnicode)this.self).unicode___str__();
        }
    }

    public class PyUnicode$unicode___len___exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode___len___exposer(String string) {
            super(string, 1, 1);
            this.doc = "x.__len__() <==> len(x)";
        }

        public PyUnicode$unicode___len___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__len__() <==> len(x)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode___len___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newInteger(((PyUnicode)this.self).unicode___len__());
        }
    }

    public class PyUnicode$unicode___repr___exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode___repr___exposer(String string) {
            super(string, 1, 1);
            this.doc = "x.__repr__() <==> repr(x)";
        }

        public PyUnicode$unicode___repr___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__repr__() <==> repr(x)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode___repr___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyUnicode)this.self).unicode___repr__();
        }
    }

    public class PyUnicode$unicode___getitem___exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode___getitem___exposer(String string) {
            super(string, 2, 2);
            this.doc = "x.__getitem__(y) <==> x[y]";
        }

        public PyUnicode$unicode___getitem___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__getitem__(y) <==> x[y]";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode___getitem___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyUnicode)this.self).unicode___getitem__(pyObject);
        }
    }

    public class PyUnicode$unicode___eq___exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode___eq___exposer(String string) {
            super(string, 2, 2);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n               \n               Use of negative indices is not supported.";
        }

        public PyUnicode$unicode___eq___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n               \n               Use of negative indices is not supported.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode___eq___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyUnicode)this.self).unicode___eq__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyUnicode$unicode___ne___exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode___ne___exposer(String string) {
            super(string, 2, 2);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n               \n               Use of negative indices is not supported.";
        }

        public PyUnicode$unicode___ne___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n               \n               Use of negative indices is not supported.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode___ne___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyUnicode)this.self).unicode___ne__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyUnicode$unicode___hash___exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode___hash___exposer(String string) {
            super(string, 1, 1);
            this.doc = "x.__hash__() <==> hash(x)";
        }

        public PyUnicode$unicode___hash___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__hash__() <==> hash(x)";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode___hash___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newInteger(((PyUnicode)this.self).unicode___hash__());
        }
    }

    public class PyUnicode$unicode___mul___exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode___mul___exposer(String string) {
            super(string, 2, 2);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n               \n               Use of negative indices is not supported.";
        }

        public PyUnicode$unicode___mul___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n               \n               Use of negative indices is not supported.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode___mul___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyUnicode)this.self).unicode___mul__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyUnicode$unicode___add___exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode___add___exposer(String string) {
            super(string, 2, 2);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n               \n               Use of negative indices is not supported.";
        }

        public PyUnicode$unicode___add___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n               \n               Use of negative indices is not supported.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode___add___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyUnicode)this.self).unicode___add__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyUnicode$unicode_upper_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_upper_exposer(String string) {
            super(string, 1, 1);
            this.doc = "S.upper() -> unicode\n\nReturn a copy of S converted to uppercase.";
        }

        public PyUnicode$unicode_upper_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.upper() -> unicode\n\nReturn a copy of S converted to uppercase.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_upper_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyUnicode)this.self).unicode_upper();
        }
    }

    public class PyUnicode$unicode_title_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_title_exposer(String string) {
            super(string, 1, 1);
            this.doc = "S.title() -> unicode\n\nReturn a titlecased version of S, i.e. words start with title case\ncharacters, all remaining cased characters have lower case.";
        }

        public PyUnicode$unicode_title_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.title() -> unicode\n\nReturn a titlecased version of S, i.e. words start with title case\ncharacters, all remaining cased characters have lower case.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_title_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyUnicode)this.self).unicode_title();
        }
    }

    public class PyUnicode$unicode_strip_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_strip_exposer(String string) {
            super(string, 1, 2);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n               \n               Use of negative indices is not supported.";
        }

        public PyUnicode$unicode_strip_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n               \n               Use of negative indices is not supported.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_strip_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyUnicode)this.self).unicode_strip(pyObject);
        }

        public PyObject __call__() {
            return ((PyUnicode)this.self).unicode_strip(null);
        }
    }

    public class PyUnicode$unicode_lstrip_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_lstrip_exposer(String string) {
            super(string, 1, 2);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n               \n               Use of negative indices is not supported.";
        }

        public PyUnicode$unicode_lstrip_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n               \n               Use of negative indices is not supported.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_lstrip_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyUnicode)this.self).unicode_lstrip(pyObject);
        }

        public PyObject __call__() {
            return ((PyUnicode)this.self).unicode_lstrip(null);
        }
    }

    public class PyUnicode$unicode_rstrip_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_rstrip_exposer(String string) {
            super(string, 1, 2);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n               \n               Use of negative indices is not supported.";
        }

        public PyUnicode$unicode_rstrip_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n               \n               Use of negative indices is not supported.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_rstrip_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyUnicode)this.self).unicode_rstrip(pyObject);
        }

        public PyObject __call__() {
            return ((PyUnicode)this.self).unicode_rstrip(null);
        }
    }

    public class PyUnicode$unicode_partition_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_partition_exposer(String string) {
            super(string, 2, 2);
            this.doc = "S.partition(sep) -> (head, sep, tail)\n\nSearches for the separator sep in S, and returns the part before it,\nthe separator itself, and the part after it.  If the separator is not\nfound, returns S and two empty strings.";
        }

        public PyUnicode$unicode_partition_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.partition(sep) -> (head, sep, tail)\n\nSearches for the separator sep in S, and returns the part before it,\nthe separator itself, and the part after it.  If the separator is not\nfound, returns S and two empty strings.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_partition_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyUnicode)this.self).unicode_partition(pyObject);
        }
    }

    public class PyUnicode$unicode_rpartition_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_rpartition_exposer(String string) {
            super(string, 2, 2);
            this.doc = "S.rpartition(sep) -> (tail, sep, head)\n\nSearches for the separator sep in S, starting at the end of S, and returns\nthe part before it, the separator itself, and the part after it.  If the\nseparator is not found, returns two empty strings and S.";
        }

        public PyUnicode$unicode_rpartition_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.rpartition(sep) -> (tail, sep, head)\n\nSearches for the separator sep in S, starting at the end of S, and returns\nthe part before it, the separator itself, and the part after it.  If the\nseparator is not found, returns two empty strings and S.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_rpartition_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyUnicode)this.self).unicode_rpartition(pyObject);
        }
    }

    public class PyUnicode$unicode_split_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_split_exposer(String string) {
            super(string, 1, 3);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n               \n               Use of negative indices is not supported.";
        }

        public PyUnicode$unicode_split_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n               \n               Use of negative indices is not supported.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_split_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return ((PyUnicode)this.self).unicode_split(pyObject, Py.py2int(pyObject2));
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyUnicode)this.self).unicode_split(pyObject, -1);
        }

        public PyObject __call__() {
            return ((PyUnicode)this.self).unicode_split(null, -1);
        }
    }

    public class PyUnicode$unicode_rsplit_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_rsplit_exposer(String string) {
            super(string, 1, 3);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n               \n               Use of negative indices is not supported.";
        }

        public PyUnicode$unicode_rsplit_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n               \n               Use of negative indices is not supported.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_rsplit_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return ((PyUnicode)this.self).unicode_rsplit(pyObject, Py.py2int(pyObject2));
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyUnicode)this.self).unicode_rsplit(pyObject, -1);
        }

        public PyObject __call__() {
            return ((PyUnicode)this.self).unicode_rsplit(null, -1);
        }
    }

    public class PyUnicode$unicode_splitlines_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_splitlines_exposer(String string) {
            super(string, 1, 2);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n               \n               Use of negative indices is not supported.";
        }

        public PyUnicode$unicode_splitlines_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n               \n               Use of negative indices is not supported.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_splitlines_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyUnicode)this.self).unicode_splitlines(Py.py2boolean(pyObject));
        }

        public PyObject __call__() {
            return ((PyUnicode)this.self).unicode_splitlines(false);
        }
    }

    public class PyUnicode$unicode_index_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_index_exposer(String string) {
            super(string, 2, 4);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n               \n               Use of negative indices is not supported.";
        }

        public PyUnicode$unicode_index_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n               \n               Use of negative indices is not supported.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_index_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            return Py.newInteger(((PyUnicode)this.self).unicode_index(pyObject.asString(), Py.py2int(pyObject2), pyObject3));
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return Py.newInteger(((PyUnicode)this.self).unicode_index(pyObject.asString(), Py.py2int(pyObject2), null));
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newInteger(((PyUnicode)this.self).unicode_index(pyObject.asString(), 0, null));
        }
    }

    public class PyUnicode$unicode_rindex_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_rindex_exposer(String string) {
            super(string, 2, 4);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n               \n               Use of negative indices is not supported.";
        }

        public PyUnicode$unicode_rindex_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n               \n               Use of negative indices is not supported.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_rindex_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            return Py.newInteger(((PyUnicode)this.self).unicode_rindex(pyObject.asString(), Py.py2int(pyObject2), pyObject3));
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return Py.newInteger(((PyUnicode)this.self).unicode_rindex(pyObject.asString(), Py.py2int(pyObject2), null));
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newInteger(((PyUnicode)this.self).unicode_rindex(pyObject.asString(), 0, null));
        }
    }

    public class PyUnicode$unicode_count_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_count_exposer(String string) {
            super(string, 2, 4);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n               \n               Use of negative indices is not supported.";
        }

        public PyUnicode$unicode_count_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n               \n               Use of negative indices is not supported.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_count_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            return Py.newInteger(((PyUnicode)this.self).unicode_count(pyObject, Py.py2int(pyObject2), pyObject3));
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return Py.newInteger(((PyUnicode)this.self).unicode_count(pyObject, Py.py2int(pyObject2), null));
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newInteger(((PyUnicode)this.self).unicode_count(pyObject, 0, null));
        }
    }

    public class PyUnicode$unicode_rfind_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_rfind_exposer(String string) {
            super(string, 2, 4);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n               \n               Use of negative indices is not supported.";
        }

        public PyUnicode$unicode_rfind_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n               \n               Use of negative indices is not supported.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_rfind_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            return Py.newInteger(((PyUnicode)this.self).unicode_rfind(pyObject.asString(), Py.py2int(pyObject2), pyObject3));
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return Py.newInteger(((PyUnicode)this.self).unicode_rfind(pyObject.asString(), Py.py2int(pyObject2), null));
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newInteger(((PyUnicode)this.self).unicode_rfind(pyObject.asString(), 0, null));
        }
    }

    public class PyUnicode$unicode_ljust_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_ljust_exposer(String string) {
            super(string, 2, 3);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n               \n               Use of negative indices is not supported.";
        }

        public PyUnicode$unicode_ljust_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n               \n               Use of negative indices is not supported.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_ljust_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return ((PyUnicode)this.self).unicode_ljust(Py.py2int(pyObject), pyObject2.asStringOrNull());
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyUnicode)this.self).unicode_ljust(Py.py2int(pyObject), null);
        }
    }

    public class PyUnicode$unicode_center_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_center_exposer(String string) {
            super(string, 2, 3);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n               \n               Use of negative indices is not supported.";
        }

        public PyUnicode$unicode_center_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n               \n               Use of negative indices is not supported.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_center_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return ((PyUnicode)this.self).unicode_center(Py.py2int(pyObject), pyObject2.asStringOrNull());
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyUnicode)this.self).unicode_center(Py.py2int(pyObject), null);
        }
    }

    public class PyUnicode$unicode_zfill_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_zfill_exposer(String string) {
            super(string, 2, 2);
            this.doc = "S.zfill(width) -> unicode\n\nPad a numeric string x with zeros on the left, to fill a field\nof the specified width. The string x is never truncated.";
        }

        public PyUnicode$unicode_zfill_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.zfill(width) -> unicode\n\nPad a numeric string x with zeros on the left, to fill a field\nof the specified width. The string x is never truncated.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_zfill_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyUnicode)this.self).unicode_zfill(Py.py2int(pyObject));
        }
    }

    public class PyUnicode$unicode_capitalize_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_capitalize_exposer(String string) {
            super(string, 1, 1);
            this.doc = "S.capitalize() -> unicode\n\nReturn a capitalized version of S, i.e. make the first character\nhave upper case.";
        }

        public PyUnicode$unicode_capitalize_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.capitalize() -> unicode\n\nReturn a capitalized version of S, i.e. make the first character\nhave upper case.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_capitalize_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyUnicode)this.self).unicode_capitalize();
        }
    }

    public class PyUnicode$unicode_replace_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_replace_exposer(String string) {
            super(string, 3, 4);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n               \n               Use of negative indices is not supported.";
        }

        public PyUnicode$unicode_replace_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n               \n               Use of negative indices is not supported.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_replace_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            return ((PyUnicode)this.self).unicode_replace(pyObject, pyObject2, Py.py2int(pyObject3));
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return ((PyUnicode)this.self).unicode_replace(pyObject, pyObject2, -1);
        }
    }

    public class PyUnicode$unicode_join_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_join_exposer(String string) {
            super(string, 2, 2);
            this.doc = "S.join(sequence) -> unicode\n\nReturn a string which is the concatenation of the strings in the\nsequence.  The separator between elements is S.";
        }

        public PyUnicode$unicode_join_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.join(sequence) -> unicode\n\nReturn a string which is the concatenation of the strings in the\nsequence.  The separator between elements is S.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_join_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyUnicode)this.self).unicode_join(pyObject);
        }
    }

    public class PyUnicode$unicode_endswith_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_endswith_exposer(String string) {
            super(string, 2, 4);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n               \n               Use of negative indices is not supported.";
        }

        public PyUnicode$unicode_endswith_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n               \n               Use of negative indices is not supported.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_endswith_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            return Py.newBoolean(((PyUnicode)this.self).unicode_endswith(pyObject, Py.py2int(pyObject2), pyObject3));
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return Py.newBoolean(((PyUnicode)this.self).unicode_endswith(pyObject, Py.py2int(pyObject2), null));
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newBoolean(((PyUnicode)this.self).unicode_endswith(pyObject, 0, null));
        }
    }

    public class PyUnicode$unicode_translate_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_translate_exposer(String string) {
            super(string, 2, 2);
            this.doc = "S.translate(table) -> unicode\n\nReturn a copy of the string S, where all characters have been mapped\nthrough the given translation table, which must be a mapping of\nUnicode ordinals to Unicode ordinals, Unicode strings or None.\nUnmapped characters are left untouched. Characters mapped to None\nare deleted.";
        }

        public PyUnicode$unicode_translate_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.translate(table) -> unicode\n\nReturn a copy of the string S, where all characters have been mapped\nthrough the given translation table, which must be a mapping of\nUnicode ordinals to Unicode ordinals, Unicode strings or None.\nUnmapped characters are left untouched. Characters mapped to None\nare deleted.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_translate_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyUnicode)this.self).unicode_translate(pyObject);
        }
    }

    public class PyUnicode$unicode_islower_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_islower_exposer(String string) {
            super(string, 1, 1);
            this.doc = "S.islower() -> bool\n\nReturn True if all cased characters in S are lowercase and there is\nat least one cased character in S, False otherwise.";
        }

        public PyUnicode$unicode_islower_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.islower() -> bool\n\nReturn True if all cased characters in S are lowercase and there is\nat least one cased character in S, False otherwise.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_islower_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyUnicode)this.self).unicode_islower());
        }
    }

    public class PyUnicode$unicode_isupper_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_isupper_exposer(String string) {
            super(string, 1, 1);
            this.doc = "S.isupper() -> bool\n\nReturn True if all cased characters in S are uppercase and there is\nat least one cased character in S, False otherwise.";
        }

        public PyUnicode$unicode_isupper_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.isupper() -> bool\n\nReturn True if all cased characters in S are uppercase and there is\nat least one cased character in S, False otherwise.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_isupper_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyUnicode)this.self).unicode_isupper());
        }
    }

    public class PyUnicode$unicode_isalpha_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_isalpha_exposer(String string) {
            super(string, 1, 1);
            this.doc = "S.isalpha() -> bool\n\nReturn True if all characters in S are alphabetic\nand there is at least one character in S, False otherwise.";
        }

        public PyUnicode$unicode_isalpha_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.isalpha() -> bool\n\nReturn True if all characters in S are alphabetic\nand there is at least one character in S, False otherwise.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_isalpha_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyUnicode)this.self).unicode_isalpha());
        }
    }

    public class PyUnicode$unicode_isalnum_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_isalnum_exposer(String string) {
            super(string, 1, 1);
            this.doc = "S.isalnum() -> bool\n\nReturn True if all characters in S are alphanumeric\nand there is at least one character in S, False otherwise.";
        }

        public PyUnicode$unicode_isalnum_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.isalnum() -> bool\n\nReturn True if all characters in S are alphanumeric\nand there is at least one character in S, False otherwise.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_isalnum_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyUnicode)this.self).unicode_isalnum());
        }
    }

    public class PyUnicode$unicode_isdigit_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_isdigit_exposer(String string) {
            super(string, 1, 1);
            this.doc = "S.isdigit() -> bool\n\nReturn True if all characters in S are digits\nand there is at least one character in S, False otherwise.";
        }

        public PyUnicode$unicode_isdigit_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.isdigit() -> bool\n\nReturn True if all characters in S are digits\nand there is at least one character in S, False otherwise.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_isdigit_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyUnicode)this.self).unicode_isdigit());
        }
    }

    public class PyUnicode$unicode_istitle_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_istitle_exposer(String string) {
            super(string, 1, 1);
            this.doc = "S.istitle() -> bool\n\nReturn True if S is a titlecased string and there is at least one\ncharacter in S, i.e. upper- and titlecase characters may only\nfollow uncased characters and lowercase characters only cased ones.\nReturn False otherwise.";
        }

        public PyUnicode$unicode_istitle_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.istitle() -> bool\n\nReturn True if S is a titlecased string and there is at least one\ncharacter in S, i.e. upper- and titlecase characters may only\nfollow uncased characters and lowercase characters only cased ones.\nReturn False otherwise.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_istitle_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyUnicode)this.self).unicode_istitle());
        }
    }

    public class PyUnicode$unicode_isspace_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_isspace_exposer(String string) {
            super(string, 1, 1);
            this.doc = "S.isspace() -> bool\n\nReturn True if all characters in S are whitespace\nand there is at least one character in S, False otherwise.";
        }

        public PyUnicode$unicode_isspace_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "S.isspace() -> bool\n\nReturn True if all characters in S are whitespace\nand there is at least one character in S, False otherwise.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_isspace_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyUnicode)this.self).unicode_isspace());
        }
    }

    public class PyUnicode$unicode_isunicode_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_isunicode_exposer(String string) {
            super(string, 1, 1);
            this.doc = "isunicode is deprecated.";
        }

        public PyUnicode$unicode_isunicode_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "isunicode is deprecated.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_isunicode_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyUnicode)this.self).unicode_isunicode());
        }
    }

    public class PyUnicode$unicode_encode_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_encode_exposer(String string) {
            super(string, 1, 3);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n               \n               Use of negative indices is not supported.";
        }

        public PyUnicode$unicode_encode_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n               \n               Use of negative indices is not supported.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_encode_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            String string = ((PyUnicode)this.self).unicode_encode(pyObject.asStringOrNull(), pyObject2.asStringOrNull());
            return string == null ? Py.None : Py.newString(string);
        }

        public PyObject __call__(PyObject pyObject) {
            String string = ((PyUnicode)this.self).unicode_encode(pyObject.asStringOrNull(), null);
            return string == null ? Py.None : Py.newString(string);
        }

        public PyObject __call__() {
            String string = ((PyUnicode)this.self).unicode_encode(null, null);
            return string == null ? Py.None : Py.newString(string);
        }
    }

    public class PyUnicode$unicode_decode_exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode_decode_exposer(String string) {
            super(string, 1, 3);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n               \n               Use of negative indices is not supported.";
        }

        public PyUnicode$unicode_decode_exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "x.__getslice__(i, j) <==> x[i:j]\n               \n               Use of negative indices is not supported.";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode_decode_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return ((PyUnicode)this.self).unicode_decode(pyObject.asStringOrNull(), pyObject2.asStringOrNull());
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyUnicode)this.self).unicode_decode(pyObject.asStringOrNull(), null);
        }

        public PyObject __call__() {
            return ((PyUnicode)this.self).unicode_decode(null, null);
        }
    }

    public class PyUnicode$unicode___getnewargs___exposer
    extends PyBuiltinMethodNarrow {
        public PyUnicode$unicode___getnewargs___exposer(String string) {
            super(string, 1, 1);
            this.doc = "";
        }

        public PyUnicode$unicode___getnewargs___exposer(PyType pyType, PyObject pyObject, PyBuiltinCallable.Info info) {
            super(pyType, pyObject, info);
            this.doc = "";
        }

        public PyBuiltinCallable bind(PyObject pyObject) {
            return new PyUnicode$unicode___getnewargs___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyUnicode)this.self).unicode___getnewargs__();
        }
    }

    public class PyUnicode$PyExposer
    extends BaseTypeBuilder {
        public PyUnicode$PyExposer() {
            PyBuiltinMethod[] pyBuiltinMethodArray = new PyBuiltinMethod[]{new PyUnicode$unicode___mod___exposer("__mod__"), new PyUnicode$unicode___str___exposer("__str__"), new PyUnicode$unicode___len___exposer("__len__"), new PyUnicode$unicode___repr___exposer("__repr__"), new PyUnicode$unicode___getitem___exposer("__getitem__"), new PyUnicode$unicode___getslice___exposer("__getslice__"), new PyUnicode$unicode___cmp___exposer("__cmp__"), new PyUnicode$unicode___eq___exposer("__eq__"), new PyUnicode$unicode___ne___exposer("__ne__"), new PyUnicode$unicode___hash___exposer("__hash__"), new PyUnicode$unicode___contains___exposer("__contains__"), new PyUnicode$unicode___mul___exposer("__mul__"), new PyUnicode$unicode___rmul___exposer("__rmul__"), new PyUnicode$unicode___add___exposer("__add__"), new PyUnicode$unicode_lower_exposer("lower"), new PyUnicode$unicode_upper_exposer("upper"), new PyUnicode$unicode_title_exposer("title"), new PyUnicode$unicode_swapcase_exposer("swapcase"), new PyUnicode$unicode_strip_exposer("strip"), new PyUnicode$unicode_lstrip_exposer("lstrip"), new PyUnicode$unicode_rstrip_exposer("rstrip"), new PyUnicode$unicode_partition_exposer("partition"), new PyUnicode$unicode_rpartition_exposer("rpartition"), new PyUnicode$unicode_split_exposer("split"), new PyUnicode$unicode_rsplit_exposer("rsplit"), new PyUnicode$unicode_splitlines_exposer("splitlines"), new PyUnicode$unicode_index_exposer("index"), new PyUnicode$unicode_rindex_exposer("rindex"), new PyUnicode$unicode_count_exposer("count"), new PyUnicode$unicode_find_exposer("find"), new PyUnicode$unicode_rfind_exposer("rfind"), new PyUnicode$unicode_ljust_exposer("ljust"), new PyUnicode$unicode_rjust_exposer("rjust"), new PyUnicode$unicode_center_exposer("center"), new PyUnicode$unicode_zfill_exposer("zfill"), new PyUnicode$unicode_expandtabs_exposer("expandtabs"), new PyUnicode$unicode_capitalize_exposer("capitalize"), new PyUnicode$unicode_replace_exposer("replace"), new PyUnicode$unicode_join_exposer("join"), new PyUnicode$unicode_startswith_exposer("startswith"), new PyUnicode$unicode_endswith_exposer("endswith"), new PyUnicode$unicode_translate_exposer("translate"), new PyUnicode$unicode_islower_exposer("islower"), new PyUnicode$unicode_isupper_exposer("isupper"), new PyUnicode$unicode_isalpha_exposer("isalpha"), new PyUnicode$unicode_isalnum_exposer("isalnum"), new PyUnicode$unicode_isdecimal_exposer("isdecimal"), new PyUnicode$unicode_isdigit_exposer("isdigit"), new PyUnicode$unicode_isnumeric_exposer("isnumeric"), new PyUnicode$unicode_istitle_exposer("istitle"), new PyUnicode$unicode_isspace_exposer("isspace"), new PyUnicode$unicode_isunicode_exposer("isunicode"), new PyUnicode$unicode_encode_exposer("encode"), new PyUnicode$unicode_decode_exposer("decode"), new PyUnicode$unicode___getnewargs___exposer("__getnewargs__")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{};
            super("unicode", PyUnicode.class, PyBaseString.class, true, pyBuiltinMethodArray, pyDataDescrArray, new PyUnicode$exposed___new__());
        }
    }
}

