/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.common;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataMap {
    public Map<MetaDataKey, MetaDataValue> theMap;

    public MetaDataMap() {
        if (this.theMap == null) {
            this.theMap = new TreeMap<MetaDataKey, MetaDataValue>();
        }
    }

    public MetaDataKey newKey(String string) {
        return new MetaDataKey(string);
    }

    public MetaDataValue put(MetaDataKey metaDataKey, MetaDataValue metaDataValue) {
        return this.theMap.put(metaDataKey, metaDataValue);
    }

    public MetaDataValue put(MetaDataKey metaDataKey, Object object) {
        MetaDataValue metaDataValue = new MetaDataValue(metaDataKey.name, object);
        return this.theMap.put(metaDataKey, metaDataValue);
    }

    public MetaDataValue get(MetaDataKey metaDataKey) {
        return this.theMap.get(metaDataKey);
    }

    public String get(String string) {
        String string2 = null;
        MetaDataKey metaDataKey = new MetaDataKey(string);
        MetaDataValue metaDataValue = this.theMap.get(metaDataKey);
        if (metaDataValue != null) {
            return metaDataValue.value.toString();
        }
        for (MetaDataKey metaDataKey2 : this.theMap.keySet()) {
            if (!metaDataKey2.name.equals(string)) continue;
            metaDataValue = this.theMap.get(metaDataKey2);
            return metaDataValue.value.toString();
        }
        return string2;
    }

    public String get(Object object) {
        return this.get((String)object);
    }

    public String put(String string, String string2) {
        MetaDataKey metaDataKey = new MetaDataKey(string);
        MetaDataValue metaDataValue = new MetaDataValue(string, string2);
        this.theMap.put(metaDataKey, metaDataValue);
        return metaDataValue.value.toString();
    }

    public void remove(String string) {
        MetaDataKey metaDataKey = new MetaDataKey(string);
        this.theMap.remove(metaDataKey);
    }

    public int size() {
        return this.theMap.size();
    }

    public Set<MetaDataKey> keySet() {
        return this.theMap.keySet();
    }

    public boolean containsKey(String string) {
        MetaDataKey metaDataKey = new MetaDataKey(string);
        return this.theMap.containsKey(metaDataKey);
    }

    public MetaDataValue remove(MetaDataKey metaDataKey) {
        return this.theMap.remove(metaDataKey);
    }

    public Set<Map.Entry<MetaDataKey, MetaDataValue>> entrySet() {
        return this.theMap.entrySet();
    }

    public void putAll(MetaDataMap metaDataMap) {
        this.theMap.putAll(metaDataMap.theMap);
    }

    public class MetaDataValue {
        public String name;
        public Object value;

        public String toString() {
            return this.value.toString();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof MetaDataValue)) {
                return false;
            }
            MetaDataValue metaDataValue = (MetaDataValue)object;
            if (this.name == null ? metaDataValue.name != null : !this.name.equals(metaDataValue.name)) {
                return false;
            }
            return !(this.value == null ? metaDataValue.value != null : !this.value.equals(metaDataValue.value));
        }

        public MetaDataValue(String string, Object object) {
            this.name = string;
            this.value = object;
        }
    }

    public class MetaDataKey
    implements Comparable {
        public String name;
        public String timer_context;
        public int call_number;
        public long timestamp;

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
            if (this.timer_context != null) {
                n = 31 * n + this.call_number;
                n = 31 * n + (this.timer_context == null ? 0 : this.timer_context.hashCode());
                n = 31 * n + (int)(this.timestamp ^ this.timestamp >>> 32);
            }
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof MetaDataKey)) {
                return false;
            }
            MetaDataKey metaDataKey = (MetaDataKey)object;
            if (this.call_number != metaDataKey.call_number) {
                return false;
            }
            if (this.name == null ? metaDataKey.name != null : !this.name.equals(metaDataKey.name)) {
                return false;
            }
            if (this.timer_context == null ? metaDataKey.timer_context != null : !this.timer_context.equals(metaDataKey.timer_context)) {
                return false;
            }
            return this.timestamp == metaDataKey.timestamp;
        }

        public MetaDataKey(String string) {
            this.name = string;
            this.timer_context = null;
            this.call_number = 0;
            this.timestamp = 0L;
        }

        public int compareTo(Object object) {
            if (!(object instanceof MetaDataKey)) {
                return 1;
            }
            MetaDataKey metaDataKey = (MetaDataKey)object;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.name);
            if (this.timer_context != null) {
                stringBuffer.append(":");
                stringBuffer.append(this.timer_context);
                stringBuffer.append(":");
                stringBuffer.append(this.call_number);
                stringBuffer.append(":");
                stringBuffer.append(this.timestamp);
            }
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append(metaDataKey.name);
            if (metaDataKey.timer_context != null) {
                stringBuffer2.append(":");
                stringBuffer2.append(metaDataKey.timer_context);
                stringBuffer2.append(":");
                stringBuffer2.append(metaDataKey.call_number);
                stringBuffer2.append(":");
                stringBuffer2.append(metaDataKey.timestamp);
            }
            return stringBuffer.toString().compareTo(stringBuffer2.toString());
        }

        public String toString() {
            if (this.timestamp == 0L && this.timer_context == null && this.call_number == 0) {
                return this.name;
            }
            return "name=" + this.name + ", timer_context=" + this.timer_context + ", call_number=" + this.call_number + ", timestamp=" + this.timestamp;
        }
    }
}

