/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.vis;

import edu.uoregon.tau.vis.ColorScale;
import edu.uoregon.tau.vis.HeatMapData;
import edu.uoregon.tau.vis.HeatMapScanner;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class HeatMap
extends JPanel
implements ImageObserver {
    private static final long serialVersionUID = -2201072741534481423L;
    BufferedImage img = null;
    StringBuffer description = null;
    private static final ColorScale scale = new ColorScale(ColorScale.ColorSet.RAINBOW);
    public static final String TMPDIR = System.getProperty("user.home") + File.separator + ".ParaProf" + File.separator + "tmp" + File.separator;
    private HeatMapScanner scanner = null;
    private HeatMapData mapData = null;
    private DecimalFormat f = new DecimalFormat("0");
    private int size = 128;
    private int index = 0;
    private String path = "";

    public HeatMap(HeatMapData heatMapData, int n, String string, String string2) {
        int n2;
        Object object;
        this.mapData = heatMapData;
        this.size = heatMapData.getSize();
        this.description = new StringBuffer();
        this.description.append(string2);
        this.index = n;
        this.path = string;
        double d = heatMapData.getMax(string, n);
        double d2 = heatMapData.getMin(string, n);
        double d3 = d - d2;
        int n3 = this.size;
        int n4 = this.size;
        if (this.img == null) {
            object = GraphicsEnvironment.getLocalGraphicsEnvironment();
            n2 = 1;
            GraphicsDevice graphicsDevice = ((GraphicsEnvironment)object).getDefaultScreenDevice();
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            this.img = graphicsConfiguration.createCompatibleImage(n3, n4, n2);
        }
        heatMapData.reset();
        while (heatMapData.hasNext()) {
            object = heatMapData.next();
            n2 = ((HeatMapData.NextValue)object).receiver;
            int n5 = ((HeatMapData.NextValue)object).sender;
            double d4 = ((HeatMapData.NextValue)object).getValue(string, n);
            if (d4 > 0.0 && d3 == 0.0) {
                this.img.setRGB(n2, n5, scale.getColor(1.0f).getRGB());
                continue;
            }
            if (!(d4 > 0.0)) continue;
            this.img.setRGB(n2, n5, scale.getColor((float)((d4 - d2) / d3)).getRGB());
        }
        if (256 < this.size) {
            int n6 = this.size / 256 + 1;
            n2 = this.size * n6 * 2;
            this.setPreferredSize(new Dimension(n2, n2));
            this.setSize(n2, n2);
        } else {
            this.setPreferredSize(new Dimension(this.size, this.size));
            this.setSize(this.size, this.size);
        }
        this.scanner = new HeatMapScanner(this, this.size);
        this.addMouseListener(this.scanner);
        this.addMouseMotionListener(this.scanner);
        this.addMouseMotionListener(this.scanner);
        this.addMouseWheelListener(this.scanner);
        this.setFocusable(true);
        this.addKeyListener(this.scanner);
    }

    public String getToolTip(Point point) {
        int n = this.getSize().height;
        int n2 = this.getSize().width;
        double d = (double)Math.max(n2, 512) / (double)this.size;
        int n3 = Math.min((int)(point.getX() / d), this.size - 1);
        d = (double)Math.max(n, 512) / (double)this.size;
        int n4 = Math.min((int)(point.getY() / d), this.size - 1);
        double d2 = this.mapData.get(n4, n3, this.path, this.index);
        String string = "<html>sender = " + n4 + "<BR>receiver = " + n3 + "<BR>value = " + this.f.format(d2) + "</html>";
        return string;
    }

    public String getImage() {
        String string = TMPDIR + "clusterImage." + this.description + ".png";
        File file = new File(string);
        try {
            ImageIO.write((RenderedImage)this.img, "PNG", file);
        }
        catch (IOException iOException) {
            String string2 = "ERROR: Couldn't write the virtual topology image!";
            System.err.println(string2);
            System.err.println(iOException.getMessage());
            iOException.printStackTrace();
        }
        return string;
    }

    public String getThumbnail() {
        String string = TMPDIR + "clusterImage.thumb." + this.description + ".png";
        return string;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        if (this.getSize().width < this.size) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        } else {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        }
        graphics.drawImage(this.img, insets.left, insets.top, dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom, this);
        graphics.dispose();
    }

    public int getMapSize() {
        return this.size;
    }

    public HeatMapScanner getScanner() {
        return this.scanner;
    }

    public void clean() {
    }

    public void update(HeatMapData heatMapData, int n, String string, String string2) {
        this.mapData = heatMapData;
        this.size = heatMapData.getSize();
        this.description = new StringBuffer();
        this.description.append(this.description);
        this.index = n;
        this.path = string;
        double d = heatMapData.getMax(string, n);
        double d2 = heatMapData.getMin(string, n);
        double d3 = d - d2;
        int n2 = this.size;
        int n3 = this.size;
        this.img = null;
        if (this.img == null) {
            this.img = new BufferedImage(n2, n3, 1);
        }
        heatMapData.reset();
        while (heatMapData.hasNext()) {
            HeatMapData.NextValue nextValue = heatMapData.next();
            int n4 = nextValue.receiver;
            int n5 = nextValue.sender;
            double d4 = nextValue.getValue(string, n);
            if (d4 > 0.0 && d3 == 0.0) {
                this.img.setRGB(n4, n5, scale.getColor(1.0f).getRGB());
                continue;
            }
            if (!(d4 > 0.0)) continue;
            this.img.setRGB(n4, n5, scale.getColor((float)((d4 - d2) / d3)).getRGB());
        }
    }

    public void goAway() {
        this.img.flush();
    }
}

