/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UserEvent;
import edu.uoregon.tau.perfdmf.UserEventProfile;
import edu.uoregon.tau.perfdmf.database.DB;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomicLocationProfile {
    public static Vector<UserEventProfile> getAtomicEventData(DB dB, String string, DataSource dataSource, Map<Integer, UserEvent> map) {
        if (dB.getSchemaVersion() > 0) {
            return AtomicLocationProfile.TAUdbGetAtomicEventData(dB, string, dataSource, map);
        }
        Vector<UserEventProfile> vector = new Vector<UserEventProfile>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select p.atomic_event, p.node, ");
        stringBuffer.append("p.context, p.thread, p.sample_count, ");
        stringBuffer.append("p.maximum_value, p.minimum_value, p.mean_value, ");
        stringBuffer.append("p.standard_deviation, e.trial ");
        stringBuffer.append("from " + dB.getSchemaPrefix() + "atomic_location_profile p ");
        stringBuffer.append("inner join " + dB.getSchemaPrefix() + "atomic_event e on e.id = p.atomic_event ");
        stringBuffer.append(string);
        stringBuffer.append(" order by p.node, p.context, p.thread, p.atomic_event");
        try {
            ResultSet resultSet = dB.executeQuery(stringBuffer.toString());
            while (resultSet.next()) {
                UserEvent userEvent;
                int n;
                int n2;
                int n3 = resultSet.getInt(1);
                int n4 = resultSet.getInt(2);
                Thread thread = dataSource.addThread(n4, n2 = resultSet.getInt(3), n = resultSet.getInt(4));
                UserEventProfile userEventProfile = thread.getUserEventProfile(userEvent = map.get(new Integer(n3)));
                if (userEventProfile == null) {
                    userEventProfile = new UserEventProfile(userEvent);
                    thread.addUserEventProfile(userEventProfile);
                }
                userEventProfile.setNumSamples(resultSet.getInt(5));
                userEventProfile.setMaxValue(resultSet.getDouble(6));
                userEventProfile.setMinValue(resultSet.getDouble(7));
                userEventProfile.setMeanValue(resultSet.getDouble(8));
                userEventProfile.setSumSquared(resultSet.getDouble(9));
                userEventProfile.updateMax();
                vector.addElement(userEventProfile);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return vector;
    }

    private static Vector<UserEventProfile> TAUdbGetAtomicEventData(DB dB, String string, DataSource dataSource, Map<Integer, UserEvent> map) {
        Vector<UserEventProfile> vector = new Vector<UserEventProfile>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select v.counter, h.node_rank as node, h.context_rank as context, h.thread_rank as thread,v.sample_count,");
        stringBuffer.append("v.maximum_value, v.minimum_value, v.mean_value,v.standard_deviation");
        stringBuffer.append(" from " + dB.getSchemaPrefix() + "counter_value v  left outer join counter e on v.counter = e.id ");
        stringBuffer.append("left outer join " + dB.getSchemaPrefix() + "thread h on v.thread = h.id ");
        stringBuffer.append(string);
        stringBuffer.append(" order by node, context, thread, v.counter");
        try {
            ResultSet resultSet = dB.executeQuery(stringBuffer.toString());
            while (resultSet.next()) {
                UserEvent userEvent;
                int n;
                int n2;
                int n3 = resultSet.getInt(1);
                int n4 = resultSet.getInt(2);
                Thread thread = dataSource.addThread(n4, n2 = resultSet.getInt(3), n = resultSet.getInt(4));
                UserEventProfile userEventProfile = thread.getUserEventProfile(userEvent = map.get(new Integer(n3)));
                if (userEventProfile == null) {
                    userEventProfile = new UserEventProfile(userEvent);
                    thread.addUserEventProfile(userEventProfile);
                }
                userEventProfile.setNumSamples(resultSet.getInt(5));
                userEventProfile.setMaxValue(resultSet.getDouble(6));
                userEventProfile.setMinValue(resultSet.getDouble(7));
                userEventProfile.setMeanValue(resultSet.getDouble(8));
                userEventProfile.setSumSquared(resultSet.getDouble(9));
                userEventProfile.updateMax();
                vector.addElement(userEventProfile);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return vector;
    }

    public static void saveAtomicEventData(DB dB, Hashtable<Integer, Integer> hashtable, List<Thread> list) {
        try {
            PreparedStatement preparedStatement = null;
            preparedStatement = dB.getSchemaVersion() > 0 ? dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "counter_value (atomic_event, sample_count, maximum_value, minimum_value, mean_value, standard_deviation, thread) VALUES (?, ?, ?, ?, ?, ?, ?)") : dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "atomic_location_profile (atomic_event, sample_count, maximum_value, minimum_value, mean_value, standard_deviation, node, context, thread) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            for (Thread thread : list) {
                Iterator<UserEventProfile> iterator = thread.getUserEventProfiles();
                while (iterator.hasNext()) {
                    UserEventProfile userEventProfile = iterator.next();
                    if (userEventProfile == null) continue;
                    preparedStatement.setInt(1, userEventProfile.getUserEvent().getID());
                    preparedStatement.setInt(2, (int)userEventProfile.getNumSamples());
                    preparedStatement.setDouble(3, userEventProfile.getMaxValue());
                    preparedStatement.setDouble(4, userEventProfile.getMinValue());
                    preparedStatement.setDouble(5, userEventProfile.getMeanValue());
                    preparedStatement.setDouble(6, userEventProfile.getSumSquared());
                    if (dB.getSchemaVersion() > 0) {
                        preparedStatement.setInt(7, thread.getThreadID());
                    } else {
                        preparedStatement.setInt(7, thread.getNodeID());
                        preparedStatement.setInt(8, thread.getContextID());
                        preparedStatement.setInt(9, thread.getThreadID());
                    }
                    preparedStatement.addBatch();
                }
            }
            preparedStatement.executeBatch();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            System.out.println("An error occurred while saving the trial.");
            sQLException.printStackTrace();
        }
    }
}

