/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.database.ParseConfig;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Database
implements Serializable {
    private static final long serialVersionUID = -563600652298777970L;
    private String name;
    private int id;
    private ParseConfig config;
    private static int idCounter;
    private String[] appFieldNames;
    private int[] appFieldTypes;
    private String[] expFieldNames;
    private int[] expFieldTypes;
    private String[] trialFieldNames;
    private int[] trialFieldTypes;
    private String[] trialFieldTypeNames;
    private String[] metricFieldNames;
    private String[] metricFieldTypeNames;
    private String[] intervalEventFieldNames;
    private String[] intervalEventFieldTypeNames;
    private String[] atomicEventFieldNames;
    private String[] atomicEventFieldTypeNames;
    private boolean isTAUdb;
    private CountDownLatch latch;

    public void setLatch() {
        this.latch = new CountDownLatch(1);
    }

    public CountDownLatch getLatch() {
        return this.latch;
    }

    public boolean isTAUdb() {
        return this.isTAUdb;
    }

    public void setTAUdb(boolean bl) {
        this.isTAUdb = bl;
    }

    public String getName() {
        return this.name;
    }

    public String[] getAppFieldNames() {
        return this.appFieldNames;
    }

    public void setAppFieldNames(String[] stringArray) {
        this.appFieldNames = stringArray;
    }

    public int[] getAppFieldTypes() {
        return this.appFieldTypes;
    }

    public void setAppFieldTypes(int[] nArray) {
        this.appFieldTypes = nArray;
    }

    public String[] getExpFieldNames() {
        return this.expFieldNames;
    }

    public void setExpFieldNames(String[] stringArray) {
        this.expFieldNames = stringArray;
    }

    public int[] getExpFieldTypes() {
        return this.expFieldTypes;
    }

    public void setExpFieldTypes(int[] nArray) {
        this.expFieldTypes = nArray;
    }

    public String[] getTrialFieldNames() {
        return this.trialFieldNames;
    }

    public void setTrialFieldNames(String[] stringArray) {
        this.trialFieldNames = stringArray;
    }

    public int[] getTrialFieldTypes() {
        return this.trialFieldTypes;
    }

    public void setTrialFieldTypes(int[] nArray) {
        this.trialFieldTypes = nArray;
    }

    public Database(String string, ParseConfig parseConfig) {
        this.name = string;
        this.id = idCounter++;
        this.config = parseConfig;
        this.isTAUdb = parseConfig.getDBSchema().contains("taudb");
    }

    public Database(String string, String string2) {
        this(string, new ParseConfig(string2));
    }

    public Database(String string) {
        this("???", new ParseConfig(string));
    }

    public int getID() {
        return this.id;
    }

    public ParseConfig getConfig() {
        return this.config;
    }

    private static Database createDatabase(String string, String string2) {
        ParseConfig parseConfig = new ParseConfig(string2.toString());
        Database database = new Database(string, parseConfig);
        return database;
    }

    public static List<Database> getDatabases() {
        File file = new File(System.getProperty("user.home") + File.separator + ".ParaProf");
        String[] stringArray = file.list();
        ArrayList<Database> arrayList = new ArrayList<Database>();
        if (stringArray == null) {
            return arrayList;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].compareTo("perfdmf.cfg") == 0) {
                arrayList.add(Database.createDatabase("Default", file + File.separator + stringArray[i]));
                continue;
            }
            if (!stringArray[i].startsWith("perfdmf.cfg") || stringArray[i].endsWith("~")) continue;
            String string = stringArray[i].substring(12);
            arrayList.add(Database.createDatabase(string, file + File.separator + stringArray[i]));
        }
        return arrayList;
    }

    public String toString() {
        String string = this.config.getConnectionString();
        if (string.compareTo("") == 0) {
            string = "none";
        }
        return this.name + " (" + string + ")";
    }

    public String[] getTrialFieldTypeNames() {
        return this.trialFieldTypeNames;
    }

    public void setTrialFieldTypeNames(String[] stringArray) {
        this.trialFieldTypeNames = stringArray;
    }

    public String[] getMetricFieldTypeNames() {
        return this.metricFieldTypeNames;
    }

    public void setMetricFieldTypeNames(String[] stringArray) {
        this.metricFieldTypeNames = stringArray;
    }

    public String[] getMetricFieldNames() {
        return this.metricFieldNames;
    }

    public void setMetricFieldNames(String[] stringArray) {
        this.metricFieldNames = stringArray;
    }

    public String[] getIntervalEventFieldNames() {
        return this.intervalEventFieldNames;
    }

    public void setIntervalEventFieldNames(String[] stringArray) {
        this.intervalEventFieldNames = stringArray;
    }

    public String[] getIntervalEventFieldTypeNames() {
        return this.intervalEventFieldTypeNames;
    }

    public void setIntervalEventFieldTypeNames(String[] stringArray) {
        this.intervalEventFieldTypeNames = stringArray;
    }

    public String[] getAtomicEventFieldNames() {
        return this.atomicEventFieldNames;
    }

    public void setAtomicEventFieldNames(String[] stringArray) {
        this.atomicEventFieldNames = stringArray;
    }

    public String[] getAtomicEventFieldTypeNames() {
        return this.atomicEventFieldTypeNames;
    }

    public void setAtomicEventFieldTypeNames(String[] stringArray) {
        this.atomicEventFieldTypeNames = stringArray;
    }
}

