/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.DatabaseException;
import edu.uoregon.tau.perfdmf.database.DB;
import edu.uoregon.tau.perfdmf.database.DBConnector;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Machine
implements Serializable {
    private static final long serialVersionUID = 6366627604549775329L;
    private static String[] fieldNames;
    private static int[] fieldTypes;
    private int machineID;
    private int trialID;
    private int nodeID;
    private int contextID;
    private int threadID;
    private String[] fields;

    public Machine() {
        this.fields = fieldNames == null ? new String[0] : new String[fieldNames.length];
    }

    public Machine(Machine machine) {
        this.machineID = machine.getID();
        this.nodeID = machine.getNodeID();
        this.contextID = machine.getContextID();
        this.threadID = machine.getThreadID();
        this.fields = (String[])machine.fields.clone();
    }

    public void reallocMetaData() {
        this.fields = fieldNames == null ? new String[0] : new String[fieldNames.length];
    }

    public String[] getFields() {
        return this.fields;
    }

    public void setFields(String[] stringArray) {
        this.fields = stringArray;
    }

    public static void getMetaData(DB dB) {
        if (fieldNames != null) {
            return;
        }
        try {
            int n;
            ResultSet resultSet = null;
            DatabaseMetaData databaseMetaData = dB.getMetaData();
            resultSet = dB.getDBType().compareTo("oracle") == 0 || dB.getDBType().compareTo("derby") == 0 || dB.getDBType().compareTo("h2") == 0 || dB.getDBType().compareTo("db2") == 0 ? databaseMetaData.getColumns(null, null, "MACHINE_THREAD_MAP", "%") : databaseMetaData.getColumns(null, null, "machine_thread_map", "%");
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            boolean bl = false;
            while (resultSet.next()) {
                n = resultSet.getInt("DATA_TYPE");
                String string = resultSet.getString("COLUMN_NAME");
                if (string.equals("ID")) {
                    if (bl) break;
                    bl = true;
                }
                if (!DBConnector.isReadAbleType(n) || string.toUpperCase().compareTo("ID") == 0 || string.toUpperCase().compareTo("TRIAL") == 0 || string.toUpperCase().compareTo("NODE") == 0 || string.toUpperCase().compareTo("CONTEXT") == 0 || string.toUpperCase().compareTo("THREAD") == 0) continue;
                arrayList.add(resultSet.getString("COLUMN_NAME"));
                arrayList2.add(new Integer(n));
            }
            resultSet.close();
            fieldNames = new String[arrayList.size()];
            fieldTypes = new int[arrayList2.size()];
            for (n = 0; n < arrayList2.size(); ++n) {
                Machine.fieldNames[n] = (String)arrayList.get(n);
                Machine.fieldTypes[n] = (Integer)arrayList2.get(n);
            }
        }
        catch (SQLException sQLException) {
            System.err.println(sQLException.getMessage());
            sQLException.printStackTrace();
        }
    }

    public int getNumFields() {
        return this.fields.length;
    }

    public String getFieldName(int n) {
        return fieldNames[n];
    }

    public String getField(int n) {
        return this.fields[n];
    }

    public int getFieldType(int n) {
        return fieldTypes[n];
    }

    public void setField(int n, String string) {
        if (DBConnector.isIntegerType(fieldTypes[n]) && string != null) {
            try {
                Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
        }
        if (DBConnector.isFloatingPointType(fieldTypes[n]) && string != null) {
            try {
                Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
        }
        this.fields[n] = string;
    }

    public int getID() {
        return this.machineID;
    }

    public int getTrialID() {
        return this.trialID;
    }

    public int getNodeID() {
        return this.nodeID;
    }

    public int getContextID() {
        return this.contextID;
    }

    public int getThreadID() {
        return this.threadID;
    }

    public String toString() {
        return "machine: " + this.machineID;
    }

    public void setID(int n) {
        this.machineID = n;
    }

    public void setTrialID(int n) {
        this.trialID = n;
    }

    public void setNodeID(int n) {
        this.nodeID = n;
    }

    public void setContextID(int n) {
        this.contextID = n;
    }

    public void setThreadID(int n) {
        this.threadID = n;
    }

    public static String[] getFieldNames(DB dB) throws DatabaseException {
        Machine.getMetaData(dB);
        return fieldNames;
    }

    public static List<Machine> getMachineList(DB dB, String string) throws DatabaseException {
        try {
            Machine.getMetaData(dB);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("select id, trial, node, context, thread");
            for (int i = 0; i < fieldNames.length; ++i) {
                stringBuffer.append(", " + fieldNames[i]);
            }
            stringBuffer.append(" from ");
            stringBuffer.append(dB.getSchemaPrefix());
            stringBuffer.append("machine_thread_map ");
            stringBuffer.append(string);
            stringBuffer.append(" order by trial, node, context, thread asc ");
            ArrayList<Machine> arrayList = new ArrayList<Machine>();
            ResultSet resultSet = dB.executeQuery(stringBuffer.toString());
            while (resultSet.next()) {
                Machine machine = new Machine();
                machine.setID(resultSet.getInt(1));
                machine.setTrialID(resultSet.getInt(2));
                machine.setNodeID(resultSet.getInt(3));
                machine.setContextID(resultSet.getInt(4));
                machine.setThreadID(resultSet.getInt(5));
                for (int i = 0; i < fieldNames.length; ++i) {
                    machine.setField(i, resultSet.getString(i + 4));
                }
                arrayList.add(machine);
            }
            resultSet.close();
            return arrayList;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException("Error getting Machine list", sQLException);
        }
    }

    public int saveMachine(DB dB) throws SQLException {
        int n;
        boolean bl = this.exists(dB);
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("UPDATE " + dB.getSchemaPrefix() + "Machine SET trial = ?, node = ?, context = ?, thread = ?");
            for (n = 0; n < this.getNumFields(); ++n) {
                if (!DBConnector.isWritableType(this.getFieldType(n))) continue;
                stringBuffer.append(", " + this.getFieldName(n) + " = ?");
            }
            stringBuffer.append(" WHERE id = ?");
        } else {
            stringBuffer.append("INSERT INTO " + dB.getSchemaPrefix() + "Machine (trial, node, context, thread");
            for (n = 0; n < this.getNumFields(); ++n) {
                if (!DBConnector.isWritableType(this.getFieldType(n))) continue;
                stringBuffer.append(", " + this.getFieldName(n));
            }
            stringBuffer.append(") VALUES (?, ?");
            for (n = 0; n < this.getNumFields(); ++n) {
                if (!DBConnector.isWritableType(this.getFieldType(n))) continue;
                stringBuffer.append(", ?");
            }
            stringBuffer.append(")");
        }
        PreparedStatement preparedStatement = dB.prepareStatement(stringBuffer.toString());
        int n3 = 1;
        preparedStatement.setInt(n3++, this.trialID);
        preparedStatement.setInt(n3++, this.nodeID);
        preparedStatement.setInt(n3++, this.contextID);
        preparedStatement.setInt(n3++, this.threadID);
        for (int i = 0; i < this.getNumFields(); ++i) {
            if (!DBConnector.isWritableType(this.getFieldType(i))) continue;
            preparedStatement.setString(n3++, this.getField(i));
        }
        if (bl) {
            preparedStatement.setInt(n3++, this.getID());
        }
        preparedStatement.executeUpdate();
        preparedStatement.close();
        if (bl) {
            n2 = this.machineID;
        } else {
            String string = new String();
            string = dB.getDBType().compareTo("mysql") == 0 ? "select LAST_INSERT_ID();" : (dB.getDBType().compareTo("db2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM Machine" : (dB.getDBType().compareTo("sqlite") == 0 ? "select seq from sqlite_sequence where name = 'machine'" : (dB.getDBType().compareTo("derby") == 0 ? "select IDENTITY_VAL_LOCAL() FROM Machine" : (dB.getDBType().compareTo("h2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM Machine" : (dB.getDBType().compareTo("oracle") == 0 ? "select " + dB.getSchemaPrefix() + "Machine_id_seq.currval FROM dual" : "select currval('Machine_id_seq');")))));
            n2 = Integer.parseInt(dB.getDataItem(string));
        }
        return n2;
    }

    private boolean exists(DB dB) throws SQLException {
        boolean bl = false;
        PreparedStatement preparedStatement = dB.prepareStatement("SELECT trial FROM " + dB.getSchemaPrefix() + "Machine WHERE id = ?");
        preparedStatement.setInt(1, this.machineID);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            bl = true;
        }
        resultSet.close();
        return bl;
    }

    public static void deleteMachine(DB dB, int n) throws DatabaseException {
        try {
            PreparedStatement preparedStatement = null;
            preparedStatement = dB.prepareStatement("delete from " + dB.getSchemaPrefix() + "Machine where id = ?");
            preparedStatement.setInt(1, n);
            preparedStatement.execute();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            throw new DatabaseException("Error deleting Machine", sQLException);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        if (fieldNames == null) {
            fieldNames = (String[])objectInputStream.readObject();
        }
        if (fieldTypes == null) {
            fieldTypes = (int[])objectInputStream.readObject();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(fieldNames);
        objectOutputStream.writeObject(fieldTypes);
    }

    public void removeMetaData() {
        fieldNames = null;
        fieldTypes = null;
    }
}

