/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.Context;
import edu.uoregon.tau.perfdmf.DataSource;
import edu.uoregon.tau.perfdmf.DataSourceException;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Group;
import edu.uoregon.tau.perfdmf.Node;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UtilFncs;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhaseConvertedDataSource
extends DataSource {
    public PhaseConvertedDataSource(DataSource dataSource, List<String> list) {
        if (!dataSource.getCallPathDataPresent()) {
            throw new IllegalArgumentException("Can't make phase profile without callpath data");
        }
        int n = dataSource.getNumberOfMetrics();
        for (int i = 0; i < n; ++i) {
            this.addMetric(dataSource.getMetricName(i));
        }
        for (Thread thread : dataSource.getAllThreads()) {
            Node node = this.addNode(thread.getNodeID());
            Context context = node.addContext(thread.getContextID());
            Thread thread2 = context.addThread(thread.getThreadID(), n);
            Iterator<FunctionProfile> iterator = thread.getFunctionProfileIterator();
            while (iterator.hasNext()) {
                Object object;
                Object object2;
                Object object3;
                FunctionProfile functionProfile = iterator.next();
                if (functionProfile == null) continue;
                if (!functionProfile.isCallPathFunction()) {
                    object3 = this.addFunction(functionProfile.getName(), n);
                    for (Group group : functionProfile.getFunction().getGroups()) {
                        object2 = this.addGroup(group.getName());
                        ((Function)object3).addGroup((Group)object2);
                    }
                    object = new FunctionProfile((Function)object3, n);
                    thread2.addFunctionProfile((FunctionProfile)object);
                    for (int i = 0; i < dataSource.getNumberOfMetrics(); ++i) {
                        ((FunctionProfile)object).setExclusive(i, functionProfile.getExclusive(i));
                        ((FunctionProfile)object).setInclusive(i, functionProfile.getInclusive(i));
                    }
                    ((FunctionProfile)object).setNumCalls(functionProfile.getNumCalls());
                    ((FunctionProfile)object).setNumSubr(functionProfile.getNumSubr());
                    continue;
                }
                object3 = functionProfile.getName();
                object = UtilFncs.getAllButRightMost((String)object3);
                String string = UtilFncs.getRightMost((String)object3);
                while (!this.match(UtilFncs.getRightMost((String)object), list) && ((String)object).indexOf("=>") >= 0) {
                    object = UtilFncs.getAllButRightMost((String)object);
                }
                object2 = UtilFncs.getRightMost((String)object);
                Function function = this.addFunction((String)object2);
                function.addGroup(this.addGroup("TAU_PHASE"));
                String string2 = (String)object2 + " => " + string;
                Function function2 = this.addFunction(string2);
                for (Group group : functionProfile.getFunction().getGroups()) {
                    Group group2 = this.addGroup(group.getName());
                    function2.addGroup(group2);
                }
                Object object4 = thread2.getFunctionProfile(function2);
                if (object4 == null) {
                    object4 = new FunctionProfile(function2, n);
                    thread2.addFunctionProfile((FunctionProfile)object4);
                }
                for (int i = 0; i < dataSource.getNumberOfMetrics(); ++i) {
                    ((FunctionProfile)object4).setExclusive(i, ((FunctionProfile)object4).getExclusive(i) + functionProfile.getExclusive(i));
                    ((FunctionProfile)object4).setInclusive(i, ((FunctionProfile)object4).getInclusive(i) + functionProfile.getInclusive(i));
                }
                ((FunctionProfile)object4).setNumCalls(((FunctionProfile)object4).getNumCalls() + functionProfile.getNumCalls());
                ((FunctionProfile)object4).setNumSubr(((FunctionProfile)object4).getNumSubr() + functionProfile.getNumSubr());
            }
        }
        this.generateDerivedData();
    }

    @Override
    public void load() throws FileNotFoundException, IOException, DataSourceException, SQLException {
    }

    @Override
    public int getProgress() {
        return 0;
    }

    @Override
    public void cancelLoad() {
    }

    private boolean match(String string, List<String> list) {
        return list.contains(string);
    }
}

