/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf.database;

import edu.uoregon.tau.perfdmf.Database;
import edu.uoregon.tau.perfdmf.database.CustomX509KeyManager;
import edu.uoregon.tau.perfdmf.database.DB;
import edu.uoregon.tau.perfdmf.database.ParseConfig;
import edu.uoregon.tau.perfdmf.database.PasswordCallback;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class DBConnector
implements DB {
    public static final String DEFAULT_TRUSTSTORE_PATH = System.getProperty("user.home") + File.separator + ".ParaProf" + File.separator + "keystore.taudb";
    public static final String DEFAULT_TRUSTSTORE_PASSWORD = "changeit";
    public static final String DEFAULT_KEYSTORE_PATH = System.getProperty("user.home") + File.separator + ".ParaProf" + File.separator + "keystore.taudb";
    public static final String DEFAULT_KEYSTORE_PASSWORD = "changeit";
    private Statement statement;
    private Connection conn;
    private ParseConfig config;
    private String dbaddress;
    private String driverName;
    private String JDBCjarFileName;
    private String dbServerHostname;
    private boolean dbUseSSL = false;
    private boolean dbUseKeys = false;
    private boolean dbUseTrust = false;
    private String dbKeystore;
    private String dbKeystorePassword;
    private String dbTruststore;
    private String dbTruststorePassword;
    private Database database;
    private int schemaVersion = -1;
    private static Map<String, String> passwordMap = new HashMap<String, String>();
    private static PasswordCallback passwordCallback;

    public DBConnector(String string, String string2, Database database) throws SQLException {
        this.database = database;
        this.config = database.getConfig();
        this.setJDBC(this.config);
        this.register();
        this.connect(string, string2);
    }

    public DBConnector(String string, String string2, Database database, boolean bl) throws SQLException {
        this.database = database;
        this.config = database.getConfig();
        this.setJDBC(this.config);
        this.register();
        if (bl) {
            this.connectAndCreate(string, string2);
        }
    }

    public String setDefault(String string, String string2) {
        if (string == null || string.equals("")) {
            return string2;
        }
        return string;
    }

    public void setJDBC(ParseConfig parseConfig) {
        this.driverName = parseConfig.getJDBCDriver();
        this.dbaddress = parseConfig.getConnectionString();
        this.JDBCjarFileName = parseConfig.getJDBCJarFile();
        this.dbServerHostname = parseConfig.getDBHost();
        this.dbUseSSL = parseConfig.getDBUseSSL();
        this.dbKeystore = this.setDefault(parseConfig.getDBKeystore(), DEFAULT_KEYSTORE_PATH);
        this.dbKeystorePassword = this.setDefault(parseConfig.getDBKeystorePasswd(), "changeit");
        this.dbTruststore = this.setDefault(parseConfig.getDBTruststore(), DEFAULT_TRUSTSTORE_PATH);
        this.dbTruststorePassword = this.setDefault(parseConfig.getDBTruststorePasswd(), "changeit");
        this.dbUseKeys = new File(this.dbKeystore).exists();
        this.dbUseTrust = new File(this.dbTruststore).exists();
    }

    public void close() {
        try {
            if (this.conn.isClosed()) {
                return;
            }
            this.conn.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.conn.setAutoCommit(bl);
    }

    public void commit() throws SQLException {
        this.conn.commit();
    }

    public void rollback() throws SQLException {
        this.conn.rollback();
    }

    private static String findPassword(ParseConfig parseConfig) {
        String string = passwordMap.get(parseConfig.getPath());
        if (string == null && passwordCallback != null) {
            string = passwordCallback.getPassword(parseConfig);
            passwordMap.put(parseConfig.getPath(), string);
        }
        return string;
    }

    public boolean connect(String string, String string2) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            if (this.conn != null) {
                return true;
            }
            stringBuffer.append(this.getConnectString());
            Properties properties = new Properties();
            if (this.dbUseSSL) {
                properties.setProperty("user", string);
                properties.setProperty("ssl", "true");
                properties.setProperty("sslfactory", "edu.uoregon.tau.perfdmf.database.CustomSSLSocketFactory");
                if (this.dbUseTrust) {
                    System.setProperty("javax.net.ssl.trustStore", this.dbTruststore);
                    System.setProperty("javax.net.ssl.trustStorePassword", this.dbTruststorePassword);
                }
                if (this.dbUseKeys) {
                    System.setProperty("javax.net.ssl.keyStore", this.dbKeystore);
                    System.setProperty("javax.net.ssl.keyStorePassword", this.dbKeystorePassword);
                    CustomX509KeyManager.setClientAlias(string + "@" + this.dbServerHostname);
                } else {
                    if (string2 == null) {
                        string2 = DBConnector.findPassword(this.config);
                    }
                    properties.setProperty("password", string2);
                }
            } else {
                if (string2 == null) {
                    string2 = DBConnector.findPassword(this.config);
                }
                properties.setProperty("user", string);
                properties.setProperty("password", string2);
            }
            this.conn = DriverManager.getConnection(stringBuffer.toString(), properties);
            return true;
        }
        catch (SQLException sQLException) {
            System.err.println("Cannot connect to server.");
            System.err.println("Connection String: " + stringBuffer);
            System.err.println("Exception Message: " + sQLException.getMessage());
            sQLException.printStackTrace();
            throw sQLException;
        }
    }

    public void connectAndCreate(String string, String string2) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append(this.getConnectString());
            stringBuffer.append(";create=true");
            if (string2 == null) {
                string2 = DBConnector.findPassword(this.config);
            }
            this.conn = DriverManager.getConnection(stringBuffer.toString(), string, string2);
            this.conn.close();
            System.out.println("Database created, command: " + stringBuffer.toString());
        }
        catch (SQLException sQLException) {
            System.err.println("Cannot create database.");
            System.err.println("Connection String: " + stringBuffer);
            System.err.println("Exception Message: " + sQLException.getMessage());
            throw sQLException;
        }
    }

    public ResultSet executeQuery(String string) throws SQLException {
        if (this.statement == null) {
            if (this.conn == null) {
                System.err.println("Database is closed for " + string);
                return null;
            }
            this.statement = this.conn.createStatement();
        }
        return this.statement.executeQuery(string.trim());
    }

    public boolean execute(String string) throws SQLException {
        if (this.statement == null) {
            if (this.conn == null) {
                System.err.println("Database is closed for " + string);
                return false;
            }
            this.statement = this.conn.createStatement();
        }
        return this.statement.execute(string.trim());
    }

    public int executeUpdate(String string) throws SQLException {
        if (this.statement == null) {
            if (this.conn == null) {
                System.err.println("Database is closed for " + string);
                return 0;
            }
            this.statement = this.conn.createStatement();
        }
        return this.statement.executeUpdate(string.trim());
    }

    public Connection getConnection() {
        return this.conn;
    }

    public String getConnectString() {
        return this.dbaddress;
    }

    public String getDataItem(String string) throws SQLException {
        ResultSet resultSet = this.executeQuery(string);
        if (!resultSet.next()) {
            resultSet.close();
            return null;
        }
        String string2 = resultSet.getString(1);
        resultSet.close();
        return string2;
    }

    public boolean isClosed() {
        if (this.conn == null) {
            return true;
        }
        try {
            return this.conn.isClosed();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return true;
        }
    }

    public void register() {
        try {
            Object object;
            URL[] uRLArray = new URL[1];
            if (this.JDBCjarFileName.toLowerCase().startsWith("http:")) {
                if (this.JDBCjarFileName.toLowerCase().startsWith("http://") || this.JDBCjarFileName.toLowerCase().startsWith("http:/")) {
                    // empty if block
                }
                uRLArray[0] = new URL(this.JDBCjarFileName);
            } else {
                object = new File(this.JDBCjarFileName);
                if (!((File)object).exists()) {
                    System.err.println("Warning: file '" + this.JDBCjarFileName + "' does not exist!");
                }
                uRLArray[0] = System.getProperty("os.name").toLowerCase().trim().startsWith("windows") ? new URL("file:\\" + this.JDBCjarFileName.replace('\\', '/')) : new URL("file://" + this.JDBCjarFileName);
            }
            object = new URLClassLoader(uRLArray);
            try {
                Class<?> clazz = Class.forName(this.driverName, true, (ClassLoader)object);
                Driver driver = (Driver)clazz.newInstance();
                DriverManager.registerDriver(new DriverShim(driver));
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    Class.forName(this.driverName).newInstance();
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    System.err.println("Unable to load driver '" + this.driverName + "' from " + this.JDBCjarFileName);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.conn.getMetaData();
    }

    public void setDBAddress(String string) {
        this.dbaddress = string;
    }

    public String getDBType() {
        return new String(this.config.getDBType());
    }

    public String getSchemaPrefix() {
        if (this.getDBType().compareTo("oracle") == 0) {
            if (this.config.getDBSchemaPrefix() != null && this.config.getDBSchemaPrefix().compareTo("") != 0) {
                return new String(this.config.getDBSchemaPrefix() + ".");
            }
            return "";
        }
        if (this.getDBType().compareTo("db2") == 0) {
            if (this.config.getDBSchemaPrefix() != null && this.config.getDBSchemaPrefix().compareTo("") != 0) {
                return new String(this.config.getDBSchemaPrefix() + ".");
            }
            return "";
        }
        return "";
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        return this.getConnection().prepareStatement(string);
    }

    public static boolean isReadAbleType(int n) {
        return n == 12 || n == 2005 || n == 4 || n == -5 || n == 3 || n == 8 || n == 6 || n == -1 || n == 92 || n == 93 || n == -2 || n == -3 || n == -4 || n == 2004;
    }

    public static boolean isWritableType(int n) {
        return n == 12 || n == 2005 || n == 4 || n == 3 || n == 8 || n == 6 || n == -1 || n == -2 || n == -3 || n == -4 || n == 2004;
    }

    public static boolean isIntegerType(int n) {
        return n == 4;
    }

    public static boolean isFloatingPointType(int n) {
        if (n == 3) {
            return true;
        }
        if (n == 8) {
            return true;
        }
        return n == 6;
    }

    public int checkTable(DatabaseMetaData databaseMetaData, String string, Object[] objectArray) throws SQLException {
        int n;
        boolean[] blArray = new boolean[objectArray.length];
        ResultSet resultSet = null;
        resultSet = this.getDBType().compareTo("oracle") == 0 || this.getDBType().compareTo("derby") == 0 || this.getDBType().compareTo("h2") == 0 || this.getDBType().compareTo("db2") == 0 ? databaseMetaData.getColumns(null, null, string.toUpperCase(), "%") : databaseMetaData.getColumns(null, null, string, "%");
        while (resultSet.next()) {
            n = resultSet.getInt("DATA_TYPE");
            String string2 = resultSet.getString("COLUMN_NAME");
            String string3 = resultSet.getString("TYPE_NAME");
            if (!DBConnector.isReadAbleType(n)) continue;
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i].toString().toUpperCase().compareTo(string2.toUpperCase()) != 0) continue;
                blArray[i] = true;
            }
        }
        for (n = 0; n < objectArray.length; ++n) {
            if (blArray[n]) continue;
            System.out.println("Couldn't find column \"" + objectArray[n] + "\" in table \"" + string + "\"");
            return -1;
        }
        return 0;
    }

    public int checkSchema() throws SQLException {
        if (this.getSchemaVersion() > 0) {
            return this.checkTAUdbSchema();
        }
        DatabaseMetaData databaseMetaData = this.getMetaData();
        Object[] objectArray = new String[]{"ID", "NAME"};
        if (this.checkTable(databaseMetaData, "application", objectArray) != 0) {
            return -1;
        }
        Object[] objectArray2 = new String[]{"ID", "NAME", "application"};
        if (this.checkTable(databaseMetaData, "experiment", objectArray2) != 0) {
            return -1;
        }
        Object[] objectArray3 = new String[]{"ID", "NAME", "experiment"};
        if (this.checkTable(databaseMetaData, "trial", objectArray3) != 0) {
            return -1;
        }
        Object[] objectArray4 = new String[]{"id", "name", "trial"};
        if (this.checkTable(databaseMetaData, "metric", objectArray4) != 0) {
            return -1;
        }
        Object[] objectArray5 = new String[]{"id", "name", "trial", "group_name"};
        if (this.checkTable(databaseMetaData, "interval_event", objectArray5) != 0) {
            return -1;
        }
        Object[] objectArray6 = new String[]{"id", "name", "trial", "group_name"};
        if (this.checkTable(databaseMetaData, "atomic_event", objectArray6) != 0) {
            return -1;
        }
        Object[] objectArray7 = new String[]{"interval_event", "node", "context", "thread", "metric", "inclusive_percentage", "inclusive", "exclusive_percentage", "exclusive", "call", "subroutines", "inclusive_per_call"};
        if (this.getDBType().compareTo("oracle") == 0) {
            objectArray7[8] = "excl";
        } else if (this.getDBType().compareTo("derby") == 0) {
            objectArray7[9] = "num_calls";
        } else if (this.getDBType().compareTo("mysql") == 0) {
            objectArray7[9] = "call";
        }
        if (this.checkTable(databaseMetaData, "interval_location_profile", objectArray7) != 0) {
            return -1;
        }
        Object[] objectArray8 = new String[]{"atomic_event", "node", "context", "thread", "sample_count", "maximum_value", "minimum_value", "mean_value", "standard_deviation"};
        if (this.checkTable(databaseMetaData, "atomic_location_profile", objectArray8) != 0) {
            return -1;
        }
        Object[] objectArray9 = new String[]{"interval_event", "metric", "inclusive_percentage", "inclusive", "exclusive_percentage", "exclusive", "call", "subroutines", "inclusive_per_call"};
        if (this.getDBType().compareTo("oracle") == 0) {
            objectArray9[5] = "excl";
        } else if (this.getDBType().compareTo("derby") == 0) {
            objectArray9[6] = "num_calls";
        } else if (this.getDBType().compareTo("mysql") == 0) {
            objectArray9[6] = "call";
        }
        if (this.checkTable(databaseMetaData, "interval_total_summary", objectArray9) != 0) {
            return -1;
        }
        if (this.checkTable(databaseMetaData, "interval_mean_summary", objectArray9) != 0) {
            return -1;
        }
        return 0;
    }

    private int checkTAUdbSchema() throws SQLException {
        DatabaseMetaData databaseMetaData = this.getMetaData();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("version");
        if (this.checkTable(databaseMetaData, "schema_version", arrayList.toArray()) != 0) {
            return -1;
        }
        arrayList.clear();
        arrayList.add("id");
        arrayList.add("name");
        arrayList.add("description");
        if (this.checkTable(databaseMetaData, "data_source", arrayList.toArray()) != 0) {
            return -1;
        }
        arrayList.clear();
        arrayList.add("id");
        arrayList.add("name");
        if (this.checkTable(databaseMetaData, "trial", arrayList.toArray()) != 0) {
            return -1;
        }
        if (this.checkTable(databaseMetaData, "derived_thread_type", arrayList.toArray()) != 0) {
            return -1;
        }
        arrayList.clear();
        arrayList.add("trial");
        arrayList.add("name");
        arrayList.add("value");
        if (this.checkTable(databaseMetaData, "primary_metadata", arrayList.toArray()) != 0) {
            return -1;
        }
        if (this.checkTable(databaseMetaData, "secondary_metadata", arrayList.toArray()) != 0) {
            return -1;
        }
        arrayList.clear();
        arrayList.add("id");
        arrayList.add("trial");
        if (this.checkTable(databaseMetaData, "thread", arrayList.toArray()) != 0) {
            return -1;
        }
        arrayList.add("name");
        if (this.checkTable(databaseMetaData, "metric", arrayList.toArray()) != 0) {
            return -1;
        }
        if (this.checkTable(databaseMetaData, "timer", arrayList.toArray()) != 0) {
            return -1;
        }
        if (this.checkTable(databaseMetaData, "counter", arrayList.toArray()) != 0) {
            return -1;
        }
        arrayList.clear();
        arrayList.add("timer");
        if (this.checkTable(databaseMetaData, "timer_group", arrayList.toArray()) != 0) {
            return -1;
        }
        if (this.checkTable(databaseMetaData, "timer_parameter", arrayList.toArray()) != 0) {
            return -1;
        }
        if (this.checkTable(databaseMetaData, "timer_callpath", arrayList.toArray()) != 0) {
            return -1;
        }
        arrayList.clear();
        arrayList.add("timer_callpath");
        arrayList.add("thread");
        if (this.checkTable(databaseMetaData, "timer_call_data", arrayList.toArray()) != 0) {
            return -1;
        }
        arrayList.clear();
        arrayList.add("timer_call_data");
        arrayList.add("metric");
        arrayList.add("inclusive_value");
        arrayList.add("exclusive_value");
        arrayList.add("inclusive_percent");
        arrayList.add("exclusive_percent");
        arrayList.add("sum_exclusive_squared");
        if (this.checkTable(databaseMetaData, "timer_value", arrayList.toArray()) != 0) {
            return -1;
        }
        arrayList.clear();
        arrayList.add("counter");
        arrayList.add("thread");
        arrayList.add("sample_count");
        arrayList.add("minimum_value");
        arrayList.add("maximum_value");
        arrayList.add("mean_value");
        arrayList.add("standard_deviation");
        if (this.checkTable(databaseMetaData, "counter_value", arrayList.toArray()) != 0) {
            return -1;
        }
        arrayList.clear();
        arrayList.add("id");
        arrayList.add("parent");
        arrayList.add("name");
        if (this.checkTable(databaseMetaData, "taudb_view", arrayList.toArray()) != 0) {
            return -1;
        }
        arrayList.clear();
        arrayList.add("taudb_view");
        arrayList.add("table_name");
        arrayList.add("column_name");
        if (this.checkTable(databaseMetaData, "taudb_view_parameter", arrayList.toArray()) != 0) {
            return -1;
        }
        return 0;
    }

    public Database getDatabase() {
        return this.database;
    }

    public static void setPasswordCallback(PasswordCallback passwordCallback) {
        DBConnector.passwordCallback = passwordCallback;
    }

    public int getSchemaVersion() {
        if (this.schemaVersion == -1) {
            this.setSchemaVersion();
        }
        return this.schemaVersion;
    }

    private void setSchemaVersion() {
        boolean bl = false;
        try {
            ResultSet resultSet;
            String string;
            DatabaseMetaData databaseMetaData = this.getMetaData();
            String string2 = null;
            string2 = this.getDBType().compareTo("h2") == 0 ? "SCHEMA_VERSION" : "schema_version";
            ResultSet resultSet2 = databaseMetaData.getTables(null, null, string2, null);
            while (resultSet2.next()) {
                string = resultSet2.getString("TABLE_NAME");
                if (!string.equalsIgnoreCase("schema_version")) continue;
                bl = true;
            }
            if (bl && (resultSet = this.executeQuery(string = "SELECT version FROM " + this.getSchemaPrefix() + "schema_version")).next()) {
                this.schemaVersion = resultSet.getInt(1);
                return;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        this.schemaVersion = 0;
    }

    public static class DriverShim
    implements Driver {
        private Driver driver;

        DriverShim(Driver driver) {
            this.driver = driver;
        }

        public boolean acceptsURL(String string) throws SQLException {
            return this.driver.acceptsURL(string);
        }

        public Connection connect(String string, Properties properties) throws SQLException {
            return this.driver.connect(string, properties);
        }

        public int getMajorVersion() {
            return this.driver.getMajorVersion();
        }

        public int getMinorVersion() {
            return this.driver.getMinorVersion();
        }

        public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
            return this.driver.getPropertyInfo(string, properties);
        }

        public boolean jdbcCompliant() {
            return this.driver.jdbcCompliant();
        }

        public Logger getParentLogger() {
            return null;
        }
    }
}

