/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf.taudb;

import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.taudb.TAUdbSession;
import edu.uoregon.tau.perfdmf.taudb.TAUdbTrial;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TAUdbMetric
extends Metric {
    private TAUdbTrial trial = null;
    private TAUdbSession session = null;

    public TAUdbMetric(TAUdbSession tAUdbSession, int n, TAUdbTrial tAUdbTrial, String string, boolean bl) {
        this.metricID = n;
        this.dbMetricID = n;
        this.trialID = tAUdbTrial.getID();
        this.trial = tAUdbTrial;
        this.session = tAUdbSession;
        this.name = string;
        this.derivedMetric = bl;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public TAUdbTrial getTrial() {
        return this.trial;
    }

    public void setTrial(TAUdbTrial tAUdbTrial) {
        this.trial = tAUdbTrial;
    }

    public TAUdbSession getSession() {
        return this.session;
    }

    public void setSession(TAUdbSession tAUdbSession) {
        this.session = tAUdbSession;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    public boolean isDerived() {
        return this.derivedMetric;
    }

    public void setDerived(boolean bl) {
        this.derivedMetric = bl;
    }

    public static Map<Integer, TAUdbMetric> getMetrics(TAUdbSession tAUdbSession, TAUdbTrial tAUdbTrial) {
        if (tAUdbTrial.getMetrics() != null && tAUdbTrial.getMetrics().size() > 0) {
            return tAUdbTrial.getTAUdbMetrics();
        }
        HashMap<Integer, TAUdbMetric> hashMap = new HashMap<Integer, TAUdbMetric>();
        String string = "select id, name, derived from metric where trial = ?";
        try {
            PreparedStatement preparedStatement = tAUdbSession.getDB().prepareStatement(string);
            preparedStatement.setInt(1, tAUdbTrial.getID());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Integer n = resultSet.getInt(1);
                String string2 = resultSet.getString(2);
                boolean bl = resultSet.getBoolean(3);
                TAUdbMetric tAUdbMetric = new TAUdbMetric(tAUdbSession, n, tAUdbTrial, string2, bl);
                hashMap.put(n, tAUdbMetric);
            }
            resultSet.close();
            preparedStatement.close();
            tAUdbTrial.setMetrics(hashMap);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return hashMap;
    }

    public static void main(String[] stringArray) {
        TAUdbSession tAUdbSession = new TAUdbSession("callpath", false);
        TAUdbTrial tAUdbTrial = TAUdbTrial.getTrial(tAUdbSession, 1, false);
        Map<Integer, TAUdbMetric> map = TAUdbMetric.getMetrics(tAUdbSession, tAUdbTrial);
        for (Integer n : map.keySet()) {
            TAUdbMetric tAUdbMetric = map.get(n);
            System.out.println(tAUdbMetric.toString());
        }
        tAUdbSession.close();
    }
}

