/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf.taudb;

import edu.uoregon.tau.perfdmf.taudb.TAUdbSession;
import edu.uoregon.tau.perfdmf.taudb.TAUdbTimerGroup;
import edu.uoregon.tau.perfdmf.taudb.TAUdbTimerParameter;
import edu.uoregon.tau.perfdmf.taudb.TAUdbTrial;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TAUdbTimer {
    private TAUdbSession session = null;
    private int id = 0;
    private TAUdbTrial trial = null;
    private String name = null;
    private String shortName = null;
    private String sourceFile = null;
    private int lineNumber = 0;
    private int lineNumberEnd = 0;
    private int columnNumber = 0;
    private int columnNumberEnd = 0;
    private Set<TAUdbTimerGroup> groups;
    private Set<TAUdbTimerParameter> parameters;

    public TAUdbTimer() {
    }

    public TAUdbTimer(TAUdbSession tAUdbSession, int n, TAUdbTrial tAUdbTrial, String string, String string2, String string3, int n2, int n3, int n4, int n5) {
        this.session = tAUdbSession;
        this.id = n;
        this.trial = tAUdbTrial;
        this.name = string;
        this.shortName = string2;
        this.sourceFile = string3;
        this.lineNumber = n2;
        this.lineNumberEnd = n3;
        this.columnNumber = n4;
        this.columnNumberEnd = n5;
        this.groups = new HashSet<TAUdbTimerGroup>();
        this.parameters = new HashSet<TAUdbTimerParameter>();
    }

    public TAUdbSession getSession() {
        return this.session;
    }

    public void setSession(TAUdbSession tAUdbSession) {
        this.session = tAUdbSession;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    public TAUdbTrial getTrial() {
        return this.trial;
    }

    public void setTrial(TAUdbTrial tAUdbTrial) {
        this.trial = tAUdbTrial;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String string) {
        this.shortName = string;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(String string) {
        this.sourceFile = string;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int n) {
        this.lineNumber = n;
    }

    public int getLineNumberEnd() {
        return this.lineNumberEnd;
    }

    public void setLineNumberEnd(int n) {
        this.lineNumberEnd = n;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public void setColumnNumber(int n) {
        this.columnNumber = n;
    }

    public int getColumnNumberEnd() {
        return this.columnNumberEnd;
    }

    public void setColumnNumberEnd(int n) {
        this.columnNumberEnd = n;
    }

    public void addGroup(TAUdbTimerGroup tAUdbTimerGroup) {
        this.groups.add(tAUdbTimerGroup);
    }

    public void addParameter(TAUdbTimerParameter tAUdbTimerParameter) {
        this.parameters.add(tAUdbTimerParameter);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("name:" + this.name + ",");
        for (TAUdbTimerGroup object : this.groups) {
            stringBuilder.append(object.toString());
        }
        for (TAUdbTimerParameter tAUdbTimerParameter : this.parameters) {
            stringBuilder.append(tAUdbTimerParameter.toString());
        }
        return stringBuilder.toString();
    }

    public static TAUdbTimer getTimer(TAUdbSession tAUdbSession, TAUdbTrial tAUdbTrial, int n) {
        TAUdbTimer tAUdbTimer = null;
        String string = "select name, short_name, source_file, line_number, line_number_end, column_number, column_number_end from timer where id = ?;";
        try {
            PreparedStatement preparedStatement = tAUdbSession.getDB().prepareStatement(string);
            preparedStatement.setInt(1, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                String string3 = resultSet.getString(2);
                String string4 = resultSet.getString(3);
                int n2 = resultSet.getInt(4);
                int n3 = resultSet.getInt(5);
                int n4 = resultSet.getInt(6);
                int n5 = resultSet.getInt(7);
                tAUdbTimer = new TAUdbTimer(tAUdbSession, n, tAUdbTrial, string2, string3, string4, n2, n3, n4, n5);
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return tAUdbTimer;
    }

    public static Map<Integer, TAUdbTimer> getTimers(TAUdbSession tAUdbSession, TAUdbTrial tAUdbTrial) {
        if (tAUdbTrial.getTimers() != null && tAUdbTrial.getTimers().size() > 0) {
            return tAUdbTrial.getTimers();
        }
        HashMap<Integer, TAUdbTimer> hashMap = new HashMap<Integer, TAUdbTimer>();
        String string = "select id, name, short_name, source_file, line_number, line_number_end, column_number, column_number_end from timer where trial = ?;";
        try {
            PreparedStatement preparedStatement = tAUdbSession.getDB().prepareStatement(string);
            preparedStatement.setInt(1, tAUdbTrial.getID());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Integer n = resultSet.getInt(1);
                String string2 = resultSet.getString(2);
                String string3 = resultSet.getString(3);
                String string4 = resultSet.getString(4);
                int n2 = resultSet.getInt(5);
                int n3 = resultSet.getInt(6);
                int n4 = resultSet.getInt(7);
                int n5 = resultSet.getInt(8);
                TAUdbTimer tAUdbTimer = new TAUdbTimer(tAUdbSession, n, tAUdbTrial, string2, string3, string4, n2, n3, n4, n5);
                hashMap.put(n, tAUdbTimer);
            }
            resultSet.close();
            preparedStatement.close();
            tAUdbTrial.setTimers(hashMap);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        TAUdbTimerGroup.getTimerGroups(tAUdbSession, tAUdbTrial, hashMap);
        return hashMap;
    }

    public static void main(String[] stringArray) {
        TAUdbSession tAUdbSession = new TAUdbSession("callpath", false);
        TAUdbTrial tAUdbTrial = TAUdbTrial.getTrial(tAUdbSession, 1, false);
        Map<Integer, TAUdbTimer> map = TAUdbTimer.getTimers(tAUdbSession, tAUdbTrial);
        for (Integer n : map.keySet()) {
            TAUdbTimer tAUdbTimer = map.get(n);
            System.out.println(tAUdbTimer.toString());
        }
        tAUdbSession.close();
    }
}

