/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf.taudb;

import edu.uoregon.tau.perfdmf.taudb.TAUdbSession;
import edu.uoregon.tau.perfdmf.taudb.TAUdbTimer;
import edu.uoregon.tau.perfdmf.taudb.TAUdbTrial;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TAUdbTimerGroup {
    String name = null;
    List<TAUdbTimer> timers = null;

    public TAUdbTimerGroup(String string, TAUdbTimer tAUdbTimer) {
        this.name = string;
        this.timers = new ArrayList<TAUdbTimer>();
        this.timers.add(tAUdbTimer);
    }

    public void addTimer(TAUdbTimer tAUdbTimer) {
        this.timers.add(tAUdbTimer);
    }

    public String toString() {
        return this.name;
    }

    public static Map<String, TAUdbTimerGroup> getTimerGroups(TAUdbSession tAUdbSession, TAUdbTrial tAUdbTrial, Map<Integer, TAUdbTimer> map) {
        HashMap<String, TAUdbTimerGroup> hashMap = new HashMap<String, TAUdbTimerGroup>();
        String string = "select tg.group_name, tg.timer, t.trial from timer_group tg join timer t on tg.timer = t.id where t.trial = ?;";
        try {
            PreparedStatement preparedStatement = tAUdbSession.getDB().prepareStatement(string);
            preparedStatement.setInt(1, tAUdbTrial.getID());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                Integer n = resultSet.getInt(2);
                TAUdbTimer tAUdbTimer = map.get(n);
                TAUdbTimerGroup tAUdbTimerGroup = (TAUdbTimerGroup)hashMap.get(string2);
                if (tAUdbTimerGroup == null) {
                    tAUdbTimerGroup = new TAUdbTimerGroup(string2, tAUdbTimer);
                } else {
                    tAUdbTimerGroup.addTimer(tAUdbTimer);
                }
                tAUdbTimer.addGroup(tAUdbTimerGroup);
                tAUdbTrial.addTimerGroup(tAUdbTimerGroup);
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return hashMap;
    }

    public static void main(String[] stringArray) {
    }
}

